/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.XRe;
import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAnalyzedAudioFile;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import java.io.File;
import java.io.IOException;

public class OnsetAnalysisTests
extends BitwigStudioTestDataFileTest {
    @Override
    protected String getTopLevelDirectoryPath() {
        return "audio-file-analysis";
    }

    @Override
    protected boolean shouldCreateTestForFileType(eMc eMc2) {
        return eMc2 instanceof Jak;
    }

    @acS
    public void testBitwigVampPluginHostOnsetAnalyzer() {
        Gj2 gj22 = this.getApplication().RYd();
        this.check(gj22).IkS();
        File file = gj22.uwB();
        this.check(file).hFR();
        File file2 = this.getFile().HwE();
        File file3 = this.getOutputFile("detected.onsets");
        c c3 = new c(file, file3);
        c3.CwM(file2);
        this.check(file3).uwB();
        File file4 = this.getExpectedFile("onsets").HwE();
        J.CwM(file4);
        this.checkOnsetsAreCorrect(file3, file4);
    }

    @acS
    public void testOnsetAnalysisViaCache() {
        Gj2 gj22 = this.getApplication().RYd();
        this.check(gj22).IkS();
        File file = this.getFile().HwE();
        XnV xnV = gj22.CwM(new XRe(file));
        this.check(xnV).IkS();
        File file2 = gj22.uwB();
        this.check(file2).hFR();
        TestAnalyzedAudioFile testAnalyzedAudioFile = new TestAnalyzedAudioFile((BitwigStudioTest)this, xnV);
        s s2 = testAnalyzedAudioFile.CwM(file, file2);
        this.check(file2).hFR();
        File file3 = xnV.Opd(file2);
        this.check(s2).IkS();
        int n2 = s2.CwM();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = s2.CwM(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = s2.Opd(i2);
            this.check(d4).CwM(0.0, 2.0);
            d2 = d3;
        }
        File file4 = this.getExpectedFile("onsets").HwE();
        this.checkOnsetsAreCorrect(file3, file4);
    }

    private void checkOnsetsAreCorrect(File file, File file2) {
        this.check("onsets correct", file).CwM(file2, () -> {
            s s2 = this.loadOnsets(file);
            this.check(file2).uwB();
            s s3 = this.loadOnsets(file2);
            this.check("onset count", s2.CwM()).CwM(s3.CwM());
            int n2 = s2.CwM();
            this.check(n2 > 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2;
                double d3 = s2.CwM(i2);
                double d4 = Math.abs(d3 - (d2 = s3.CwM(i2)));
                this.check(d4 < 1.0E-4);
            }
        });
    }

    private s loadOnsets(File file) {
        s s2 = null;
        try {
            s2 = J.CwM(file);
        }
        catch (IOException iOException) {
            this.fail("load onsets file " + file.getAbsolutePath(), iOException);
        }
        this.check(s2).IkS();
        int n2 = s2.CwM();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = s2.CwM(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = s2.Opd(i2);
            this.check(d4).CwM(0.0, 2.0);
            d2 = d3;
        }
        return s2;
    }
}

