/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestDecimalValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestModulationSourceAtom;
import com.bitwig.flt.app.testing.TestModule;
import com.bitwig.flt.app.testing.TestModuleGrid;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestValueAtom;
import com.bitwig.flt.packaging.core.kLR;
import java.util.Map;
import java.util.UUID;

public class ModuleGridTests
extends BitwigStudioIntegrationTest {
    @acS
    public void addAndCopyPolyGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        testNativeDevice.urx().CwM(testNativeDevice, HK.Opd.m2i());
        testProject.WW1();
        testProject.urx();
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void addFxGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.zdJ);
        testNativeDevice.urx().CwM(testNativeDevice, HK.Opd.m2i());
        testProject.WW1();
        testProject.urx();
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void addAllModulesToPolyGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        for (Map.Entry entry : kLR.qKS.entrySet()) {
            if (!((String)entry.getValue()).endsWith(".bwmodule")) continue;
            TestModule testModule = testModuleGrid.CwM(n2, n3, (UUID)entry.getKey());
            n4 = Math.max(n4, testModule.AaH());
            if ((n2 += testModule.IkS()) <= 16) continue;
            n2 = 0;
            n3 += n4;
            n4 = 0;
        }
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void convertFilters() {
        UUID[] uUIDArray = new UUID[]{kLR.hyE, kLR.DRS, kLR.Vwr, kLR.Two, kLR.hr, kLR.NK3, kLR.crF};
        UUID uUID = kLR.NK3;
        for (UUID uUID2 : uUIDArray) {
            if (uUID == uUID2) continue;
            this.testConvertFilter(uUID, uUID2);
        }
    }

    private void testConvertFilter(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModule testModule = testModuleGrid.CwM(0, 3, uUID);
        TestModule testModule2 = testModuleGrid.CwM(0, 2, kLR.xLs);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.CwM("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        testModulationSourceAtom.CwM(testDecimalValueAtom, 0.5);
        this.check(testModulationSourceAtom.uwB()).CwM(1);
        testModule = testModule.CwM(uUID2);
        this.check(testModulationSourceAtom.uwB()).CwM(1);
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void convertOscillators() {
        UUID[] uUIDArray;
        UUID[] uUIDArray2 = uUIDArray = new UUID[]{kLR.AsR, kLR.MRc, kLR.Vaa, kLR.roY, kLR.qta, kLR.eob, kLR.jrh};
        int n2 = uUIDArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UUID uUID = kLR.AsR;
            UUID uUID2 = uUIDArray2[i2];
            if (uUID == uUID2) continue;
            this.testConvertOscillator(uUID, uUID2);
        }
    }

    private void testConvertOscillator(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModule testModule = testModuleGrid.CwM(-2, 3, kLR.AsR);
        TestModule testModule2 = testModuleGrid.CwM(0, 3, uUID);
        testModuleGrid.CwM(testModule, "OUT", testModule2, "PHASE_IN");
        this.check("Is mapped (pre)", testModule2.Opd("PHASE_IN").LTX());
        testModule2 = testModule2.CwM(uUID2);
        this.check("Is mapped (post)", testModule2.Opd("PHASE_IN").LTX());
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void convertEnvelopes() {
        UUID[] uUIDArray;
        for (UUID uUID : uUIDArray = new UUID[]{kLR.KkY, kLR.eBa, kLR.Gt, kLR.k3r}) {
            for (UUID uUID2 : uUIDArray) {
                if (uUID == uUID2) continue;
                this.testConvertEnvelope(kLR.Gt, uUID2);
            }
        }
    }

    private void testConvertEnvelope(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModule testModule = testModuleGrid.CwM(0, 3, kLR.crF);
        TestModule testModule2 = testModuleGrid.CwM(0, 2, uUID);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.CwM("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.CwM("CONTENTS/ENVELOPE", TestModulationSourceAtom.class);
        testModulationSourceAtom.CwM(testDecimalValueAtom, 0.5);
        this.check("Pre count", testModulationSourceAtom.uwB()).CwM(1);
        testModule2 = testModule2.CwM(uUID2);
        TestModulationSourceAtom testModulationSourceAtom2 = (TestModulationSourceAtom)testModule2.CwM("CONTENTS/ENVELOPE", TestModulationSourceAtom.class);
        this.check("Post count", testModulationSourceAtom2.uwB()).CwM(1);
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void convertLFOsWithAuxiliaryModulation() {
        UUID[] uUIDArray;
        for (UUID uUID : uUIDArray = new UUID[]{kLR.xLs, kLR.ocM}) {
            for (UUID uUID2 : uUIDArray) {
                for (UUID uUID3 : uUIDArray) {
                    for (UUID uUID4 : uUIDArray) {
                        if (uUID == uUID2 || uUID3 == uUID4) continue;
                        this.testConvertLFOsWithAuxiliaryModulation(uUID, uUID2, uUID3, uUID4);
                    }
                }
            }
        }
    }

    private void testConvertLFOsWithAuxiliaryModulation(UUID uUID, UUID uUID2, UUID uUID3, UUID uUID4) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModule testModule = testModuleGrid.CwM(0, 3, kLR.crF);
        TestModule testModule2 = testModuleGrid.CwM(0, 2, uUID);
        TestModule testModule3 = testModuleGrid.CwM(0, 5, uUID3);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.CwM("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestModulationSourceAtom testModulationSourceAtom2 = (TestModulationSourceAtom)testModule3.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        testModulationSourceAtom.CwM((TestValueAtom)testDecimalValueAtom, 0.5, true, YqQ.CwM, testModulationSourceAtom2);
        this.check("Pre mod count", testModulationSourceAtom.uwB()).CwM(1);
        this.check("Pre aux count", testModulationSourceAtom2.dhb()).CwM(1);
        testModule2 = testModule2.CwM(uUID2);
        testModule3 = testModule3.CwM(uUID4);
        TestModulationSourceAtom testModulationSourceAtom3 = (TestModulationSourceAtom)testModule2.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestModulationSourceAtom testModulationSourceAtom4 = (TestModulationSourceAtom)testModule3.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        this.check("Post aux count", testModulationSourceAtom3.uwB()).CwM(1);
        this.check("Post mod count", testModulationSourceAtom4.dhb()).CwM(1);
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void disableLongDelayFeedback() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModule testModule = testModuleGrid.CwM(0, 3, kLR.Vaa);
        TestModule testModule2 = testModuleGrid.CwM(-2, 3, kLR.SAW);
        testModuleGrid.CwM(testModule2, "OUT", testModule, "PHASE_IN");
        testModuleGrid.CwM(testModule, "OUT", testModule2, "IN");
        testProject.CwM(new OMl[0]);
        testModule2.Opd(false);
        testModuleGrid.CwM(testModule, "PHASE_IN");
        testProject.WW1();
        testProject.urx();
    }

    @acS
    public void deleteLongDelayFeedback() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModule testModule = testModuleGrid.CwM(0, 3, kLR.Vaa);
        TestModule testModule2 = testModuleGrid.CwM(-2, 3, kLR.SAW);
        testModuleGrid.CwM(testModule2, "OUT", testModule, "PHASE_IN");
        testModuleGrid.CwM(testModule, "OUT", testModule2, "IN");
        testProject.CwM(new OMl[0]);
        testModule2.K_();
        testProject.WW1();
        testProject.urx();
    }

    @acS
    public void copyModuleWithModulationRoutingsToSameGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestNativeDevice testNativeDevice2 = testNativeDevice.Opd("CONTENTS/POST_FX").LTX().aMy().CwM(0, kLR.IkS);
        TestModule testModule = testModuleGrid.CwM(0, 2, kLR.xLs);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testNativeDevice2.CwM("CONTENTS/FREQ", TestDecimalValueAtom.class);
        testModulationSourceAtom.CwM(testDecimalValueAtom, 0.5);
        testProject.CwM(new OMl[0]);
        testModuleGrid.CwM(0, 4).CwM(testModule, HK.Opd.m2i());
        testProject.CwM(new OMl[0]);
    }

    @acS
    public void copyModuleWithModulationRoutingsToOtherGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestTrack testTrack2 = testProject.CwM(glQ.CwM);
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestDeviceChain testDeviceChain2 = testTrack2.aMy();
        testTrack.Opd("Source");
        testTrack2.Opd("Dest");
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, kLR.lDH);
        TestNativeDevice testNativeDevice2 = testDeviceChain2.CwM(0, kLR.lDH);
        TestModuleGrid testModuleGrid = testNativeDevice.HwE();
        TestModuleGrid testModuleGrid2 = testNativeDevice2.HwE();
        TestNativeDevice testNativeDevice3 = testNativeDevice.Opd("CONTENTS/POST_FX").LTX().aMy().CwM(0, kLR.IkS);
        TestModule testModule = testModuleGrid.CwM(0, 2, kLR.xLs);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule.CwM("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testNativeDevice3.CwM("CONTENTS/FREQ", TestDecimalValueAtom.class);
        testModulationSourceAtom.CwM(testDecimalValueAtom, 0.5);
        testProject.CwM(new OMl[0]);
        testModuleGrid2.CwM(0, 3).CwM(testModule, HK.Opd.m2i());
        testProject.CwM(new OMl[0]);
    }
}

