/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.Bmg;
import java.util.concurrent.TimeUnit;

public class MidiExpressionEvaluationTests
extends BitwigStudioIntegrationTest {
    @acS
    public void testEvaluteStatus() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.testEvaluation("status", i2, 0, 0, i2);
        }
    }

    @acS
    public void testEvaluteData1() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.testEvaluation("data1", 0, i2, 0, i2);
        }
    }

    @acS
    public void testEvaluteData2() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.testEvaluation("data2", 0, 0, i2, i2);
        }
    }

    @acS
    public void testEvaluateEvent() {
        this.testEvaluation("event", 1, 2, 3, 66051);
    }

    @acS
    public void testEvaluateBoolAnd() {
        this.testEvaluation("true && false", 0, 0, 0, 0);
        this.testEvaluation("true && true", 0, 0, 0, 1);
        this.testEvaluation("false && false", 0, 0, 0, 0);
        this.testEvaluation("false && true", 0, 0, 0, 0);
    }

    @acS
    public void testEvaluateBoolOr() {
        this.testEvaluation("true || false", 0, 0, 0, 1);
        this.testEvaluation("true || true", 0, 0, 0, 1);
        this.testEvaluation("false || false", 0, 0, 0, 0);
        this.testEvaluation("false || true", 0, 0, 0, 1);
    }

    @acS
    public void testEvaluateEquals() {
        this.testEvaluation("status == 10", 10, 0, 0, 1);
        this.testEvaluation("status == 10", 5, 0, 0, 0);
        this.testEvaluation("10 == status", 10, 0, 0, 1);
        this.testEvaluation("10 == status", 5, 0, 0, 0);
    }

    @acS
    public void testEvaluateNotEquals() {
        this.testEvaluation("status != 10", 10, 0, 0, 0);
        this.testEvaluation("status != 10", 5, 0, 0, 1);
        this.testEvaluation("10 != status", 10, 0, 0, 0);
        this.testEvaluation("10 != status", 5, 0, 0, 1);
    }

    @acS
    public void testEvaluateLessThan() {
        this.testEvaluation("status < data1", 10, 10, 0, 0);
        this.testEvaluation("status < data1", 10, 11, 0, 1);
    }

    @acS
    public void testEvaluateLessThanEquals() {
        this.testEvaluation("status <= data1", 10, 9, 0, 0);
        this.testEvaluation("status <= data1", 10, 10, 0, 1);
        this.testEvaluation("status <= data1", 10, 11, 0, 1);
    }

    @acS
    public void testEvaluateGreaterThan() {
        this.testEvaluation("status > data1", 10, 10, 0, 0);
        this.testEvaluation("status > data1", 11, 10, 0, 1);
    }

    @acS
    public void testEvaluateGreaterThanEquals() {
        this.testEvaluation("status >= data1", 9, 10, 0, 0);
        this.testEvaluation("status >= data1", 10, 10, 0, 1);
        this.testEvaluation("status >= data1", 11, 10, 0, 1);
    }

    @acS
    public void testEvaluateIsCCValueExpression() {
        this.testEvaluation(pZs.CwM(0, 32, 16), 176, 32, 16, 1);
        this.testEvaluation(pZs.CwM(7, 32, 16), 183, 32, 16, 1);
        this.testEvaluation(pZs.CwM(0, 32, 16), 177, 32, 16, 0);
        this.testEvaluation(pZs.CwM(0, 32, 16), 192, 32, 16, 0);
        this.testEvaluation(pZs.CwM(0, 32, 16), 176, 33, 16, 0);
        this.testEvaluation(pZs.CwM(0, 32, 16), 176, 32, 17, 0);
    }

    private void testEvaluation(String string, int n2, int n3, int n4, int n5) {
        this.testEvaluation(string, new bnl(n2, n3, n4), n5);
    }

    private void testEvaluation(String string, bnl bnl2, int n2) {
        Bmg bmg2 = this.getApplication();
        pZs pZs2 = pZs.Opd(string);
        int n3 = pZs2.Opd(bnl2);
        this.check("java result", n3).CwM(n2);
        sGP sGP2 = new sGP();
        bmg2.CwM(pZs2, bnl2, sGP2);
        int n4 = (Integer)this.waitForAsyncTask("Evaluate " + string + " with status = " + bnl2.WW1() + " data1 = " + bnl2.urx() + " data2 = " + bnl2.nSA(), sGP2, 5L, TimeUnit.SECONDS);
        this.check("engine result", n4).CwM(n2);
    }
}

