/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.CH;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestChainSelector;
import com.bitwig.flt.app.testing.TestChainSelectorIndexedValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestEnumAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestIndexedValueAtom;
import com.bitwig.flt.app.testing.TestIndexedValueType;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestNestedDeviceChain;
import com.bitwig.flt.app.testing.TestPermanentAutomationLane;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import com.bitwig.flt.app.testing.TestTrackOrTrackGroup;
import com.bitwig.flt.document.core.master.device.pNN;
import java.util.UUID;

public abstract class ChainSelectorTests
extends BitwigStudioIntegrationTest {
    protected abstract UUID getDeviceId();

    protected abstract glQ getTrackType();

    private TestChainSelector createAndGetChainSelector() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        return (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
    }

    @acS
    public void checkAddDeleteSimple() {
        TestChainSelector testChainSelector = this.createAndGetChainSelector();
        this.check("ChainSelectorEmpty", testChainSelector.dhb()).CwM(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.LTX().uwB()).CwM(0);
        testChainSelector.uwB();
        this.check("ChainSelectorEmpty", testChainSelector.dhb()).CwM(1);
        this.check("SelectedIndexWhileEmpty", testChainSelector.LTX().uwB()).CwM(0);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.OqD(0);
        testNestedDeviceChain.K_();
        this.check("ChainSelectorEmpty", testChainSelector.dhb()).CwM(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.LTX().uwB()).CwM(0);
    }

    @acS
    public void checkAddDeleteComplex() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.uwB();
            this.check("chainCount", testChainSelector.dhb()).CwM(i2 + 1);
            String string = "Test Chain " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain = testChainSelector.OqD(i2);
            testNestedDeviceChain.Opd(string);
            this.check("title", testNestedDeviceChain.uwB()).CwM(string);
            this.check("displayedTitle", testNestedDeviceChain.dhb()).CwM(string);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.LTX();
        this.check("indexInit", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelector.uwB();
        this.check("indexAfterAddChain", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        this.check("chainCount", testChainSelector.dhb()).CwM(6);
        testChainSelector.OqD(0).K_();
        this.check("indexAfterRemoveChain", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        this.check("chainCount", testChainSelector.dhb()).CwM(5);
        testChainSelector.OqD(1).K_();
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        this.check("chainCount", testChainSelector.dhb()).CwM(4);
        testChainSelectorIndexedValueAtom.Opd(2);
        testChainSelector.OqD(0).K_();
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        this.check("chainCount", testChainSelector.dhb()).CwM(3);
        testChainSelectorIndexedValueAtom.Opd(2);
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        testChainSelector.OqD(2).K_();
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        this.check("chainCount", testChainSelector.dhb()).CwM(2);
    }

    @acS
    public void checkMoveToFirst() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.uwB();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.LTX();
        testChainSelectorIndexedValueAtom.Opd(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.OqD(0);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.OqD(2);
        testNestedDeviceChain.IkS().CwM(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.dhb()).CwM(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).CwM(testChainSelector.OqD(0));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).CwM(testChainSelector.OqD(1));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
    }

    public void checkMoveToLast() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.uwB();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.LTX();
        testChainSelectorIndexedValueAtom.Opd(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.OqD(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.OqD(2);
        testNestedDeviceChain.EuM().CwM(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.dhb()).CwM(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).CwM(testChainSelector.OqD(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).CwM(testChainSelector.OqD(3));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.uwB()).CwM(4);
    }

    @acS
    public void checkDuplicate() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.uwB();
        }
        testTrack.J_().alk();
        TestTrackGroup testTrackGroup = testProject.dhb();
        TestTrackOrTrackGroup testTrackOrTrackGroup = testTrackGroup.Opd(1);
        TestNativeDevice testNativeDevice2 = testTrackOrTrackGroup.aMy().OqD(0);
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.CwM(pNN.class), TestChainSelector.class);
        this.check("chainsCount", testChainSelector2.dhb()).equals(5);
    }

    @acS
    public void checkPrevNextArrows() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.LTX();
        this.check("index when empty", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index when empty after selectNextValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index when empty after selectPrevValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index when empty after cycleNextValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index when empty after cyclePrevValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelector.uwB();
        this.check("index with a single chain", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index with a single chain after selectNextValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index with a single chain after selectPrevValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index with a single chain after cycleNextValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index with a single chain after cyclePrevValue()", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelector.uwB();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index next at end", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index prev", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelector.uwB();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        testChainSelectorIndexedValueAtom.dhb();
        this.check("index next at end", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index prev", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index prev", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.aMy();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        testChainSelectorIndexedValueAtom.alk();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(2);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(1);
        testChainSelectorIndexedValueAtom.EuM();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
    }

    @acS
    public void checkAutomation() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.uwB();
        }
        this.check("chainCount", testChainSelector.dhb()).CwM(5);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.LTX();
        TestIndexedValueType testIndexedValueType = testChainSelectorIndexedValueAtom.LTX();
        this.check("indexValueTypeIsAutomatable", testIndexedValueType.LTX());
        this.check("indexValueTypeIsInterpolated", !testIndexedValueType.uwB());
        testChainSelectorIndexedValueAtom.IkS();
        TestPermanentAutomationLane testPermanentAutomationLane = testTrack.CwM(testChainSelectorIndexedValueAtom);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testPermanentAutomationLane.LTX();
        TestEnumAutomationEventTimeline testEnumAutomationEventTimeline = testArrangementAutomationTimeline.uwB();
        this.check("valueTypeEquals", testPermanentAutomationLane.CwM(TestIndexedValueType.class)).CwM(testIndexedValueType);
        for (int i3 = 0; i3 < 5; ++i3) {
            testEnumAutomationEventTimeline.CwM(i3, i3);
        }
        this.check("automationHasEvents", testPermanentAutomationLane.uwB());
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.OqD(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.OqD(2);
        testNestedDeviceChain.EuM().CwM(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.dhb()).CwM(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).CwM(testChainSelector.OqD(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).CwM(testChainSelector.OqD(3));
        this.check("automationEventsCount", testEnumAutomationEventTimeline.uwB()).CwM(5);
        this.check("valueAt0", testEnumAutomationEventTimeline.CwM(0.0).LTX()).equals(0);
        this.check("valueAt1", testEnumAutomationEventTimeline.CwM(1.0).LTX()).equals(1);
        this.check("valueAt2", testEnumAutomationEventTimeline.CwM(2.0).LTX()).equals(3);
        this.check("valueAt3", testEnumAutomationEventTimeline.CwM(3.0).LTX()).equals(4);
        this.check("valueAt4", testEnumAutomationEventTimeline.CwM(4.0).LTX()).equals(2);
    }

    @acS
    public void checkMoveBetweenTwoDevices() {
        Object object;
        TestNestedDeviceChain testNestedDeviceChain;
        Object object2;
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.CwM(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.aMy();
        TestNativeDevice testNativeDevice = testDeviceChain.CwM(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.CwM(pNN.class), TestChainSelector.class);
        TestNativeDevice testNativeDevice2 = testDeviceChain.CwM(1, this.getDeviceId());
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.CwM(pNN.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.uwB();
            testChainSelector2.uwB();
            this.check("chainCount1", testChainSelector.dhb()).CwM(i2 + 1);
            this.check("chainCount2", testChainSelector2.dhb()).CwM(i2 + 1);
            object2 = "Test Chain1 " + (i2 + 1);
            testNestedDeviceChain = testChainSelector.OqD(i2);
            testNestedDeviceChain.Opd((String)object2);
            this.check("title", testNestedDeviceChain.uwB()).CwM((String)object2);
            this.check("displayedTitle", testNestedDeviceChain.dhb()).CwM((String)object2);
            object = "Test Chain2 " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector2.OqD(i2);
            testNestedDeviceChain2.Opd((String)object);
            this.check("title", testNestedDeviceChain2.uwB()).CwM((String)object);
            this.check("displayedTitle", testNestedDeviceChain2.dhb()).CwM((String)object);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.LTX();
        this.check("indexInit1", testChainSelectorIndexedValueAtom.uwB()).CwM(0);
        object2 = testChainSelector2.LTX();
        this.check("indexInit2", ((TestIndexedValueAtom)object2).uwB()).CwM(0);
        testChainSelectorIndexedValueAtom.Opd(2);
        ((TestIndexedValueAtom)object2).Opd(2);
        testNestedDeviceChain = testChainSelector.OqD(2);
        object = testChainSelector2.OqD(2);
        testNestedDeviceChain.EuM().CwM((CH)object);
        this.check("index1", testChainSelector.LTX().uwB()).CwM(2);
        this.check("chainsCount1", testChainSelector.dhb()).CwM(6);
        this.check("index2", testChainSelector2.LTX().uwB()).CwM(2);
        this.check("chainsCount2", testChainSelector2.dhb()).CwM(4);
    }
}

