/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.flt.app.testing.Oly;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioSource;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.tests.AudioRecordingOrBouncingTests;
import com.bitwig.flt.app.testing.tests.qrx;
import java.io.File;
import java.util.Collection;

public abstract class BounceTests
extends AudioRecordingOrBouncingTests {
    private sTG mSampleBitDepth;
    private Boolean mShouldBounceInRealtime;

    @Override
    public String getTestName() {
        if (this.mShouldBounceInRealtime != null) {
            if (this.mSampleBitDepth == null) {
                return this.mShouldBounceInRealtime != false ? "realtime" : "offline";
            }
        } else {
            return this.getClass().getSimpleName();
        }
        return super.getTestName();
    }

    @Override
    protected String getMethodNodeName() {
        return this.mSampleBitDepth.OqD();
    }

    @Override
    protected void listChildren(Collection collection) {
        if (this.mShouldBounceInRealtime == null) {
            BounceTests bounceTests = (BounceTests)this.createChild();
            bounceTests.mShouldBounceInRealtime = Boolean.FALSE;
            collection.add(bounceTests);
            BounceTests bounceTests2 = (BounceTests)this.createChild();
            bounceTests2.mShouldBounceInRealtime = Boolean.TRUE;
            collection.add(bounceTests2);
        } else if (this.mSampleBitDepth == null) {
            for (sTG sTG2 : sTG.values()) {
                BounceTests bounceTests = (BounceTests)this.createChild();
                bounceTests.mSampleBitDepth = sTG2;
                collection.add(bounceTests);
            }
        } else {
            super.listChildren(collection);
        }
    }

    @Override
    protected TestAudioNoteClipEvent recordClip(TestProject testProject, TestTrack testTrack, double d2, double d3, qrx qrx2) {
        File file = this.getExpectedRecordedFile();
        file.delete();
        TestAudioSource testAudioSource = testTrack.nSA();
        Op2 op2 = (Op2)this.get(() -> this.createBounceRequest((ian)testAudioSource.m2i(), d2, d3, file));
        op2.CwM(qrx2.ordinal());
        try {
            TestAudioNoteClipEvent testAudioNoteClipEvent = testAudioSource.CwM(op2, this.mSampleBitDepth, this.mShouldBounceInRealtime);
            if (qrx2 != qrx.CwM) {
                this.fail("Should have reported error bouncing");
            }
            return testAudioNoteClipEvent;
        }
        catch (Oly oly) {
            if (qrx2 == qrx.CwM) {
                throw oly;
            }
            return oly.CwM();
        }
    }

    protected abstract Op2 createBounceRequest(ian var1, double var2, double var4, File var6);

    @Override
    protected File getExpectedRecordedFile() {
        return this.getOutputFile(this.mSampleBitDepth + (this.mShouldBounceInRealtime != false ? "-realtime" : "") + ".wav", false);
    }

    @Override
    protected int getExpectedBitsPerSample() {
        switch (this.mSampleBitDepth) {
            case OqD: {
                return 32;
            }
            case CwM: {
                return 16;
            }
            case Opd: {
                return 24;
            }
        }
        this.fail("Unknown sample bit depeth");
        return 0;
    }

    @Override
    protected Class getErrorNotificationType() {
        return viu.class;
    }
}

