/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.XRe;
import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTempoAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.qrx;
import java.io.File;

public abstract class AudioRecordingOrBouncingTests
extends BitwigStudioIntegrationTest {
    @acS(m2i=false)
    public void testRecordingAudio() {
        this.testRecordingAudio(0.0, 4.0, 120.0);
    }

    @acS(m2i=false)
    public void testRecordingShortAudio() {
        double d2 = 120.0;
        this.testRecordingAudio(0.0, L.CwM(this.getBlockBeatLength(120.0) * 2.0), 120.0);
    }

    private void testRecordingAudio(double d2, double d3, double d4) {
        this.checkBeatTime(d2).hFR().m2i(0.0);
        this.checkBeatTime("record duration", d3).hFR().OqD(0.0);
        TestProject testProject = this.createTestProject(1, 0);
        testProject.EuM();
        TestTransport testTransport = testProject.uwB();
        testTransport.uwB().CwM(d4);
        TestTrack testTrack = testProject.CwM(glQ.Opd);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, d2, d3, qrx.CwM);
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, d3, this.getExpectedDurationInBeatsTolerance(d4), this.getExpectedRecordedFile(), qrx.CwM);
    }

    protected File getExpectedRecordedFile() {
        return null;
    }

    @acS(m2i=false)
    public void testRecordingAudioWithIOErrorOnOpen() {
        this.testRecordingAudioWithError(qrx.Opd);
    }

    @acS(m2i=false)
    public void testRecordingAudioWithIOErrorOnWrite() {
        this.testRecordingAudioWithError(qrx.OqD);
    }

    @acS(m2i=false)
    public void testRecordingAudioWithIOErrorOnClose() {
        this.testRecordingAudioWithError(qrx.m2i);
    }

    private void testRecordingAudioWithError(qrx qrx2) {
        double d2;
        double d3;
        this.check(qrx2 != qrx.CwM);
        this.check("no error with recording audio so far", this.getFirstNotificationOfType(this.getErrorNotificationType())).EuM();
        TestProject testProject = this.createTestProject(1, 0);
        testProject.EuM();
        double d4 = testProject.uwB().uwB().LTX();
        TestTrack testTrack = testProject.CwM(glQ.Opd);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 4.0, qrx2);
        if (qrx2 == qrx.Opd || qrx2 == qrx.OqD) {
            d3 = 0.0;
            d2 = 0.0;
        } else {
            d3 = 0.0;
            d2 = 0.0;
        }
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, 4.0, this.getExpectedDurationInBeatsTolerance(d4), d3, d2, this.getExpectedRecordedFile(), qrx2);
        this.check("error notification was shown", this.getFirstNotificationOfType(this.getErrorNotificationType())).IkS();
    }

    @acS(m2i=false)
    public void testRecordingAudioWithTempoAutomation() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.EuM();
        TestTransport testTransport = testProject.uwB();
        testTransport.uwB().IkS();
        TestTrack testTrack = testProject.CwM(glQ.Opd);
        TestTempoAutomationEventTimeline testTempoAutomationEventTimeline = (TestTempoAutomationEventTimeline)this.cast(testProject.dhb().EuM().Opd(testTransport.uwB()).LTX(), TestTempoAutomationEventTimeline.class);
        double d2 = 120.0;
        int n2 = 24;
        double d3 = 200.0;
        int n3 = 8;
        int n4 = 16;
        int n5 = 4;
        testTempoAutomationEventTimeline.CwM(0.0, 120.0);
        testTempoAutomationEventTimeline.CwM(8.0, 200.0);
        testTempoAutomationEventTimeline.CwM(16.0, 200.0);
        testTempoAutomationEventTimeline.CwM(24.0, 120.0);
        int n6 = 66;
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 24.0, qrx.CwM);
        this.check("recorded clip", testAudioNoteClipEvent).IkS();
        this.check("start time", testAudioNoteClipEvent.AaH()).CwM(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.CwM(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.uwB()).CwM(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.Opd(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.AaH()).CwM(0.0);
        this.check(!testAudioNoteEvent.IkS());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.uwB();
        TestSampleReference testSampleReference = testAudioNoteEvent.LTX();
        testSampleReference.dhb();
        this.check("warp event count", testWarpEventTimeline.uwB()).CwM(66);
        double d4 = testSampleReference.aMy();
        double d5 = 24.0;
        this.check(!testSampleReference.uwB());
        String string = testSampleReference.LTX().LTX().LTX();
        File file = new File(string);
        this.check("recorded file", file).uwB().alk().Opd(0L);
        bVy bVy2 = bVy.Opd(skj.OqD(file));
        double d6 = bVy2.nSA();
        this.check("file duration", d6).Opd(d4, 7.0);
        bVz bVz2 = bVy2.IwJ();
        this.check("metadata chunk", bVz2).IkS();
        bVx bVx2 = bVz2.CwM();
        this.check("warp markers", bVx2).IkS();
        int n7 = bVx2.OqD();
        this.check("warp marker count", n7).CwM(66);
        for (int i2 = 0; i2 < 32; ++i2) {
            double d7 = (double)i2 / 4.0;
            double d8 = testProject.CwM(d7);
            this.checkWarpMarkerWithTempoAutomation(i2, bVx2, testWarpEventTimeline, d7, d8);
        }
        this.checkWarpMarkerWithTempoAutomation(n7 - 1, bVx2, testWarpEventTimeline, 24.0, d6);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, bVx2);
    }

    private void checkWarpMarkerWithTempoAutomation(int n2, bVx bVx2, TestWarpEventTimeline testWarpEventTimeline, double d2, double d3) {
        bVw bVw2 = bVx2.CwM(n2);
        double d4 = bVw2.Opd();
        this.check("warp marker beat time " + n2, d4).CwM(d2, 3);
        if (n2 > 0 && n2 < bVx2.OqD() - 1) {
            this.checkBeatTime("warp marker " + n2 + " beat time", d4).LTX();
        }
        this.check("warp marker sample time " + n2, bVw2.CwM()).CwM(d3, 1);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.Opd(n2), TestWarpEvent.class);
        double d5 = testWarpEvent.AaH();
        this.checkBeatTime("warp event beat time " + n2, d5).hFR();
        if (n2 > 0 && n2 < bVx2.OqD() - 1) {
            this.checkBeatTime("warp event beat time " + n2, d4).LTX();
        }
        this.check("warp event sample time " + n2, testWarpEvent.LTX()).CwM(bVw2.CwM());
    }

    protected abstract TestAudioNoteClipEvent recordClip(TestProject var1, TestTrack var2, double var3, double var5, qrx var7);

    protected double getExpectedDurationInBeatsTolerance(double d2) {
        return 0.0;
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, File file, qrx qrx2) {
        double d5 = d3 / d2 * 60.0;
        double d6 = d4 != 0.0 ? d4 / d2 * 60.0 : 1.0 / (double)this.getSampleRate();
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d2, d3, d4, d5, d6, file, qrx2);
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, double d5, double d6, File file, qrx qrx2) {
        this.check("clip", testAudioNoteClipEvent).IkS();
        this.check("start time", testAudioNoteClipEvent.AaH()).CwM(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.CwM(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.uwB()).CwM(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.Opd(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.AaH()).CwM(0.0);
        this.check("!isBeingRecorded", !testAudioNoteEvent.IkS());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.uwB();
        int n2 = testWarpEventTimeline.uwB();
        this.check("warp event count", n2).CwM(2);
        TestSampleReference testSampleReference = testAudioNoteEvent.LTX();
        testSampleReference.dhb();
        double d7 = testSampleReference.aMy();
        if (qrx2 == qrx.CwM) {
            this.check("sample ref duration", d7).Opd(d5, d6);
        }
        double d8 = testAudioNoteClipEvent.dhb();
        this.checkBeatTime("clip duration", d8).hFR().Opd(d3, d4);
        this.check("event duration", testAudioNoteEvent.dhb()).CwM(d8);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.Opd(0), TestWarpEvent.class);
        this.check("first warp event time", testWarpEvent.AaH()).CwM(0.0);
        this.check("first warp event sample time", testWarpEvent.LTX()).CwM(0.0);
        TestWarpEvent testWarpEvent2 = (TestWarpEvent)this.cast(testWarpEventTimeline.Opd(n2 - 1), TestWarpEvent.class);
        this.check("last warp event time", testWarpEvent2.AaH()).CwM(d8);
        if (qrx2 == qrx.CwM) {
            this.check("last warp event sample time", testWarpEvent2.LTX()).CwM(d7);
        }
        this.check(!testSampleReference.uwB());
        String string = testSampleReference.LTX().LTX().LTX();
        File file2 = new File(string);
        if (file != null) {
            this.check(file.getPath()).CwM(file2.getPath());
        }
        if (qrx2 == qrx.CwM) {
            this.checkAudioFile(file2, d7, d8);
        }
    }

    protected void checkAudioFile(File file, double d2, double d3) {
        this.check("file", file).uwB().alk().Opd(0L);
        bVy bVy2 = bVy.Opd(skj.OqD(file));
        this.check("sample rate correct", bVy2.urx()).CwM(this.getSampleRate());
        this.check("channel count correct", bVy2.AaH()).CwM(2);
        this.check("bit depth correct", bVy2.WW1()).CwM(this.getExpectedBitsPerSample());
        double d4 = bVy2.nSA();
        this.check("file duration", d4).Opd(d2, 7.0);
        bVz bVz2 = bVy2.IwJ();
        this.check("metadata chunk", bVz2).IkS();
        bVx bVx2 = bVz2.CwM();
        this.check("warp markers", bVx2).IkS();
        int n2 = bVx2.OqD();
        this.check("warp marker count", n2).CwM(2).m2i().hFR(2);
        bVw bVw2 = bVx2.CwM(0);
        this.check("first warp marker beat time", bVw2.Opd()).CwM(0.0);
        this.check("first warp marker sample time", bVw2.CwM()).CwM(0.0);
        bVw bVw3 = bVx2.CwM(n2 - 1);
        this.checkBeatTime("last warp marker beat time", bVw3.Opd()).hFR(d3);
        this.check("last warp marker sample time", bVw3.CwM()).CwM(d4);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, bVx2);
    }

    private void checkLoadingAudioNoteHasExpectedWarpMarkers(File file, bVx bVx2) {
        QH qH2 = new QH(new XRe(file));
        int n2 = 60;
        qH2.CwM(60.0, true);
        bVx bVx3 = qH2.m2i();
        this.check("loaded sample info has warp markers", bVx3).IkS();
        this.checkHasSameWarpMarkers(bVx2, bVx3);
        zKD zKD2 = zKD.CwM(qH2, DPB.Opd, 60.0);
        VAg vAg = zKD2.RgE().SGr();
        this.checkWarpEventsAreCorrectForWarpMarkers(vAg, bVx2);
    }

    private void checkHasSameWarpMarkers(bVx bVx2, bVx bVx3) {
        this.check(bVx2.OqD()).m2i().CwM(bVx3.OqD());
        for (int i2 = 0; i2 < bVx2.OqD(); ++i2) {
            bVw bVw2 = bVx2.CwM(i2);
            bVw bVw3 = bVx3.CwM(i2);
            this.check("Warp marker " + (i2 + 1) + " is the same", bVw2).CwM(bVw3);
        }
    }

    private void checkWarpEventsAreCorrectForWarpMarkers(VAg vAg, bVx bVx2) {
        int n2 = vAg.fn();
        int n3 = bVx2.OqD();
        this.check("warp event count is correct", n2).CwM(n3);
        for (int i2 = 0; i2 < Math.min(n3, n2); ++i2) {
            bVw bVw2 = bVx2.CwM(i2);
            LJz lJz = vAg.Opd(i2);
            this.check("Warp event " + (i2 + 1) + " beat time is correct", lJz.eOr()).CwM(L.CwM(bVw2.Opd()));
            this.check("Warp event " + (i2 + 1) + " sample time is correct", lJz.OqD()).CwM(bVw2.CwM());
        }
    }

    protected abstract int getExpectedBitsPerSample();

    protected abstract Class getErrorNotificationType();
}

