/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements.devices;

import com.bitwig.extension.api.project.component.Multisample;
import com.bitwig.extension.api.project.component.MultisampleZone;
import com.bitwig.extension.api.project.component.SamplerResourceComponent;
import com.bitwig.extension.api.project.component.SingleSampleResource;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extensions.importer.als.elements.MultiSampleMap;
import com.bitwig.extensions.importer.als.elements.MultiSamplePart;
import com.bitwig.extensions.importer.als.elements.NativeDevice;
import java.util.List;
import java.util.UUID;
import org.xml.sax.Attributes;

public abstract class SimplerOrSampler
extends NativeDevice {
    private MultiSampleMap OqD;
    private int m2i = 1;

    public SimplerOrSampler(SSX sSX) {
        super(sSX, UUID.fromString("468bc14b-b2e7-45a1-9666-e83117fe404e"));
        this.CwM("Pitch/TransposeKey", "TRANSPOSE", Unit.SEMITONES_RELATIVE);
        this.CwM("Filter/Slot/Value/SimplerFilter/Freq", "FILT_FREQ", Unit.HERTZ);
        this.CwM("Filter/Slot/Value/SimplerFilter/Res", "FILT_RESO", Unit.NONE);
        this.CwM("Filter/Slot/Value/SimplerFilter/ModByPitch", "FILTER_KEYTRACK", Unit.NONE);
        this.CwM("VolumeAndPan/Volume", "GAIN", Unit.DECIBEL);
        this.CwM("VolumeAndPan/VolumeVelScale", "VELOCITY_SENSITIVETY", Unit.PERCENTAGE_OF_RANGE);
        this.CwM("VolumeAndPan/Panorama", "PAN", Unit.NONE);
        this.CwM("VolumeAndPan/Envelope/AttackTime", "AMP_ATTACK_TIME", Unit.MILLISECONDS);
        this.CwM("VolumeAndPan/Envelope/DecayTime", "AMP_DECAY_TIME", Unit.MILLISECONDS);
        this.CwM("VolumeAndPan/Envelope/SustainLevel", "AMP_SUSTAIN_LEVEL", Unit.NONE);
        this.CwM("VolumeAndPan/Envelope/ReleaseTime", "AMP_RELEASE_TIME", Unit.MILLISECONDS);
        this.CwM("VolumeAndPan/Envelope/AttackSlope", "AMP_ATTACK_SHAPE", Unit.MILLISECONDS);
        this.CwM("VolumeAndPan/Envelope/DecaySlope", "AMP_DECAY_SHAPE", Unit.MILLISECONDS, d2 -> -d2);
        this.CwM("VolumeAndPan/Envelope/ReleaseSlope", "AMP_RELEASE_SHAPE", Unit.MILLISECONDS, d2 -> -d2);
        this.CwM("Player/SampleSelector", "SELECT", Unit.MIDI128);
        this.CwM("Player/LoopModulators/SampleStart", "SAMPLE_START", Unit.NONE);
        this.CwM("Player/LoopModulators/LoopLength", "LOOP_LENGTH", Unit.NONE);
        this.CwM("Globals/PortamentoTime", "POLY/GLIDE_TIME", Unit.MILLISECONDS);
    }

    @Override
    public void CwM(String string, Attributes attributes) {
        super.CwM(string, attributes);
        if (string.equals("Player/MultiSampleMap")) {
            this.OqD = new MultiSampleMap(this.bBu());
            this.bBu().CwM(this.OqD);
        }
        if (string.equals("Globals/NumVoices")) {
            this.m2i = this.m2i(attributes, "Value");
        }
    }

    public SamplerResourceComponent OqD() {
        return (SamplerResourceComponent)((com.bitwig.extension.api.project.mixer.NativeDevice)this.Opd()).getComponent("SAMPLE", SamplerResourceComponent.class);
    }

    @Override
    public void CwM() {
        super.CwM();
        SamplerResourceComponent samplerResourceComponent = this.OqD();
        List list = this.OqD.OqD();
        if (list.size() == 1) {
            MultiSamplePart multiSamplePart = (MultiSamplePart)list.get(0);
            SingleSampleResource singleSampleResource = samplerResourceComponent.loadSample(multiSamplePart.cOi().LTX(), false);
            this.CwM(multiSamplePart, singleSampleResource);
            if (this.bBu().CwM("DrumBranch")) {
                singleSampleResource.setKeyTrack(0.0);
            }
        } else {
            Multisample multisample = samplerResourceComponent.createMultisample();
            for (MultiSamplePart multiSamplePart : list) {
                SampleReference sampleReference = multiSamplePart.cOi().LTX();
                if (sampleReference == null) continue;
                MultisampleZone multisampleZone = multisample.addZone(sampleReference);
                this.CwM(multiSamplePart, multisampleZone);
            }
        }
        ((com.bitwig.extension.api.project.mixer.NativeDevice)this.CwM).setNumVoices(1 + this.m2i + Math.max(0, this.m2i - 7));
    }

    private void CwM(MultiSamplePart multiSamplePart, MultisampleZone multisampleZone) {
        multisampleZone.setLowKey(multiSamplePart.OqD());
        multisampleZone.setLowKeyCf(multiSamplePart.hFR() - multiSamplePart.OqD());
        multisampleZone.setHighKey(multiSamplePart.m2i());
        multisampleZone.setHighKeyCf(multiSamplePart.m2i() - multiSamplePart.LTX());
        multisampleZone.setLowVelocity(multiSamplePart.uwB());
        multisampleZone.setLowVelocityCf(multiSamplePart.aMy() - multiSamplePart.uwB());
        multisampleZone.setHighVelocity(multiSamplePart.dhb());
        multisampleZone.setHighVelocityCf(multiSamplePart.dhb() - multiSamplePart.alk());
        multisampleZone.setLowSelect(multiSamplePart.EuM());
        multisampleZone.setLowSelectCf(multiSamplePart.AaH() - multiSamplePart.EuM());
        multisampleZone.setHighSelect(multiSamplePart.IkS());
        multisampleZone.setHighSelectCf(multiSamplePart.IkS() - multiSamplePart.WW1());
        SingleSampleResource singleSampleResource = multisampleZone.getResource();
        this.CwM(multiSamplePart, singleSampleResource);
    }

    protected void CwM(MultiSamplePart multiSamplePart, SingleSampleResource singleSampleResource) {
        double d2 = multiSamplePart.cOi().hFR();
        singleSampleResource.setRootKey(multiSamplePart.urx());
        singleSampleResource.setDetune((double)multiSamplePart.nSA() * 0.01);
        singleSampleResource.setKeyTrack((double)multiSamplePart.Uft() * 0.01);
        singleSampleResource.setGain(f2f.hFR(multiSamplePart.pqS()));
        singleSampleResource.setSampleStart((double)multiSamplePart.gav() / d2);
        singleSampleResource.setSampleEnd((double)multiSamplePart.Xb() / d2);
        double d3 = multiSamplePart.IwJ() - multiSamplePart.fn();
        singleSampleResource.setLoopStart((double)multiSamplePart.fn() / d2);
        singleSampleResource.setLoopEnd((double)multiSamplePart.IwJ() / d2);
        singleSampleResource.setLoopCrossfade((double)multiSamplePart.UHd() / d3);
        singleSampleResource.setLoopMode(this.CwM(multiSamplePart.HwE()));
    }

    private bsl CwM(int n2) {
        switch (n2) {
            case 1: {
                return bsl.Opd;
            }
            case 2: {
                return bsl.OqD;
            }
        }
        return bsl.CwM;
    }
}

