/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements.devices;

import com.bitwig.extension.api.project.DocumentObject;
import com.bitwig.extension.api.project.component.DrumPad;
import com.bitwig.extension.api.project.component.DrumPads;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.mixer.Mixer;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extensions.importer.als.elements.FloatParameter;
import com.bitwig.extensions.importer.als.elements.NativeDevice;
import com.bitwig.extensions.importer.als.elements.SampleRef;
import java.util.UUID;
import org.xml.sax.Attributes;

public class InstrumentImpulse
extends NativeDevice {
    private static int OqD = 8;
    private static final int[] m2i = new int[]{60, 62, 64, 65, 67, 69, 71, 72};
    private SampleRef[] hFR = new SampleRef[OqD];
    private ryY[] LTX = new ryY[OqD];
    private boolean[] uwB = new boolean[OqD];
    private int[] aMy = new int[OqD];

    public InstrumentImpulse(SSX sSX) {
        super(sSX, UUID.fromString("8ea97e45-0255-40fd-bc7e-94419741e9d1"));
        this.CwM("GlobalVolume", "MASTER_VOLUME", Unit.DECIBEL);
        DrumPads drumPads = this.OqD();
        for (int i2 = 0; i2 < OqD; ++i2) {
            int n2 = m2i[i2];
            DrumPad drumPad = drumPads.getDrumPad(n2);
            Mixer mixer = drumPad.getMixer();
            this.LTX[i2] = new ryY(this.ynG());
            com.bitwig.extension.api.project.mixer.NativeDevice nativeDevice = this.LTX[i2].CwM();
            drumPad.getDeviceChain().addDevice(nativeDevice);
            String string = "VolumeVolume." + i2;
            this.Opd.put(string, new FloatParameter(this.bBu(), string, mixer.getVolume(), Unit.DECIBEL));
            String string2 = "VolumePan." + i2;
            this.Opd.put(string2, new FloatParameter(this.bBu(), string2, mixer.getPan(), Unit.NONE));
            String string3 = "StartTune." + i2;
            this.Opd.put(string3, new FloatParameter(this.bBu(), string3, nativeDevice.getDoubleParameter("TRANSPOSE"), Unit.SEMITONES_RELATIVE));
            String string4 = "FilterFreq." + i2;
            this.Opd.put(string4, new FloatParameter(this.bBu(), string4, nativeDevice.getDoubleParameter("FILT_FREQ"), Unit.HERTZ));
        }
    }

    @Override
    public void CwM(String string, Attributes attributes) {
        super.CwM(string, attributes);
        DrumPads drumPads = this.OqD();
        for (int i2 = 0; i2 < OqD; ++i2) {
            int n2 = m2i[i2];
            DrumPad drumPad = drumPads.getDrumPad(n2);
            if (string.equals("TabSample." + i2 + "/Value/SampleRef")) {
                this.hFR[i2] = new SampleRef(this.bBu());
                this.bBu().CwM(this.hFR[i2]);
                continue;
            }
            if (string.equals("VolumeMute." + i2)) {
                drumPad.getMixer().getMute().setValue(this.OqD(attributes, "Value"));
                continue;
            }
            if (string.equals("VolumeSolo." + i2)) continue;
            if (string.equals("FilterOn." + i2)) {
                this.uwB[i2] = this.OqD(attributes, "Value");
                continue;
            }
            if (!string.equals("FilterType." + i2 + "/Manual")) continue;
            this.aMy[i2] = this.m2i(attributes, "Value");
        }
    }

    @Override
    public void CwM() {
        super.CwM();
        for (int i2 = 0; i2 < OqD; ++i2) {
            DocumentObject documentObject;
            ryY ryY2 = this.LTX[i2];
            com.bitwig.extension.api.project.mixer.NativeDevice nativeDevice = ryY2.CwM();
            if (this.hFR[i2] != null && (documentObject = this.hFR[i2].LTX()) != null) {
                ryY2.Opd().loadSample((SampleReference)documentObject, false);
            }
            if (!this.uwB[i2]) continue;
            documentObject = nativeDevice.getEnumParameter("FILTER_TYPE");
            documentObject.setValue(this.CwM(this.aMy[i2]));
        }
    }

    private int CwM(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 4;
            }
        }
        return 13;
    }

    public DrumPads OqD() {
        return (DrumPads)((com.bitwig.extension.api.project.mixer.NativeDevice)this.Opd()).getComponent("DRUM_PADS", DrumPads.class);
    }
}

