/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extension.api.util.midi;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SysexBuilder {
    private static final int MAX_LENGTH = 512;
    private byte[] mData = new byte[512];
    private int mLength;

    public static SysexBuilder fromHex(String string) {
        return new SysexBuilder().addHex(string);
    }

    public SysexBuilder addByte(int n2) {
        this.mData[this.mLength++] = (byte)(n2 & 0x7F);
        return this;
    }

    public SysexBuilder addString(String string, int n2) {
        byte[] byArray = string.getBytes(StandardCharsets.US_ASCII);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mData[this.mLength++] = i2 < byArray.length ? byArray[i2] : 32;
        }
        return this;
    }

    public SysexBuilder add(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.mData[this.mLength++] = byArray[i2];
        }
        return this;
    }

    public SysexBuilder addHex(String string) {
        String string2 = string.replace(" ", "");
        if (((string2 = string2.toUpperCase()).length() & 1) != 0) {
            throw new IllegalArgumentException("Invalid sysex string");
        }
        int n2 = string2.length() / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mData[this.mLength++] = Integer.valueOf(string2.substring(i2 * 2, i2 * 2 + 2), 16).byteValue();
        }
        return this;
    }

    public byte[] terminate() {
        this.mData[this.mLength++] = -9;
        return this.array();
    }

    public byte[] array() {
        return Arrays.copyOfRange(this.mData, 0, this.mLength);
    }
}

