/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.platform;

import com.bitwig.base.io.Mtp;
import com.bitwig.base.io.ProcessException;
import com.bitwig.base.io.VOl;
import com.bitwig.base.io.gPo;
import com.bitwig.base.io.wIs;
import com.bitwig.base.platform.MacOsXIoKit;
import com.bitwig.base.platform.WindowsPlatform;
import com.bitwig.base.platform.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;

public final class Platform {
    private static String Opd;
    private static UUID OqD;
    private static boolean m2i;
    private static File hFR;
    private static File LTX;
    private static final long uwB;
    private static final long dhb;

    public static void CwM() {
        if (!m2i) {
            isl.Opd("base-platform");
            m2i = true;
        }
    }

    public static String Opd() {
        if (Opd == null) {
            Opd = Platform.dhb();
        }
        assert (bBv.OqD(Opd != null));
        assert (bBv.OqD(!Opd.isEmpty()));
        return Opd;
    }

    private static String dhb() {
        if (isl.Opd()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            String string2 = Platform.getNativeComputerName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                bBv.m2i.hFR("Warning: determining macOS host name failed, using fallback instead.");
                string2 = InetAddress.getLocalHost().getHostName();
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                bBv.m2i.hFR("Error: unable to determine macOS host name.");
            }
        } else if (isl.CwM()) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = System.getenv("COMPUTERNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
        } else if (isl.hFR()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            try {
                String string3 = InetAddress.getLocalHost().getHostName();
                if (string3 != null && !string3.isEmpty()) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "localhost";
    }

    private static native String getNativeComputerName();

    public static UUID OqD() {
        if (OqD == null) {
            OqD = Platform.aMy();
        }
        assert (bBv.OqD(OqD != null));
        return OqD;
    }

    private static UUID aMy() {
        if (isl.CwM()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483646, "SOFTWARE\\Microsoft\\Cryptography", "MachineGuid");
            return UUID.fromString(string);
        }
        if (isl.Opd()) {
            String string = MacOsXIoKit.readRegistryStringValue("IOPlatformUUID");
            return UUID.fromString(string);
        }
        if (isl.hFR()) {
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[]{117, -113, 37, -18, 20, 42, 106, -119, 115, 122, 126, 40, 55, 123, 38, 93, 22, 63, -21, -127, 68, 107, 5, 37, 9, 26, 109, 51, 40, -109, 35, 41};
                String string = ask.CwM(byArray2);
                File file = null;
                File file2 = new File(string);
                if (file2.isFile()) {
                    file = file2;
                } else {
                    byArray = new byte[]{0, 39, 85, -46, 55, -14, -109, 17, 6, -63, 27, 5, 20, -94, -41, -60, 81, 50, -25, -111, 26, 45, 12};
                    String string2 = ask.CwM(byArray);
                    file = new File(string2);
                }
                byArray = VOl.uwB(file);
                return UUID.nameUUIDFromBytes(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void m2i() {
        Thread.currentThread().setPriority(4);
        if (isl.hFR()) {
            Platform.initThreadForBackgroundIONative();
        }
    }

    private static native void initThreadForBackgroundIONative();

    public static void CwM(File file) {
        bBv.m2i.OqD("Openning file with default application " + file.getPath());
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (isl.hFR()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file.getAbsolutePath());
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (isl.Opd()) {
            ProcessBuilder processBuilder = file.isDirectory() ? new ProcessBuilder("open", "-R", file.getAbsolutePath()) : new ProcessBuilder("open", file.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open " + file.getAbsolutePath() + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (isl.CwM() && !WindowsPlatform.CwM(file.getAbsolutePath())) {
            throw new IOException("Couldn't open file: " + file.getAbsolutePath());
        }
    }

    public static void Opd(File file) {
        File file2;
        for (file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new FileNotFoundException();
        }
        if (isl.hFR()) {
            File file3 = VOl.WW1("nautilus");
            if (file3 != null) {
                ProcessBuilder processBuilder = new ProcessBuilder("nautilus", "-s", file.getAbsolutePath());
                processBuilder.environment().remove("LD_LIBRARY_PATH");
                Process process = processBuilder.start();
                try {
                    int n2 = process.waitFor();
                    if (n2 != 0) {
                        throw new IOException("nautilus returned error exit code " + n2);
                    }
                }
                catch (InterruptedException interruptedException) {}
            } else {
                File file4 = file2.isDirectory() ? file2 : file2.getParentFile();
                ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file4.getAbsolutePath());
                processBuilder.environment().remove("LD_LIBRARY_PATH");
                Process process = processBuilder.start();
                try {
                    int n3 = process.waitFor();
                    if (n3 != 0) {
                        throw new IOException("xdg-open returned error exit code " + n3);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (isl.Opd()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", "-R", file2.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n4 = process.waitFor();
                if (n4 != 0) {
                    throw new IOException("open -R " + file2.getAbsolutePath() + " returned error exit code " + n4);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (isl.CwM() && !WindowsPlatform.Opd(file2.getAbsolutePath())) {
            throw new IOException("Couldn't explore file: " + file2.getAbsolutePath());
        }
    }

    public static void CwM(String string) {
        assert (bBv.CwM(string != null && !string.isEmpty()));
        if (isl.hFR()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", string);
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (isl.Opd()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", string);
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open " + string + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (isl.CwM() && !WindowsPlatform.CwM(string)) {
            throw new IOException("Couldn't open URL: " + string);
        }
    }

    public static String hFR() {
        try {
            if (isl.hFR()) {
                return Platform.IkS();
            }
            if (isl.CwM()) {
                return Platform.EuM();
            }
            if (isl.Opd()) {
                return Platform.alk();
            }
        }
        catch (Throwable throwable) {
            bBv.m2i.Opd(throwable);
        }
        return null;
    }

    private static String alk() {
        try {
            Mtp mtp = wIs.CwM(new String[]{"sw_vers"}, null);
            if (mtp.CwM() == 0) {
                String string = mtp.Opd();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            return null;
        }
    }

    private static String EuM() {
        try {
            Mtp mtp = wIs.CwM(new String[]{"systeminfo"}, null);
            if (mtp.CwM() == 0) {
                String string = mtp.Opd();
                return string;
            }
            bBv.m2i.LTX("Error obtaining detailed OS info\nProcess returned exit code " + mtp.CwM() + "\nOutput:\n" + mtp.Opd() + "\n\nErrors:\n" + mtp.OqD());
            return null;
        }
        catch (ProcessException processException) {
            bBv.m2i.m2i("Error obtaining detailed OS info", processException);
            return null;
        }
    }

    private static String IkS() {
        String string = Platform.AaH();
        String string2 = Platform.WW1();
        return string + "\n" + string2;
    }

    private static String AaH() {
        try {
            Mtp mtp = wIs.CwM(new String[]{"lsb_release", "-a"}, null);
            if (mtp.CwM() == 0) {
                String string = mtp.Opd();
                return string;
            }
            return "";
        }
        catch (ProcessException processException) {
            return "";
        }
    }

    private static String WW1() {
        try {
            return gPo.CwM(new FileReader(new File("/proc/cpuinfo")));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static File LTX() {
        return hFR;
    }

    public static File uwB() {
        return LTX;
    }

    public static native void simulateCrashInNativeCode();

    public static File Opd(String string) {
        if (isl.CwM()) {
            return Platform.LTX(string);
        }
        if (isl.Opd()) {
            return Platform.hFR(string);
        }
        if (isl.hFR()) {
            return Platform.m2i(string);
        }
        assert (bBv.OqD(false));
        return null;
    }

    private static File m2i(String string) {
        String string2;
        File file = new File("/media/" + string);
        if (!(file.isDirectory() || (file = new File("/media/" + (string2 = System.getProperty("user.name")) + "/" + string)).isDirectory() || (file = new File("/mnt/" + string)).isDirectory() || (file = new File("/mnt/" + string2 + "/" + string)).isDirectory())) {
            return null;
        }
        return file;
    }

    private static File hFR(String string) {
        File file = new File("/Volumes/" + string);
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File LTX(String string) {
        File file;
        FileStore fileStore;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.type().equals("UDF") && !fileStore.type().equals("CDFS") || !fileStore.name().toLowerCase().startsWith(string.toLowerCase())) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.name().equalsIgnoreCase(string)) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static File OqD(String string) {
        if (isl.CwM()) {
            return Platform.dhb(string);
        }
        if (isl.Opd()) {
            return Platform.uwB(string);
        }
        if (isl.hFR()) {
            return Platform.aMy(string);
        }
        assert (bBv.OqD(false));
        return null;
    }

    private static File uwB(String string) {
        File file = new File("/Volumes");
        return Platform.CwM(file, string);
    }

    private static File CwM(File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File file3 = new File(file2, string);
                if (!file3.isDirectory()) continue;
                return file3;
            }
        }
        return null;
    }

    private static File dhb(String string) {
        File file;
        Object object;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                File file2;
                object = Files.getFileStore(path);
                file = path.toFile();
                if (!((FileStore)object).type().equals("UDF") && !((FileStore)object).type().equals("CDFS") || !(file2 = new File(file, string)).isDirectory()) continue;
                return file2;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            object = path.toFile();
            file = new File((File)object, string);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private static File aMy(String string) {
        String string2 = System.getProperty("user.name");
        File file = Platform.CwM(new File("/media/" + string2), string);
        if (file == null && (file = Platform.CwM(new File("/media"), string)) == null && (file = Platform.CwM(new File("/mnt/" + string2), string)) == null) {
            file = Platform.CwM(new File("/mnt"), string);
        }
        return file;
    }

    public static long CwM(long l2) {
        assert (bBv.OqD(l2 >= dhb));
        return (l2 - dhb) / 1000000L + uwB;
    }

    public static native long getHighResolutionClockTimeNanos();

    public static native boolean supportsWindowsDpiAwareFunctionality();

    public static native boolean hasAVX2();

    static {
        Platform.CwM();
        uwB = System.currentTimeMillis();
        dhb = Platform.getHighResolutionClockTimeNanos();
        if (isl.CwM()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "DESKTOP");
            hFR = string != null && !string.isEmpty() ? new File(string) : new File(VOl.Opd(), "Desktop");
            String string2 = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
            if (string2 != null && !string2.isEmpty()) {
                LTX = new File(string2);
            } else {
                hFR = new File(VOl.Opd(), "Documents");
            }
        } else {
            hFR = new File(VOl.Opd(), "Desktop");
            LTX = VOl.Opd();
        }
    }
}

