/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.util.midi.ShortMidiMessage;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Signal;
import com.bitwig.extension.controller.api.Transport;
import java.util.HashSet;
import java.util.function.Consumer;

public class WKK
extends ControllerExtension {
    private Transport CwM;
    private CursorTrack Opd;
    private PinnableCursorDevice OqD;
    private CursorRemoteControlsPage m2i;
    private NoteInput hFR;
    private NJl[] LTX = new NJl[8];
    private NJl uwB;
    private rrz dhb;
    private rrz aMy;
    private rrz alk;
    private rrz EuM;
    private Signal IkS;
    private Signal AaH;
    private Signal WW1;
    private PVA urx = null;
    private HashSet nSA = new HashSet();
    private int gav = 0;

    protected WKK(Hxu hxu, ControllerHost controllerHost) {
        super(hxu, controllerHost);
    }

    @Override
    public void init() {
        SettableRangedValue settableRangedValue;
        int n2;
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        Preferences preferences = controllerHost.getPreferences();
        controllerHost.getMidiInPort(0).setMidiCallback(shortMidiMessage -> this.CwM(shortMidiMessage));
        controllerHost.getMidiInPort(0).setSysexCallback(string -> this.CwM(string));
        this.hFR = controllerHost.getMidiInPort(0).createNoteInput("", new String[0]);
        this.CwM = controllerHost.createTransport();
        this.Opd = controllerHost.createCursorTrack(0, 0);
        this.OqD = this.Opd.createCursorDevice();
        this.m2i = this.OqD.createCursorRemoteControlsPage(8);
        for (n2 = 0; n2 < 8; ++n2) {
            settableRangedValue = this.m2i.getParameter(n2);
            settableRangedValue.setIndication(true);
            settableRangedValue.setLabel("Knob " + Integer.toString(n2 + 1));
        }
        this.IkS = preferences.getSignalSetting("Learn", "Remote Controls", "Learn");
        this.IkS.addSignalObserver(this::CwM);
        for (n2 = 0; n2 < 8; ++n2) {
            settableRangedValue = preferences.getNumberSetting("CC " + Integer.toString(n2 + 1), "Remote Controls", -1.0, 119.0, 1.0, "", -1.0);
            this.LTX[n2] = new NJl(this.m2i.getParameter(n2), settableRangedValue);
        }
        this.AaH = preferences.getSignalSetting("Learn", "Cursor Track", "Learn");
        this.AaH.addSignalObserver(this::Opd);
        this.uwB = new NJl(this.Opd.getVolume(), preferences.getNumberSetting("Volume CC", "Cursor Track", -1.0, 119.0, 1.0, "", -1.0));
        this.WW1 = preferences.getSignalSetting("Learn", "Transport", "Learn");
        this.WW1.addSignalObserver(this::OqD);
        this.dhb = new rrz(this.CwM::play, preferences.getNumberSetting("Play CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
        this.alk = new rrz(this.CwM::stop, preferences.getNumberSetting("Stop CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
        this.aMy = new rrz(this.CwM::record, preferences.getNumberSetting("Record CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
        this.EuM = new rrz(this.CwM.isArrangerLoopEnabled()::toggle, preferences.getNumberSetting("Cycle CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
    }

    private void CwM() {
        ((ControllerHost)this.getHost()).showPopupNotification("Move Remote 1");
        this.urx = PVA.CwM;
        this.gav = 0;
        this.nSA.clear();
    }

    private void Opd() {
        ((ControllerHost)this.getHost()).showPopupNotification("Move control to use for volume");
        this.urx = PVA.Opd;
        this.gav = 0;
        this.nSA.clear();
    }

    private void OqD() {
        ((ControllerHost)this.getHost()).showPopupNotification("Push PLAY button");
        this.urx = PVA.OqD;
        this.gav = 0;
        this.nSA.clear();
    }

    @Override
    public void exit() {
    }

    private void CwM(ShortMidiMessage shortMidiMessage) {
        if (shortMidiMessage.isControlChange()) {
            int n2 = shortMidiMessage.getData1();
            if (this.urx == PVA.CwM) {
                if (!this.nSA.contains(n2)) {
                    this.LTX[this.gav].Opd(n2);
                    this.nSA.add(n2);
                    ++this.gav;
                    if (this.gav >= 8) {
                        ((ControllerHost)this.getHost()).showPopupNotification("Learning complete");
                        this.urx = null;
                        this.nSA.clear();
                    } else {
                        ((ControllerHost)this.getHost()).showPopupNotification("Move Remote " + Integer.toString(this.gav + 1));
                    }
                }
            } else if (this.urx == PVA.Opd) {
                if (!this.nSA.contains(n2)) {
                    this.uwB.Opd(n2);
                    ((ControllerHost)this.getHost()).showPopupNotification("Learning complete");
                    this.urx = null;
                }
            } else if (this.urx == PVA.OqD) {
                if (!this.nSA.contains(n2)) {
                    this.nSA.add(n2);
                    if (this.gav == 0) {
                        this.dhb.Opd(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Push STOP button");
                        ++this.gav;
                    } else if (this.gav == 1) {
                        this.alk.Opd(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Push RECORD button");
                        ++this.gav;
                    } else if (this.gav == 2) {
                        this.aMy.Opd(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Push LOOP/CYCLE button");
                        ++this.gav;
                    } else {
                        this.EuM.Opd(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Learning complete");
                        this.urx = null;
                        this.gav = 0;
                        this.nSA.clear();
                    }
                }
            } else {
                this.CwM((T qDh) -> {
                    if (qDh.OqD(n2)) {
                        int n3 = shortMidiMessage.getData2();
                        qDh.CwM(n3);
                    }
                });
            }
        }
    }

    void CwM(Consumer consumer) {
        consumer.accept(this.uwB);
        for (NJl nJl : this.LTX) {
            consumer.accept(nJl);
        }
        consumer.accept(this.dhb);
        consumer.accept(this.alk);
        consumer.accept(this.aMy);
        consumer.accept(this.EuM);
    }

    private void CwM(String string) {
        if (string.equals("f07f7f0605f7")) {
            this.CwM.rewind();
        } else if (string.equals("f07f7f0604f7")) {
            this.CwM.fastForward();
        } else if (string.equals("f07f7f0601f7")) {
            this.CwM.stop();
        } else if (string.equals("f07f7f0602f7")) {
            this.CwM.play();
        } else if (string.equals("f07f7f0606f7")) {
            this.CwM.record();
        }
    }

    @Override
    public void flush() {
    }
}

