/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMessage;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.api.opensoundcontrol.OscServer;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ChainSelector;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.DeviceLayer;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class V12
extends ControllerExtension {
    private Transport CwM;
    private MasterTrack Opd;
    private CursorTrack OqD;
    private CursorDevice m2i;
    private ChainSelector hFR;
    private DeviceLayer LTX;
    private SettableIntegerValue uwB;
    private IntegerValue dhb;
    private OscServer aMy;

    public V12(GEU gEU2, ControllerHost controllerHost) {
        super(gEU2, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        Preferences preferences = controllerHost.getPreferences();
        SettableRangedValue settableRangedValue = preferences.getNumberSetting("port", "Server", 1024.0, 32000.0, 1.0, "", 9001.0);
        settableRangedValue.addRawValueObserver(this::CwM);
        this.CwM = controllerHost.createTransport();
        this.Opd = controllerHost.createMasterTrack(1);
        this.OqD = controllerHost.createCursorTrack("osc-cursor-track", "OSC cursor track", 1, 1, true);
        this.m2i = this.OqD.createCursorDevice();
        this.hFR = this.m2i.createChainSelector();
        this.LTX = this.hFR.activeChain();
        this.uwB = this.hFR.activeChainIndex();
        this.dhb = this.hFR.chainCount();
        this.LTX.name().markInterested();
        this.dhb.markInterested();
        this.uwB.markInterested();
        this.CwM();
    }

    private void CwM(double d2) {
        int n2 = (int)d2;
        try {
            this.aMy.start(n2);
        }
        catch (IOException iOException) {
            ((ControllerHost)this.getHost()).showPopupNotification("Could not set the OSC port to " + n2 + ": " + iOException.getMessage());
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void CwM() {
        OscModule oscModule = ((ControllerHost)this.getHost()).getOscModule();
        OscAddressSpace oscAddressSpace = oscModule.createAddressSpace();
        oscAddressSpace.setName("bitwig");
        oscAddressSpace.registerObjectMethods("/bitwig/transport", this.CwM);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorDevice", this.m2i);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorTrack", this.OqD);
        oscAddressSpace.registerObjectMethods("/bitwig/masterTrack", this.Opd);
        oscAddressSpace.registerObjectMethods("/bitwig/", this);
        oscAddressSpace.registerDefaultMethod(this::CwM);
        oscAddressSpace.setShouldLogMessages(true);
        this.aMy = oscModule.createUdpServer(oscAddressSpace);
    }

    private void CwM(OscConnection oscConnection, OscMessage oscMessage) {
        ((ControllerHost)this.getHost()).println("OSC method not found for " + oscMessage.getAddressPattern() + "(" + oscMessage.getTypeTag() + ")");
    }

    @OscMethod(address="/test/int")
    public void handleTestInt(int n2) {
        ((ControllerHost)this.getHost()).println("int value: " + n2);
    }

    @OscMethod(address="/test/long")
    public void handleTestLong(long l2) {
        ((ControllerHost)this.getHost()).println("long value: " + l2);
    }

    @OscMethod(address="/test/float")
    public void handleTestFloat(float f4) {
        ((ControllerHost)this.getHost()).println("float value: " + f4);
    }

    @OscMethod(address="/test/double")
    public void handleTestDouble(double d2) {
        ((ControllerHost)this.getHost()).println("double value: " + d2);
    }

    @OscMethod(address="/test/bool")
    public void handleTestBool(boolean bl2) {
        ((ControllerHost)this.getHost()).println("boolean value: " + bl2);
    }

    @OscMethod(address="/test/string")
    public void handleTestString(String string) {
        ((ControllerHost)this.getHost()).println("string value: " + string);
    }

    @OscMethod(address="/test/ping")
    public void handleTestPing(OscConnection oscConnection) {
        oscConnection.sendMessage("/test/pong", new Object[0]);
    }

    @OscMethod(address="/test/chain-selector/select-next")
    public void handleChainSelectorNext() {
        this.hFR.selectNext();
    }

    @OscMethod(address="/test/chain-selector/select-prev")
    public void handleChainSelectorPrev() {
        this.hFR.selectPrevious();
    }

    @OscMethod(address="/test/chain-selector/select-first")
    public void handleChainSelectorFirst() {
        this.hFR.selectFirst();
    }

    @OscMethod(address="/test/chain-selector/select-last")
    public void handleChainSelectorLast() {
        this.hFR.selectLast();
    }

    @OscMethod(address="/test/chain-selector/cycle-next")
    public void handleChainSelectorCycleNext() {
        this.hFR.cycleNext();
    }

    @OscMethod(address="/test/chain-selector/cycle-prev")
    public void handleChainSelectorCyclePrev() {
        this.hFR.cyclePrevious();
    }

    @OscMethod(address="/test/chain-selector/test-active-chain")
    public void handleChainSelectorTestActiveChain() {
        ((ControllerHost)this.getHost()).println("ChainSelectorIndex: " + this.uwB.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorChainCount: " + this.dhb.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorActiveChainName: " + this.LTX.name().get());
    }
}

