/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.util.midi.ShortMidiMessage;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RemoteControl;
import com.bitwig.extension.controller.api.Transport;
import com.bitwig.extension.controller.api.UserControlBank;

public class EyU
extends ControllerExtension {
    private Transport CwM;
    private CursorTrack Opd;
    private PinnableCursorDevice OqD;
    private CursorRemoteControlsPage m2i;
    private MidiIn hFR;
    private UserControlBank LTX;

    protected EyU(Twq twq, ControllerHost controllerHost) {
        super(twq, controllerHost);
    }

    @Override
    public void init() {
        int n2;
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        this.hFR = controllerHost.getMidiInPort(0);
        this.hFR.setMidiCallback(shortMidiMessage -> this.CwM(shortMidiMessage));
        this.hFR.setSysexCallback(string -> this.CwM(string));
        NoteInput noteInput = this.hFR.createNoteInput("All Channels", "??????");
        noteInput.setShouldConsumeEvents(false);
        for (n2 = 0; n2 < 16; ++n2) {
            this.hFR.createNoteInput("Channel " + (n2 + 1), "?" + Integer.toHexString(n2) + "????");
        }
        this.CwM = controllerHost.createTransport();
        this.Opd = controllerHost.createCursorTrack(3, 0);
        this.OqD = this.Opd.createCursorDevice();
        this.m2i = this.OqD.createCursorRemoteControlsPage(8);
        for (n2 = 0; n2 < 8; ++n2) {
            RemoteControl remoteControl = this.m2i.getParameter(n2);
            remoteControl.setIndication(true);
            remoteControl.setLabel("P" + (n2 + 1));
        }
        this.LTX = controllerHost.createUserControls(111);
        for (n2 = 1; n2 < 119; ++n2) {
            if (EyU.CwM(n2)) continue;
            int n3 = EyU.Opd(n2);
            this.LTX.getControl(n3).setLabel("CC" + n2);
        }
    }

    private static boolean CwM(int n2) {
        return n2 >= 20 && n2 <= 27;
    }

    private static int Opd(int n2) {
        if (n2 > 27) {
            return n2 - 1 - 8;
        }
        return n2 - 1;
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void CwM(ShortMidiMessage shortMidiMessage) {
        if (shortMidiMessage.isControlChange()) {
            int n2 = shortMidiMessage.getData1();
            if (EyU.CwM(n2)) {
                int n3 = n2 - 20;
                this.m2i.getParameter(n3).value().set(shortMidiMessage.getData2(), 128);
            } else if (n2 >= 1 && n2 <= 119) {
                int n4 = EyU.Opd(n2);
                this.LTX.getControl(n4).value().set(shortMidiMessage.getData2(), 128);
            }
        }
    }

    private void CwM(String string) {
        if (string.equals("f07f7f0605f7")) {
            this.CwM.rewind();
        } else if (string.equals("f07f7f0604f7")) {
            this.CwM.fastForward();
        } else if (string.equals("f07f7f0601f7")) {
            this.CwM.stop();
        } else if (string.equals("f07f7f0602f7")) {
            this.CwM.play();
        } else if (string.equals("f07f7f0606f7")) {
            this.CwM.record();
        }
    }
}

