﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using HtmlAgilityPack;

namespace BiqugeSpider
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("请输入地址：");
            var url = Console.ReadLine();
            GetData(url);
        }

        static void GetData(string url)
        {
            var uri = new Uri(url);
            //网站地址
            string Host = url.Replace(uri.LocalPath, "");
            //小说ID，用来给文件命名
            string ID = uri.Segments.Length > 0 ? uri.Segments[uri.Segments.Length - 1].Replace("/", "") : DateTime.Now.ToString("HHmmss");

            var result = Http(url);
            var doc = new HtmlDocument();
            doc.LoadHtml(result);
            var node = doc.DocumentNode.SelectSingleNode("/html/body/div[4]/dl/dt[2]").NextSibling.NextSibling;
            HtmlNode a;
            string href;
            //章节列表
            var list = new List<Tuple<string, string>>();
            while (node != null && node.ChildNodes.Count > 0)
            {
                a = node.ChildNodes.First();
                href = a.GetAttributeValue("href", "");
                list.Add(new Tuple<string, string>(href, a.InnerText));
                node = node.NextSibling.NextSibling;
            }

            Console.WriteLine();
            StringBuilder sb = new StringBuilder();

            int index = 1;
            list.ForEach(x =>
            {
                url = $"{Host}{x.Item1}";
                result = Http(url);
                doc.LoadHtml(result);
                sb.AppendLine($"--------- {x.Item2} ---------");
                var content = doc.DocumentNode.SelectSingleNode("//*[@id=\"content\"]").InnerText.Replace("&nbsp;", "");
                sb.AppendLine(content);

                Console.WriteLine($"{DateTime.Now:HH:mm:ss} 第[{index}]章获取完成，共[{list.Count}]章");
                index++;

            });
            File.WriteAllText(AppDomain.CurrentDomain.BaseDirectory + "\\" + ID + ".txt", sb.ToString());

            Console.WriteLine($"{DateTime.Now:HH:mm:ss} 全部获取完成");
            Console.ReadLine();
        }

        /// <summary>
        /// 不做catch处理，需要在外部做
        /// </summary>
        /// <param name="url"></param>
        /// <param name="method">默认GET，空则补充为GET</param>
        /// <param name="contenttype">默认json，空则补充为json</param>
        /// <param name="header">请求头部</param>
        /// <param name="data">请求body内容</param>
        /// <returns></returns>
        static string Http(string url, string method = "GET", string contenttype = "application/json;charset=utf-8", Hashtable header = null, string data = null)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.ContentType = contenttype;
            request.Method = method;
            if (header != null)
            {
                foreach (var i in header.Keys)
                {
                    request.Headers.Add(i.ToString(), header[i].ToString());
                }
            }
            if (!string.IsNullOrEmpty(data))
            {
                Stream RequestStream = request.GetRequestStream();
                byte[] bytes = Encoding.UTF8.GetBytes(data);
                RequestStream.Write(bytes, 0, bytes.Length);
                RequestStream.Close();
            }
            HttpWebResponse response = (HttpWebResponse)request.GetResponse();
            Stream ResponseStream = response.GetResponseStream();
            StreamReader StreamReader = new StreamReader(ResponseStream, Encoding.GetEncoding("utf-8"));
            string re = StreamReader.ReadToEnd();
            StreamReader.Close();
            ResponseStream.Close();
            return re;
        }
    }
}
