/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.beetl.core.Function;
import org.beetl.core.TagFactory;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.ext.spring4.BeetlSqlDataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlManagerFactoryBean
implements FactoryBean<SQLManager>,
InitializingBean,
ApplicationListener<ApplicationEvent> {
    BeetlSqlDataSource cs;
    DBStyle dbStyle;
    NameConversion nc;
    Interceptor[] interceptors;
    SQLManager sqlManager;
    SQLLoader sqlLoader;
    private Map<String, Function> functions = Collections.emptyMap();
    private Map<String, TagFactory> tagFactorys = Collections.emptyMap();
    protected Resource configLocation = null;
    protected String defaultSchema = null;

    public void onApplicationEvent(ApplicationEvent event) {
    }

    public SQLManager getObject() throws Exception {
        if (this.sqlManager != null) {
            return this.sqlManager;
        }
        if (this.sqlLoader == null) {
            this.sqlLoader = new ClasspathLoader("/sql");
        }
        if (this.interceptors == null) {
            this.interceptors = new Interceptor[0];
        }
        Properties properties = new Properties();
        if (this.configLocation != null) {
            InputStream in = null;
            try {
                in = this.configLocation.getInputStream();
                properties.load(in);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    in = null;
                }
            }
        }
        this.sqlManager = new SQLManager(this.dbStyle, this.sqlLoader, this.cs, this.nc, this.interceptors, this.defaultSchema, properties);
        for (Map.Entry<String, Function> entry : this.functions.entrySet()) {
            this.sqlManager.getBeetl().getGroupTemplate().registerFunction(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Function> entry : this.tagFactorys.entrySet()) {
            this.sqlManager.getBeetl().getGroupTemplate().registerTagFactory(entry.getKey(), (TagFactory)entry.getValue());
        }
        return this.sqlManager;
    }

    public Class<?> getObjectType() {
        return SQLManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cs, (String)"'beetlSqlDataSource'\u6570\u636e\u6e90\u662f\u5fc5\u987b\u914d\u7f6e\u7684");
    }

    public void setCs(BeetlSqlDataSource beetlSqlDataSource) {
        this.cs = beetlSqlDataSource;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
    }

    public void setNc(NameConversion nameConversion) {
        this.nc = nameConversion;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public void setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
    }
}

