/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring;

import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.DefaultConnectionSource;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringConnectionSource
extends DefaultConnectionSource {
    public Connection getConn(String sqlId, boolean isUpdate, String sql, List paras) {
        boolean isReadOnly;
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        if (isUpdate) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        int status = (Integer)this.forceStatus.get();
        if (status == 1) {
            return this.getReadConn(sqlId, sql, paras);
        }
        if (status == 2) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        boolean inTrans = TransactionSynchronizationManager.isActualTransactionActive();
        if (inTrans && !(isReadOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly())) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        return this.getReadConn(sqlId, sql, paras);
    }

    public boolean isTransaction() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    protected Connection doGetConnectoin(DataSource ds) {
        try {
            return DataSourceUtils.getConnection((DataSource)ds);
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new BeetlSQLException(0, (Exception)((Object)ex));
        }
    }
}

