/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.gen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.ext.gen.GenConfig;
import org.beetl.sql.ext.gen.JavaType;

public class SourceGen {
    MetadataManager mm;
    SQLManager sm;
    String table;
    String pkg;
    String srcPath;
    GenConfig config;
    public static String srcHead = "";
    public static String defaultPkg = "com.test";
    static String CR = System.getProperty("line.separator");
    public static GroupTemplate gt = null;

    public SourceGen(SQLManager sm, String table, String pkg, String srcPath, GenConfig config) {
        this.mm = sm.getMetaDataManager();
        this.sm = sm;
        this.table = table;
        this.pkg = pkg;
        this.srcPath = srcPath;
        this.config = config;
    }

    public void gen() throws Exception {
        final TableDesc tableDesc = this.mm.getTable(this.table);
        String className = this.sm.getNc().getClassName(tableDesc.getMetaName());
        String ext = null;
        if (this.config.getBaseClass() != null) {
            ext = this.config.getBaseClass();
        }
        Set<String> cols = tableDesc.getMetaCols();
        ArrayList attrs = new ArrayList();
        for (String col : cols) {
            ColDesc desc = tableDesc.getColDesc(col);
            HashMap<String, Object> attr = new HashMap<String, Object>();
            attr.put("comment", desc.remark);
            attr.put("name", this.sm.getNc().getPropertyName(null, desc.colName));
            attr.put("type", desc.remark);
            String type = JavaType.getType(desc.sqlType, desc.size, desc.digit);
            if (this.config.isPreferBigDecimal() && type.equals("Double")) {
                type = "BigDecimal";
            }
            if (this.config.isPreferDate() && type.equals("Timestamp")) {
                type = "Date";
            }
            attr.put("type", type);
            attr.put("desc", desc);
            attrs.add(attr);
        }
        Collections.sort(attrs, new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                int score2;
                ColDesc desc1 = (ColDesc)o1.get("desc");
                ColDesc desc2 = (ColDesc)o2.get("desc");
                int score1 = this.score(desc1);
                if (score1 == (score2 = this.score(desc2))) {
                    return desc1.colName.compareTo(desc2.colName);
                }
                return score2 - score1;
            }

            private int score(ColDesc desc) {
                if (tableDesc.getMetaIdNames().contains(desc.colName)) {
                    return 99;
                }
                if (JavaType.isInteger(desc.sqlType)) {
                    return 9;
                }
                if (JavaType.isDateType(desc.sqlType)) {
                    return -9;
                }
                return 0;
            }
        });
        Template template = gt.getTemplate(GenConfig.template);
        template.binding("attrs", attrs);
        template.binding("className", (Object)className);
        template.binding("ext", (Object)ext);
        template.binding("package", (Object)this.pkg);
        template.binding("imports", (Object)srcHead);
        template.binding("comment", (Object)tableDesc.getRemark());
        String code = template.render();
        if (this.config.isDisplay()) {
            System.out.println(code);
        } else {
            String file = this.srcPath + File.separator + this.pkg.replace('.', File.separatorChar);
            File f = new File(file);
            f.mkdirs();
            File target = new File(file, className + ".java");
            FileWriter writer = new FileWriter(target);
            writer.write(code.toString());
            writer.close();
        }
    }

    static {
        Configuration conf = null;
        try {
            conf = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        conf.setStatementStart("@");
        conf.setStatementEnd(null);
        gt = new GroupTemplate((ResourceLoader)new StringTemplateResourceLoader(), conf);
        srcHead = srcHead + "import java.math.*;" + CR;
        srcHead = srcHead + "import java.util.Date;" + CR;
        srcHead = srcHead + "import java.sql.Timestamp;" + CR;
    }
}

