/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.handler;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.beetl.sql.core.kit.NumberKit;
import org.beetl.sql.core.mapping.ResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarHandler<T>
implements ResultSetHandler<T> {
    private final int columnIndex;
    private final String columnName;
    private final Class<?> requiredType;

    public ScalarHandler() {
        this(1, null, null);
    }

    public ScalarHandler(Class<T> clazz) {
        this(1, null, clazz);
    }

    public ScalarHandler(int columnIndex, Class<T> clazz) {
        this(columnIndex, null, clazz);
    }

    public ScalarHandler(String columnName, Class<T> clazz) {
        this(1, columnName, clazz);
    }

    private ScalarHandler(int columnIndex, String columnName, Class<T> clazz) {
        this.columnIndex = columnIndex;
        this.columnName = columnName;
        this.requiredType = clazz;
    }

    @Override
    public T handle(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int cloumnCount = rsmd.getColumnCount();
        Object result = this.getColumnValue(rs, this.columnIndex, this.requiredType);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            return (T)ScalarHandler.convertValueToRequiredType(result, this.requiredType);
        }
        return (T)result;
    }

    private Object getColumnValue(ResultSet rs, int columnIndex, Class<?> requiredType) throws SQLException {
        if (requiredType != null) {
            return this.getResultSetValue(rs, columnIndex, requiredType);
        }
        return this.getCloumnValue(rs, columnIndex);
    }

    private Object getResultSetValue(ResultSet rs, int columnIndex, Class<?> requiredType) throws SQLException {
        Comparable<Boolean> value;
        if (requiredType == null) {
            return this.getCloumnValue(rs, columnIndex);
        }
        if (String.class == requiredType) {
            return rs.getString(columnIndex);
        }
        if (Boolean.TYPE == requiredType || Boolean.class == requiredType) {
            value = rs.getBoolean(columnIndex);
        } else if (Byte.TYPE == requiredType || Byte.class == requiredType) {
            value = rs.getByte(columnIndex);
        } else if (Short.TYPE == requiredType || Short.class == requiredType) {
            value = rs.getShort(columnIndex);
        } else if (Integer.TYPE == requiredType || Integer.class == requiredType) {
            value = rs.getInt(columnIndex);
        } else if (Long.TYPE == requiredType || Long.class == requiredType) {
            value = rs.getLong(columnIndex);
        } else if (Float.TYPE == requiredType || Float.class == requiredType) {
            value = Float.valueOf(rs.getFloat(columnIndex));
        } else if (Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType) {
            value = rs.getDouble(columnIndex);
        } else {
            if (BigDecimal.class == requiredType) {
                return rs.getBigDecimal(columnIndex);
            }
            if (Date.class == requiredType) {
                return rs.getDate(columnIndex);
            }
            if (Time.class == requiredType) {
                return rs.getTime(columnIndex);
            }
            if (Timestamp.class == requiredType || java.util.Date.class == requiredType) {
                return rs.getTimestamp(columnIndex);
            }
            if (byte[].class == requiredType) {
                return rs.getBytes(columnIndex);
            }
            if (Blob.class == requiredType) {
                return rs.getBlob(columnIndex);
            }
            if (Clob.class == requiredType) {
                return rs.getClob(columnIndex);
            }
            return this.getCloumnValue(rs, columnIndex);
        }
        return rs.wasNull() ? null : value;
    }

    private Object getCloumnValue(ResultSet rs, int columnIndex) throws SQLException {
        Object obj = rs.getObject(columnIndex);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            obj = blob.getBytes(1L, (int)blob.length());
        } else if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            obj = clob.getSubString(1L, (int)clob.length());
        } else if ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className)) {
            obj = rs.getTimestamp(columnIndex);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(columnIndex);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(columnIndex) : rs.getDate(columnIndex);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(columnIndex))) {
            obj = rs.getTimestamp(columnIndex);
        }
        return obj;
    }

    public static Object convertValueToRequiredType(Object result, Class<?> requiredType) {
        if (result == null) {
            return null;
        }
        Class<?> type = result.getClass();
        if (type == result) {
            return result;
        }
        if (String.class == requiredType) {
            return result.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (result instanceof Number) {
                return NumberKit.convertNumberToTargetClass((Number)result, requiredType);
            }
            return NumberKit.parseNumber(result.toString(), requiredType);
        }
        if (requiredType.isPrimitive() && result instanceof Number) {
            return NumberKit.convertNumberToTargetClass((Number)result, requiredType);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u5316\u6210\u671f\u671b\u7c7b\u578b:" + requiredType);
    }
}

