/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLScript;
import org.beetl.sql.core.annotatoin.Param;
import org.beetl.sql.core.annotatoin.RowSize;
import org.beetl.sql.core.annotatoin.RowStart;
import org.beetl.sql.core.annotatoin.Sql;
import org.beetl.sql.core.annotatoin.SqlStatement;
import org.beetl.sql.core.annotatoin.SqlStatementType;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.engine.PageQuery;

public class MethodDesc {
    public Map<String, Integer> parasPos = new HashMap<String, Integer>();
    public int type = 0;
    public Method method = null;
    public int[] paggerPos = null;
    public int keyHolderPos = -1;
    public int mapRootPos = -1;
    public String sqlReady = "";
    public Class renturnType = Void.class;
    static Map<Method, MethodDesc> cache = new HashMap<Method, MethodDesc>();

    public static MethodDesc getMetodDesc(SQLManager sm, Class entityClass, Method m, String sqlId) {
        MethodDesc desc = cache.get(m);
        if (desc != null) {
            return desc;
        }
        desc = new MethodDesc();
        desc.doParse(sm, entityClass, m, sqlId);
        cache.put(m, desc);
        return desc;
    }

    protected void doParse(SQLManager sm, Class entityClass, Method m, String sqlId) {
        SqlStatement st = m.getAnnotation(SqlStatement.class);
        Sql sql = m.getAnnotation(Sql.class);
        if (sql == null && st == null) {
            this.parse(sm, entityClass, m, sqlId);
        } else if (sql != null) {
            this.sqlReady = sql.value();
            this.parseSqlReady(sm, entityClass, sql, m, sqlId);
        } else {
            this.parse(sm, entityClass, m, sqlId);
        }
    }

    protected void parseSqlReady(SQLManager sm, Class entityClass, Sql sql, Method m, String sqlId) {
        SqlStatementType sqlType;
        Class c = sql.returnType();
        if (c != Void.class) {
            this.renturnType = c;
        }
        if ((sqlType = sql.type()) == SqlStatementType.AUTO) {
            this.type = this.getTypeBySql(this.sqlReady);
            if (this.type == -1) {
                throw new BeetlSQLException(10, sqlId + " \u8bf7\u6307\u5b9aSql\u7c7b\u578b");
            }
            if (this.type == 0) {
                this.type = 4;
            }
        } else {
            this.type = sqlType == SqlStatementType.SELECT ? 2 : 4;
        }
        Class<?> returnType = m.getReturnType();
        if (this.type == 2 && List.class.isAssignableFrom(returnType)) {
            this.type = 3;
        }
    }

    protected void parse(SQLManager sm, Class entityClass, Method m, String sqlId) {
        SqlStatement st = m.getAnnotation(SqlStatement.class);
        String params = null;
        this.type = 0;
        if (st != null) {
            params = st.params();
            SqlStatementType sqlType = st.type();
            this.type = sqlType == SqlStatementType.AUTO ? this.getTypeBySqlId(sm, sqlId) : (sqlType == SqlStatementType.INSERT ? 0 : (sqlType == SqlStatementType.SELECT ? 2 : 4));
            Class c = st.returnType();
            if (c != Void.class) {
                this.renturnType = c;
            }
        } else {
            this.type = this.getTypeBySqlId(sm, sqlId);
        }
        if (params != null && params.length() != 0) {
            this.parseParams(sqlId, params, m);
        } else {
            this.parseAnnotation(sqlId, m);
        }
        Class<?> returnType = m.getReturnType();
        if (this.type == 0) {
            if (KeyHolder.class.isAssignableFrom(returnType)) {
                this.type = 1;
                this.keyHolderPos = -1;
            }
            return;
        }
        if (this.type == 2 && List.class.isAssignableFrom(returnType)) {
            this.type = 3;
        }
    }

    private void parseAnnotation(String sqlId, Method m) {
        LinkedHashMap<Integer, String> errorPara = new LinkedHashMap<Integer, String>();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        Class<?>[] paraTypes = m.getParameterTypes();
        for (int argIndex = 0; argIndex < parameterAnnotations.length; ++argIndex) {
            int length = parameterAnnotations[argIndex].length;
            if (length == 0) {
                Class<?> cls = paraTypes[argIndex];
                if (KeyHolder.class.isAssignableFrom(cls)) {
                    if (this.type == 0) {
                        this.type = 1;
                        this.keyHolderPos = argIndex;
                        continue;
                    }
                    errorPara.put(argIndex, "\u51fa\u73b0KeyHolder\uff0c\u4f46\u64cd\u4f5c\u7c7b\u578b\u662f" + this.getTypeDesc(this.type));
                    continue;
                }
                if (PageQuery.class.isAssignableFrom(cls)) {
                    this.type = 6;
                    break;
                }
                if (Map.class.isAssignableFrom(cls)) {
                    if (!this.parasPos.containsKey("_root")) {
                        this.mapRootPos = argIndex;
                        continue;
                    }
                    errorPara.put(argIndex, "\u8be5\u53c2\u6570\u6ca1\u6709\u7528@Param\uff0c\u4f46\u5df2\u7ecf\u6709\u4e00\u4e2aPojo\u6216\u8005Map");
                    continue;
                }
                if (List.class.isAssignableFrom(cls)) {
                    if (this.type == 4) {
                        this.type = 5;
                        continue;
                    }
                    errorPara.put(argIndex, "\u53ea\u6709\u6279\u91cf\u66f4\u65b0\u8bed\u53e5\u624d\u5141\u8bb8List\u53c2\u6570");
                    continue;
                }
                if (cls.isArray() && Map.class.isAssignableFrom(cls.getComponentType())) {
                    if (this.type == 4) {
                        this.type = 5;
                        continue;
                    }
                    errorPara.put(argIndex, "\u53ea\u6709\u6279\u91cf\u66f4\u65b0\u8bed\u53e5\u624d\u5141\u8bb8Map<String,Object>\u53c2\u6570");
                    continue;
                }
                Package pkg = cls.getPackage();
                if (pkg == null) {
                    errorPara.put(argIndex, "\u6ca1\u6709\u7533\u660eparams\u7684\u53c2\u6570");
                    continue;
                }
                String pkgName = pkg.getName();
                if (pkgName.startsWith("java")) {
                    errorPara.put(argIndex, "\u6ca1\u6709\u7533\u660eparams\u7684\u53c2\u6570");
                    continue;
                }
                if (this.mapRootPos != -1) {
                    errorPara.put(argIndex, "\u8be5\u53c2\u6570\u6ca1\u6709\u7528@Param\uff0c\u4f46\u5df2\u7ecf\u6709\u4e00\u4e2aPojo\u6216\u8005Map");
                    continue;
                }
                if (this.parasPos.containsKey("_root")) {
                    int pos = this.parasPos.get("_root");
                    errorPara.put(argIndex, "\u8be5\u53c2\u6570\u6ca1\u6709\u7528@Param\uff0c\u4f46\u5df2\u7ecf\u6709\u4e00\u4e2aPojo\u6216\u8005Map");
                    continue;
                }
                this.parasPos.put("_root", argIndex);
                continue;
            }
            for (int annIndex = 0; annIndex < length; ++annIndex) {
                Annotation paramAnn = parameterAnnotations[argIndex][annIndex];
                if (paramAnn instanceof Param) {
                    Param param = (Param)paramAnn;
                    this.parasPos.put(param.value(), argIndex);
                    continue;
                }
                if (paramAnn instanceof RowStart) {
                    if (this.paggerPos == null) {
                        this.paggerPos = new int[2];
                    }
                    this.paggerPos[0] = argIndex;
                    continue;
                }
                if (paramAnn instanceof RowSize) {
                    if (this.paggerPos == null) {
                        this.paggerPos = new int[2];
                    }
                    this.paggerPos[1] = argIndex;
                    continue;
                }
                errorPara.put(argIndex, "\u4e0d\u80fd\u8bc6\u522b\u7684\u6ce8\u89e3" + paramAnn.getClass());
            }
        }
        if (errorPara.size() != 0) {
            throw new BeetlSQLException(11, sqlId + "\u63a5\u53e3\u53c2\u6570\u5982\u4e0b\u4f4d\u7f6e" + errorPara + "\u5b9a\u4e49\u9519\u8bef\uff0c\u65e0\u6cd5\u6620\u5c04");
        }
        if (this.type == 5 && paraTypes.length != 1) {
            throw new BeetlSQLException(11, sqlId + "\u6279\u91cf\u66f4\u65b0\u53ea\u5141\u8bb8\u4e00\u4e2aList<?> \u6216\u8005Map[]\u53c2\u6570");
        }
        if (this.mapRootPos != -1) {
            this.parasPos.put("_root", this.mapRootPos);
        }
    }

    private void parseParams(String sqlId, String params, Method m) {
        String[] paraNames;
        Class<?>[] paraTypes = m.getParameterTypes();
        if (paraTypes.length != (paraNames = params.split(",")).length) {
            throw new BeetlSQLException(11, sqlId + "\u63a5\u53e3\u53c2\u6570\u7533\u660e\u9519\u8bef\uff0c\u8ddf@params\u4e0d\u4e00\u81f4");
        }
        this.parasPos.clear();
        for (int i = 0; i < paraNames.length; ++i) {
            String str = paraNames[i];
            if (str.equals("_st")) {
                if (this.paggerPos == null) {
                    this.paggerPos = new int[2];
                }
                this.paggerPos[0] = i;
                continue;
            }
            if (str.equals("_sz")) {
                if (this.paggerPos == null) {
                    this.paggerPos = new int[2];
                }
                this.paggerPos[1] = i;
                continue;
            }
            this.parasPos.put(str, i);
        }
    }

    private int getTypeBySql(String sql) {
        int index = (sql = sql.trim()).indexOf(32);
        if (index == -1) {
            return -1;
        }
        String sqlType = sql.substring(0, index);
        if (sqlType.equalsIgnoreCase("select")) {
            return 2;
        }
        if (sqlType.equalsIgnoreCase("insert")) {
            return 0;
        }
        if (sqlType.equalsIgnoreCase("delete")) {
            return 4;
        }
        if (sqlType.equalsIgnoreCase("update")) {
            return 4;
        }
        if (sqlType.equals("create")) {
            return 4;
        }
        if (sqlType.equals("drop")) {
            return 4;
        }
        return -1;
    }

    private int getTypeBySqlId(SQLManager sm, String sqlId) {
        String sql = null;
        SQLScript script = sm.getScript(sqlId);
        sql = script.getSql();
        int ret = this.getTypeBySql(sql);
        if (ret == -1) {
            throw new BeetlSQLException(10, sqlId + " \u8bf7\u6307\u5b9aSql\u7c7b\u578b");
        }
        return ret;
    }

    private String getTypeDesc(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return "insert";
            }
            case 2: 
            case 3: {
                return "select";
            }
            case 4: 
            case 5: {
                return "update/delete";
            }
        }
        throw new IllegalArgumentException("unknow type:" + type);
    }
}

