/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.mapper.BaseMapper;
import org.beetl.sql.core.mapper.BaseMapperInvoke;
import org.beetl.sql.core.mapper.DefaultMapperBuilder;
import org.beetl.sql.core.mapper.InnerMapperInvoke;
import org.beetl.sql.core.mapper.InsertMapperInvoke;
import org.beetl.sql.core.mapper.MethodDesc;
import org.beetl.sql.core.mapper.PageQueryMapperInvoke;
import org.beetl.sql.core.mapper.SQLReadyExecuteMapperInvoke;
import org.beetl.sql.core.mapper.SelecSingleMapperInvoke;
import org.beetl.sql.core.mapper.SelectMapperInvoke;
import org.beetl.sql.core.mapper.UpdateBatchMapperInvoke;
import org.beetl.sql.core.mapper.UpdateMapperInvoke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperJavaProxy
implements InvocationHandler {
    protected SQLManager sqlManager;
    protected Class<?> entityClass;
    DefaultMapperBuilder builder;

    public MapperJavaProxy() {
    }

    public MapperJavaProxy(DefaultMapperBuilder builder, SQLManager sqlManager, Class<?> mapperInterface) {
        this.sqlManager = sqlManager;
        this.builder = builder;
        this.mapperInterface(mapperInterface);
    }

    public MapperJavaProxy mapperInterface(Class<?> mapperInterface) {
        this.onResolveEntityClassFromMapperInterface(mapperInterface);
        return this;
    }

    public MapperJavaProxy entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    protected void checkArgs() {
    }

    public MapperJavaProxy build() {
        this.checkArgs();
        return this;
    }

    protected void onResolveEntityClassFromMapperInterface(Class<?> mapperInterface) {
        if (mapperInterface.isInterface()) {
            ParameterizedType pt;
            Type[] faces = mapperInterface.getGenericInterfaces();
            if (faces.length > 0 && faces[0] instanceof ParameterizedType && (pt = (ParameterizedType)faces[0]).getActualTypeArguments().length > 0) {
                this.entityClass = (Class)pt.getActualTypeArguments()[0];
            }
        } else {
            throw new IllegalArgumentException("mapperInterface is not interface.");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String sqlId = this.builder.getIdGen().getId(this.entityClass, method);
        BaseMapperInvoke invoke = null;
        Class<?> c = method.getDeclaringClass();
        if (c == BaseMapper.class) {
            invoke = new InnerMapperInvoke();
            Object ret = invoke.call(this.sqlManager, this.entityClass, sqlId, method, args);
            return ret;
        }
        MethodDesc desc = MethodDesc.getMetodDesc(this.sqlManager, this.entityClass, method, sqlId);
        if (desc.sqlReady.length() == 0) {
            switch (desc.type) {
                case 0: {
                    invoke = new InsertMapperInvoke();
                    break;
                }
                case 1: {
                    invoke = new InsertMapperInvoke();
                    break;
                }
                case 2: {
                    invoke = new SelecSingleMapperInvoke();
                    break;
                }
                case 3: {
                    invoke = new SelectMapperInvoke();
                    break;
                }
                case 4: {
                    invoke = new UpdateMapperInvoke();
                    break;
                }
                case 5: {
                    invoke = new UpdateBatchMapperInvoke();
                    break;
                }
                case 6: {
                    invoke = new PageQueryMapperInvoke();
                }
            }
            Object ret = invoke.call(this.sqlManager, this.entityClass, sqlId, method, args);
            return ret;
        }
        invoke = new SQLReadyExecuteMapperInvoke(desc.type);
        Object ret = invoke.call(this.sqlManager, this.entityClass, desc.sqlReady, method, args);
        return ret;
    }
}

