/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.annotatoin.Tail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanKit {
    private static final Map<Class, Method> tailBeans = new ConcurrentHashMap<Class, Method>();
    private static Method NULL = null;

    public static Method getTailMethod(Class type) {
        Method m = tailBeans.get(type);
        if (m != null) {
            if (m == NULL) {
                return null;
            }
            return m;
        }
        Tail an = BeanKit.getTailAnnotation(type);
        if (an == null) {
            tailBeans.put(type, NULL);
            return null;
        }
        m = BeanKit.tailMethod(type, an.set());
        if (m == null) {
            tailBeans.put(type, NULL);
            return null;
        }
        tailBeans.put(type, m);
        return m;
    }

    private static Tail getTailAnnotation(Class type) {
        if (Object.class.isAssignableFrom(type)) {
            Tail an = type.getAnnotation(Tail.class);
            if (an != null) {
                return an;
            }
            Class parent = type.getSuperclass();
            if (parent == null) {
                return null;
            }
            return BeanKit.getTailAnnotation(parent);
        }
        return null;
    }

    public static PropertyDescriptor[] propertyDescriptors(Class<?> c) throws IntrospectionException {
        BeanInfo beanInfo = null;
        beanInfo = Introspector.getBeanInfo(c);
        return beanInfo.getPropertyDescriptors();
    }

    public static List<Method> getterMethod(Class<?> c) {
        PropertyDescriptor[] ps;
        try {
            ps = BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (PropertyDescriptor p : ps) {
            if (p.getReadMethod() == null || p.getWriteMethod() == null) continue;
            list.add(p.getReadMethod());
        }
        return list;
    }

    public static Method tailMethod(Class type, String name) {
        try {
            Method m = type.getMethod(name, String.class, Object.class);
            return m;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Map getMapIns(Class cls) {
        if (cls == Map.class) {
            return new CaseInsensitiveHashMap();
        }
        try {
            return (Map)cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List getListIns(Class list) {
        if (list == List.class) {
            return new ArrayList();
        }
        try {
            return (List)list.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            NULL = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveHashMap
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = 9178606903603606031L;
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();

        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.containsKey(realKey);
        }

        @Override
        public Object get(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.get(realKey);
        }

        @Override
        public Object put(String key, Object value) {
            String oldKey = this.lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
            Object oldValue = super.remove(oldKey);
            super.put(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
            return super.remove(realKey);
        }
    }
}

