/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.statement.VarRef;

public class SQLVarRef
extends VarRef {
    String attr;

    public SQLVarRef(VarRef ref) {
        super(ref.attributes, ref.hasSafe, ref.safe, ref.token, ref.token);
        this.varIndex = ref.varIndex;
        this.attr = this.getAttrNameIfRoot(ref.token.text);
    }

    public Object evaluate(Context ctx) {
        Object value = ctx.vars[this.varIndex];
        if (value == Context.NOT_EXIST_OBJECT) {
            Object o = ctx.getGlobal("_root");
            if (o == null) {
                return super.evaluate(ctx);
            }
            try {
                Object realValue;
                ctx.vars[this.varIndex] = realValue = ObjectAA.defaultObjectAA().value(o, (Object)this.attr);
            }
            catch (Exception e) {
                BeetlException ex = new BeetlException("VAR_NOT_DEFINED", e.getMessage());
                ex.pushToken(this.token);
                throw ex;
            }
            return super.evaluate(ctx);
        }
        return super.evaluate(ctx);
    }

    private String getAttrNameIfRoot(String name) {
        int index = name.indexOf(46);
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }
}

