/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.ColDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDesc {
    private String name;
    private List<String> idNames = new ArrayList<String>(3);
    private List<String> metaIdNames = new ArrayList<String>(3);
    private String remark = null;
    private Set<String> cols = new LinkedHashSet<String>();
    private Set<String> metaCols = new LinkedHashSet<String>();
    private String metaName;
    private Map<Class, ClassDesc> classes = new LinkedHashMap<Class, ClassDesc>();
    private Map<String, ColDesc> colsDetail = new LinkedHashMap<String, ColDesc>();
    private String schema;

    public TableDesc(String name, String remark) {
        this.name = name.toUpperCase();
        this.metaName = name;
        this.remark = remark;
    }

    public boolean containCol(String col) {
        return this.cols.contains(col.toUpperCase());
    }

    public void addCols(ColDesc col) {
        this.colsDetail.put(col.colName, col);
        this.cols.add(col.colName.toUpperCase());
        this.metaCols.add(col.colName);
    }

    public ColDesc getColDesc(String name) {
        return this.colsDetail.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getMetaCols() {
        return this.metaCols;
    }

    public void setMetaCols(Set<String> metaCols) {
        this.metaCols = metaCols;
    }

    public String getMetaName() {
        return this.metaName;
    }

    public void setMetaName(String metaName) {
        this.metaName = metaName;
    }

    public List<String> getIdNames() {
        return this.idNames;
    }

    public void addIdName(String idName) {
        this.idNames.add(idName.toUpperCase());
        this.metaIdNames.add(idName);
    }

    public Set<String> getCols() {
        return this.cols;
    }

    public void setCols(Set<String> cols) {
        this.cols = cols;
    }

    public List<String> getMetaIdNames() {
        return this.metaIdNames;
    }

    public String getRemark() {
        return this.remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDesc getClassDesc(Class c, NameConversion nc) {
        ClassDesc classDesc = this.classes.get(c);
        if (classDesc == null) {
            Map<Class, ClassDesc> map = this.classes;
            synchronized (map) {
                classDesc = this.classes.get(c);
                if (classDesc != null) {
                    return classDesc;
                }
                classDesc = new ClassDesc(c, this, nc);
                this.classes.put(c, classDesc);
            }
        }
        return classDesc;
    }

    public ClassDesc getClassDesc(NameConversion nc) {
        ClassDesc c = new ClassDesc(this, nc);
        return c;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

