/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.annotatoin.SeqID;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.TableDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleStyle
extends AbstractDBStyle {
    @Override
    public String getPageSQL(String sql) {
        String pageSql = "SELECT * FROM  (  SELECT beeltT.*, ROWNUM beetl_rn  FROM ( \n" + sql + this.getOrderBy() + "\n )  beeltT " + " WHERE ROWNUM <" + this.HOLDER_START + "_pageEnd" + this.HOLDER_END + ") " + "WHERE beetl_rn >= " + this.HOLDER_START + "_pageOffset" + this.HOLDER_END;
        return pageSql;
    }

    @Override
    public void initPagePara(Map<String, Object> paras, long start, long size) {
        long s = start + (long)(this.offsetStartZero ? 1 : 0);
        paras.put("_pageOffset", s);
        paras.put("_pageEnd", s + size);
    }

    @Override
    public int getIdType(Method idMethod) {
        Annotation[] ans = idMethod.getAnnotations();
        int idType = 1;
        for (Annotation an : ans) {
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
        }
        return idType;
    }

    @Override
    public String getName() {
        return "oracle";
    }

    @Override
    public String getEscapeForKeyWord() {
        return "";
    }

    @Override
    public SQLSource genInsert(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("insert into " + this.getTableName(table) + this.lineSeparator);
        StringBuilder colSql = new StringBuilder("(");
        StringBuilder valSql = new StringBuilder(" VALUES (");
        int idType = 1;
        SQLSource source = new SQLSource();
        Set<String> cols = classDesc.getInCols();
        List<String> idCols = classDesc.getIdNames();
        for (String col : cols) {
            if (idCols.contains(col)) {
                idType = idCols.size() != 1 ? 1 : this.getIdType(classDesc.getIdMethods().get(col));
                if (idType == 2) continue;
                if (idType == 3) {
                    colSql.append(this.appendInsertColumn(cls, table, col));
                    SeqID seqId = classDesc.getIdMethods().get(col).getAnnotation(SeqID.class);
                    source.addIdCol(col);
                    valSql.append(seqId.name() + ".nextval,");
                    continue;
                }
                if (idType == 1) {
                    // empty if block
                }
            }
            colSql.append(this.appendInsertColumn(cls, table, col));
            valSql.append(this.appendInsertVlaue(cls, table, col));
        }
        sql.append(this.removeComma(colSql, null).append(")").append((CharSequence)this.removeComma(valSql, null)).append(")").toString());
        source.setTemplate(sql.toString());
        source.setIdType(idType);
        return source;
    }
}

