/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.ext.gen.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDesc {
    Class c;
    TableDesc table;
    NameConversion nc;
    Set<String> propertys = new LinkedHashSet<String>();
    Set<String> dateTypes = new LinkedHashSet<String>();
    Set<String> cols = new LinkedHashSet<String>();
    List<String> idProperties = new ArrayList<String>(3);
    Map<String, Method> idMethods = new HashMap<String, Method>(3);

    public ClassDesc(Class c, TableDesc table, NameConversion nc) {
        PropertyDescriptor[] ps;
        try {
            ps = BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        List<String> ids = table.getIdNames();
        this.idProperties = new ArrayList<String>(ids.size());
        this.idMethods = new HashMap<String, Method>(ids.size());
        for (PropertyDescriptor p : ps) {
            String tempId;
            if (p.getReadMethod() == null || p.getWriteMethod() == null) continue;
            Method readMethod = p.getReadMethod();
            String property = p.getName();
            String col = nc.getColName(c, property);
            this.propertys.add(property);
            if (table.containCol(col)) {
                this.cols.add(property);
            }
            if (ids.contains(tempId = col.toUpperCase())) {
                int index = ids.indexOf(tempId);
                this.idProperties.add(index, col);
                this.idMethods.put(col, readMethod);
            }
            if (!Date.class.isAssignableFrom(readMethod.getReturnType()) && !Calendar.class.isAssignableFrom(readMethod.getReturnType())) continue;
            this.dateTypes.add(property);
        }
    }

    public ClassDesc(TableDesc table, NameConversion nc) {
        this.table = table;
        this.nc = nc;
        for (String colName : table.getMetaCols()) {
            String prop = nc.getPropertyName(colName);
            this.propertys.add(prop);
            ColDesc colDes = table.getColDesc(colName);
            if (JavaType.isDateType(colDes.sqlType)) {
                this.dateTypes.add(prop);
            }
            this.cols.add(prop);
        }
        for (String name : table.getIdNames()) {
            this.idProperties.add(nc.getPropertyName(name));
        }
    }

    public List<String> getIdNames() {
        return this.idProperties;
    }

    public Set<String> getAttrs() {
        return this.propertys;
    }

    public boolean isDateType(String property) {
        return this.dateTypes.contains(property);
    }

    public Set<String> getInCols() {
        return this.cols;
    }

    public Map<String, Method> getIdMethods() {
        return this.idMethods;
    }
}

