/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Random;
import javax.sql.DataSource;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DSTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnectionSource
implements ConnectionSource {
    protected DataSource master = null;
    protected DataSource[] slaves = null;
    protected ThreadLocal<Integer> forceStatus = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public DefaultConnectionSource() {
    }

    public DefaultConnectionSource(DataSource master, DataSource[] slaves) {
        this.master = master;
        this.slaves = slaves;
    }

    @Override
    public Connection getConn(String sqlId, boolean isUpdate, String sql, List<?> paras) {
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        if (isUpdate) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        int status = this.forceStatus.get();
        if (status == 0 || status == 1) {
            return this.getReadConn(sqlId, sql, paras);
        }
        return this.getWriteConn(sqlId, sql, paras);
    }

    @Override
    public Connection getMaster() {
        return this.doGetConnectoin(this.master);
    }

    protected Connection getReadConn(String sqlId, String sql, List<?> paras) {
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(sqlId, sql, paras);
        }
        return this.nextSlaveConn();
    }

    protected Connection getWriteConn(String sqlId, String sql, List<?> paras) {
        return this.doGetConnectoin(this.master);
    }

    protected Connection nextSlaveConn() {
        DataSource ds = this.slaves[new Random().nextInt(this.slaves.length)];
        return this.doGetConnectoin(ds);
    }

    protected Connection doGetConnectoin(DataSource ds) {
        try {
            if (DSTransactionManager.inTrans()) {
                return DSTransactionManager.getCurrentThreadConnection(ds);
            }
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new BeetlSQLException(0, e);
        }
    }

    public DataSource getMasterSource() {
        return this.master;
    }

    public void setMasterSource(DataSource master) {
        this.master = master;
    }

    public DataSource[] getSlaves() {
        return this.slaves;
    }

    public void setSlaves(DataSource[] slaves) {
        this.slaves = slaves;
    }

    @Override
    public boolean isTransaction() {
        return DSTransactionManager.inTrans();
    }

    @Override
    public Connection getSlave() {
        if (this.slaves != null && this.slaves.length != 0) {
            return this.nextSlaveConn();
        }
        return this.getMaster();
    }

    @Override
    public void forceBegin(boolean isMaster) {
        this.forceStatus.set(isMaster ? 2 : 1);
    }

    @Override
    public void forceEnd() {
        this.forceStatus.set(0);
    }
}

