/*
 * Decompiled with CFR 0.152.
 */
package org.gsweb.components.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.PageContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gsweb.components.ui.TextBox;
import org.gsweb.components.util.ComponentResourceUtils;
import org.gsweb.components.util.UIComponent;

public class ToolBar
implements UIComponent {
    private static final String _CONFIG = "META-INF/resource/toolbar/ui.toolbar.json";
    private static String _configDatas = " { } ";
    private static Map<String, Object> _configDataMap;
    private PageContext pageContext = null;
    private String id = "";
    private String createNewEnable = "";
    private String saveEnabel = "";
    private String refreshEnable = "";
    private String cancelEnable = "";
    private String exportEnable = "";
    private String importEnable = "";
    private String createNewJsMethod = "";
    private String saveJsMethod = "";
    private String refreshJsMethod = "";
    private String cancelJsMethod = "";
    private String exportJsMethod = "";
    private String importJsMethod = "";
    private StringBuilder htmlOut = new StringBuilder();

    static {
        try {
            try {
                InputStream is = ToolBar.class.getClassLoader().getResource(_CONFIG).openStream();
                _configDatas = IOUtils.toString(is, "utf-8");
                is.close();
                is = null;
                _configDataMap = new ObjectMapper().readValue(_configDatas, LinkedHashMap.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (_configDataMap == null) {
                    _configDataMap = new HashMap<String, Object>();
                }
            }
        }
        finally {
            if (_configDataMap == null) {
                _configDataMap = new HashMap<String, Object>();
            }
        }
    }

    private Map<String, Object> getParameters(String type, String language) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", this.id);
        params.put("createNewEnable", this.createNewEnable);
        params.put("saveEnabel", this.saveEnabel);
        params.put("refreshEnable", this.refreshEnable);
        params.put("cancelEnable", this.cancelEnable);
        params.put("exportEnable", this.exportEnable);
        params.put("importEnable", this.importEnable);
        params.put("createNewJsMethod", this.createNewJsMethod);
        params.put("saveJsMethod", this.saveJsMethod);
        params.put("refreshJsMethod", this.refreshJsMethod);
        params.put("cancelJsMethod", this.cancelJsMethod);
        params.put("exportJsMethod", this.exportJsMethod);
        params.put("importJsMethod", this.importJsMethod);
        params.put("createNewName", "New");
        params.put("saveName", "Save");
        params.put("exportName", "Export");
        params.put("importName", "Import");
        params.put("refreshName", "Refresh");
        params.put("cancelName", "Cancel");
        params.put("fullscreenName", "FullScreen (Use only recommended when viewing data) / Exit FullScreen");
        this.setLabelNameFromProperties(params, language);
        this.setExperienceMode(params);
        return params;
    }

    private void setExperienceMode(Map<String, Object> params) {
        String experience = StringUtils.defaultString((String)_configDataMap.get("experience")).trim();
        params.put("experience", "Y".equals(experience) ? "Y" : "N");
    }

    private void setLabelNameFromProperties(Map<String, Object> params, String language) {
        String propFileName = "META-INF/resource/toolbar/ui.toolbar_" + language + ".properties";
        InputStream is = null;
        is = TextBox.class.getClassLoader().getResourceAsStream(propFileName);
        if (is != null) {
            Properties prop;
            block12: {
                prop = new Properties();
                try {
                    try {
                        prop.load(is);
                        params.put("createNewName", prop.get("createNewName"));
                        params.put("saveName", prop.get("saveName"));
                        params.put("exportName", prop.get("exportName"));
                        params.put("importName", prop.get("importName"));
                        params.put("refreshName", prop.get("refreshName"));
                        params.put("cancelName", prop.get("cancelName"));
                        params.put("fullscreenName", prop.get("fullscreenName"));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            prop.clear();
            prop = null;
        }
        is = null;
    }

    private void generateHtml() {
        Locale locale = ActionContext.getContext().getLocale();
        try {
            this.htmlOut.append(ComponentResourceUtils.generatorResource(ToolBar.class, "html", "META-INF/resource/toolbar/ui.toolbar.htm.ftl", this.getParameters("html", locale.getLanguage())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getScript() throws Exception {
        return "";
    }

    @Override
    public String getHtml() throws Exception {
        this.generateHtml();
        return this.htmlOut.toString();
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public String getCreateNewEnable() {
        return this.createNewEnable;
    }

    public void setCreateNewEnable(String createNewEnable) {
        this.createNewEnable = createNewEnable;
    }

    public String getSaveEnabel() {
        return this.saveEnabel;
    }

    public void setSaveEnabel(String saveEnabel) {
        this.saveEnabel = saveEnabel;
    }

    public String getRefreshEnable() {
        return this.refreshEnable;
    }

    public void setRefreshEnable(String refreshEnable) {
        this.refreshEnable = refreshEnable;
    }

    public String getCancelEnable() {
        return this.cancelEnable;
    }

    public void setCancelEnable(String cancelEnable) {
        this.cancelEnable = cancelEnable;
    }

    public String getExportEnable() {
        return this.exportEnable;
    }

    public void setExportEnable(String exportEnable) {
        this.exportEnable = exportEnable;
    }

    public String getImportEnable() {
        return this.importEnable;
    }

    public void setImportEnable(String importEnable) {
        this.importEnable = importEnable;
    }

    public String getCreateNewJsMethod() {
        return this.createNewJsMethod;
    }

    public void setCreateNewJsMethod(String createNewJsMethod) {
        this.createNewJsMethod = createNewJsMethod;
    }

    public String getSaveJsMethod() {
        return this.saveJsMethod;
    }

    public void setSaveJsMethod(String saveJsMethod) {
        this.saveJsMethod = saveJsMethod;
    }

    public String getRefreshJsMethod() {
        return this.refreshJsMethod;
    }

    public void setRefreshJsMethod(String refreshJsMethod) {
        this.refreshJsMethod = refreshJsMethod;
    }

    public String getCancelJsMethod() {
        return this.cancelJsMethod;
    }

    public void setCancelJsMethod(String cancelJsMethod) {
        this.cancelJsMethod = cancelJsMethod;
    }

    public String getExportJsMethod() {
        return this.exportJsMethod;
    }

    public void setExportJsMethod(String exportJsMethod) {
        this.exportJsMethod = exportJsMethod;
    }

    public String getImportJsMethod() {
        return this.importJsMethod;
    }

    public void setImportJsMethod(String importJsMethod) {
        this.importJsMethod = importJsMethod;
    }
}

