/*
 * Decompiled with CFR 0.152.
 */
package org.gsweb.components.ui;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gsweb.components.util.ComponentResourceUtils;
import org.gsweb.components.util.UIComponent;

public class Select
implements UIComponent {
    private PageContext pageContext = null;
    private String id = "";
    private String name = "";
    private String dataSource = "";
    private int width = 200;
    private String value = "";
    private String onChange = "";
    private String readonly = "N";
    private StringBuilder script = new StringBuilder();
    private StringBuilder htmlOut = new StringBuilder();
    private Map<String, String> dataMap = null;

    private void handlerDataSource() throws JsonParseException, JsonMappingException, IOException {
        if (this.dataMap != null) {
            return;
        }
        this.dataMap = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank(this.dataSource)) {
            return;
        }
        Object dataSourceObj = ActionContext.getContext().getValueStack().findValue(this.dataSource);
        if (dataSourceObj == null) {
            this.dataMap = new ObjectMapper().readValue(this.dataSource, LinkedHashMap.class);
            return;
        }
        if (dataSourceObj instanceof String) {
            this.dataMap = new ObjectMapper().readValue((String)dataSourceObj, LinkedHashMap.class);
        }
        if (dataSourceObj instanceof Map) {
            this.dataMap = (Map)dataSourceObj;
        }
    }

    private Map<String, Object> getParameters(String type) {
        try {
            this.handlerDataSource();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", this.id);
        params.put("name", this.name);
        params.put("width", String.valueOf(this.width));
        params.put("dataSource", this.dataMap);
        params.put("value", this.value);
        Object valueStackObj = null;
        if (!StringUtils.isBlank(this.value)) {
            valueStackObj = ActionContext.getContext().getValueStack().findValue(this.value);
        }
        if (valueStackObj != null && valueStackObj instanceof String) {
            params.put("value", StringEscapeUtils.escapeHtml4((String)valueStackObj));
        }
        if (valueStackObj != null && (valueStackObj instanceof Long || valueStackObj instanceof Integer)) {
            params.put("value", String.valueOf(valueStackObj));
        }
        if (!StringUtils.isBlank(this.onChange)) {
            params.put("onChange", this.onChange);
        }
        params.put("readonly", this.readonly);
        return params;
    }

    private void generateHtml() {
        try {
            this.htmlOut.append(ComponentResourceUtils.generatorResource(Select.class, "html", "META-INF/resource/select/ui.select.htm.ftl", this.getParameters("html")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScript() throws Exception {
        return this.script.toString();
    }

    @Override
    public String getHtml() throws Exception {
        this.generateHtml();
        return this.htmlOut.toString();
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }
}

