/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import bsh.Interpreter;
import com.netsteadfast.greenstep.base.model.ScriptTypeCode;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.renjin.sexp.AbstractAtomicVector;

public class ScriptExpressionUtils {
    private static ScriptEngineManager manager = new ScriptEngineManager();
    private static CompilerConfiguration groovyCompilerConfig = new CompilerConfiguration();
    private static ThreadLocal<Interpreter> bshInterpreterTL = new ThreadLocal();
    private static ThreadLocal<GroovyShell> groovyShellTL = new ThreadLocal();
    private static ThreadLocal<ScriptEngine> renjinScriptEngineTL = new ThreadLocal();

    static {
        groovyCompilerConfig.getOptimizationOptions().put("indy", true);
        groovyCompilerConfig.getOptimizationOptions().put("int", false);
    }

    public static void clearThreadLocal() {
        bshInterpreterTL.remove();
        groovyShellTL.remove();
        renjinScriptEngineTL.remove();
    }

    public static Interpreter buildBshInterpreter(boolean clean) {
        Interpreter bshInterpreter = null;
        bshInterpreter = bshInterpreterTL.get();
        if (bshInterpreter == null) {
            bshInterpreter = new Interpreter();
            bshInterpreterTL.set(bshInterpreter);
        }
        if (clean && bshInterpreter.getNameSpace() != null) {
            bshInterpreter.getNameSpace().clear();
        }
        return bshInterpreter;
    }

    public static GroovyShell buildGroovyShell(boolean fromThreadLocal) {
        if (fromThreadLocal) {
            GroovyShell groovyShell = null;
            groovyShell = groovyShellTL.get();
            if (groovyShell == null) {
                groovyShell = new GroovyShell(groovyCompilerConfig);
                groovyShellTL.set(groovyShell);
            }
            return groovyShell;
        }
        return new GroovyShell(groovyCompilerConfig);
    }

    public static PythonInterpreter buildPythonInterpreter(PyObject dist, boolean cleanup) {
        PythonInterpreter pyInterpreter = PythonInterpreter.threadLocalStateInterpreter(dist);
        if (cleanup) {
            pyInterpreter.cleanup();
        }
        return pyInterpreter;
    }

    public static ScriptEngine buildRenjinScriptEngine() {
        if (renjinScriptEngineTL.get() != null) {
            return renjinScriptEngineTL.get();
        }
        ScriptEngine engine = manager.getEngineByName("Renjin");
        renjinScriptEngineTL.set(engine);
        return engine;
    }

    public static Map<String, Object> execute(String type, String scriptExpression, Map<String, Object> results, Map<String, Object> parameters) throws Exception {
        if (!ScriptTypeCode.isTypeCode(type)) {
            throw new IllegalArgumentException("no support script language of : " + type);
        }
        if ("BSH".equals(type)) {
            ScriptExpressionUtils.executeBsh(scriptExpression, results, parameters);
        }
        if ("GROOVY".equals(type)) {
            ScriptExpressionUtils.executeGroovy(scriptExpression, results, parameters);
        }
        if ("PYTHON".equals(type)) {
            ScriptExpressionUtils.executeJython(scriptExpression, results, parameters);
        }
        if ("R".equals(type)) {
            ScriptExpressionUtils.executeRenjin(scriptExpression, results, parameters);
        }
        return results;
    }

    public static String replaceFormulaExpression(String type, String expression) throws Exception {
        if (StringUtils.isBlank(expression)) {
            return expression;
        }
        String bscExpression = expression;
        bscExpression = StringUtils.replace(bscExpression, "\u00f7", "/");
        bscExpression = StringUtils.replace(bscExpression, "\u00d7", "*");
        bscExpression = StringUtils.replace(bscExpression, "\u2212", "-");
        bscExpression = StringUtils.replace(bscExpression, "+", "+");
        if (!"PYTHON".equals(type)) {
            bscExpression = StringUtils.replace(bscExpression, "abs(", "Math.abs(");
            bscExpression = StringUtils.replace(bscExpression, "sqrt(", "Math.sqrt(");
        }
        return bscExpression;
    }

    private static void executeBsh(String scriptExpression, Map<String, Object> results, Map<String, Object> parameters) throws Exception {
        Interpreter bshInterpreter = ScriptExpressionUtils.buildBshInterpreter(true);
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                bshInterpreter.set(entry.getKey(), entry.getValue());
            }
        }
        bshInterpreter.eval(scriptExpression);
        if (results != null) {
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                entry.setValue(bshInterpreter.get(entry.getKey()));
            }
        }
    }

    private static void executeGroovy(String scriptExpression, Map<String, Object> results, Map<String, Object> parameters) throws Exception {
        GroovyShell groovyShell = ScriptExpressionUtils.buildGroovyShell(false);
        Binding binding = groovyShell.getContext();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
        }
        groovyShell.evaluate(scriptExpression);
        if (results != null) {
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                entry.setValue(binding.getVariable(entry.getKey()));
            }
        }
    }

    private static void executeJython(String scriptExpression, Map<String, Object> results, Map<String, Object> parameters) throws Exception {
        PythonInterpreter pyInterpreter = ScriptExpressionUtils.buildPythonInterpreter(null, true);
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                pyInterpreter.set(entry.getKey(), entry.getValue());
            }
        }
        pyInterpreter.exec(scriptExpression);
        if (results != null) {
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                entry.setValue(pyInterpreter.get(entry.getKey()));
            }
        }
    }

    private static void executeRenjin(String scriptExpression, Map<String, Object> results, Map<String, Object> parameters) throws Exception {
        ScriptEngine engine = ScriptExpressionUtils.buildRenjinScriptEngine();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                engine.put(entry.getKey(), entry.getValue());
            }
        }
        engine.eval(scriptExpression);
        if (results != null) {
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                Object res = engine.get(entry.getKey());
                if (res instanceof AbstractAtomicVector) {
                    if (((AbstractAtomicVector)res).length() <= 0) continue;
                    entry.setValue(((AbstractAtomicVector)res).getElementAsObject(0));
                    continue;
                }
                entry.setValue(res);
            }
        }
    }
}

