/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SFtpClientUtils {
    protected static Logger logger = Logger.getLogger(SFtpClientUtils.class);
    private static JSch jsch = new JSch();

    private static Session getSession(String user, String password, String addr, int port) throws JSchException {
        Session session = jsch.getSession(user, addr, port);
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(password);
        session.connect();
        return session;
    }

    public static Vector<ChannelSftp.LsEntry> getRemoteFileList(String user, String password, String addr, int port) throws JSchException, SftpException, Exception {
        return SFtpClientUtils.getRemoteFileList(user, password, addr, port, ".");
    }

    public static Vector<ChannelSftp.LsEntry> getRemoteFileList(String user, String password, String addr, int port, String cwd) throws JSchException, SftpException, Exception {
        Session session = SFtpClientUtils.getSession(user, password, addr, port);
        Vector lsVec = null;
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        try {
            try {
                lsVec = sftpChannel.ls(cwd);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            sftpChannel.exit();
            channel.disconnect();
            session.disconnect();
        }
        return lsVec;
    }

    public static void get(String user, String password, String addr, int port, String remoteFile, String localFile) throws JSchException, SftpException, Exception {
        Session session = SFtpClientUtils.getSession(user, password, addr, port);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        logger.info("get remote file: " + remoteFile + " write to:" + localFile);
        try {
            try {
                sftpChannel.get(remoteFile, localFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            sftpChannel.exit();
            channel.disconnect();
            session.disconnect();
        }
        File f = new File(localFile);
        if (!f.exists()) {
            f = null;
            logger.error("get remote file:" + remoteFile + " fail!");
            throw new Exception("get remote file:" + remoteFile + " fail!");
        }
        f = null;
        logger.info("success write:" + localFile);
    }

    public static void get(String user, String password, String addr, int port, List<String> remoteFile, List<String> localFile) throws JSchException, SftpException, Exception {
        Session session = SFtpClientUtils.getSession(user, password, addr, port);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        try {
            try {
                int i = 0;
                while (i < remoteFile.size()) {
                    String rf = remoteFile.get(i);
                    String lf = localFile.get(i);
                    logger.info("get remote file: " + rf + " write to:" + lf);
                    sftpChannel.get(rf, lf);
                    File f = new File(lf);
                    if (!f.exists()) {
                        f = null;
                        logger.error("get remote file:" + rf + " fail!");
                        throw new Exception("get remote file:" + rf + " fail!");
                    }
                    f = null;
                    logger.info("success write:" + lf);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            sftpChannel.exit();
            channel.disconnect();
            session.disconnect();
        }
    }

    public static void put(String user, String password, String addr, int port, List<String> localFile, List<String> remoteFile) throws JSchException, SftpException, Exception {
        Session session = SFtpClientUtils.getSession(user, password, addr, port);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        try {
            try {
                int i = 0;
                while (i < localFile.size()) {
                    String rf = remoteFile.get(i);
                    String lf = localFile.get(i);
                    logger.info("put local file: " + lf + " write to " + addr + " :" + rf);
                    sftpChannel.put(lf, rf);
                    logger.info("success write to " + addr + " :" + rf);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            sftpChannel.exit();
            channel.disconnect();
            session.disconnect();
        }
    }

    public static void rm(String user, String password, String addr, int port, List<String> fileName) throws JSchException, SftpException, Exception {
        if (fileName == null || fileName.size() < 1) {
            return;
        }
        Session session = SFtpClientUtils.getSession(user, password, addr, port);
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        try {
            try {
                for (String f : fileName) {
                    sftpChannel.rm(f);
                    logger.warn("success remove file from " + addr + " :" + fileName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            sftpChannel.exit();
            channel.disconnect();
            session.disconnect();
        }
    }
}

