/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.util.SimpleUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;

public class FSUtils {
    public static void mv(String sourceFile, String destFile) throws IOException, Exception {
        File srcFile = new File(sourceFile);
        File desFile = new File(destFile);
        FileUtils.moveFile(srcFile, desFile);
        srcFile = null;
        desFile = null;
    }

    public static void cp(String sourceFile, String destFile) throws IOException, Exception {
        File srcFile = new File(sourceFile);
        File desFile = new File(destFile);
        FileUtils.copyFile(srcFile, desFile);
        srcFile = null;
        desFile = null;
    }

    public static void rm(String removeFile) throws IOException, Exception {
        File rmFile = new File(removeFile);
        FileUtils.forceDelete(rmFile);
        rmFile = null;
    }

    public static String[] getList(String dir) {
        File directory = new File(dir);
        return directory.list();
    }

    public static String readStr(String fileFullPath) {
        String v = "";
        File f = new File(fileFullPath);
        try {
            if (f != null && f.exists()) {
                byte[] b = FileUtils.readFileToByteArray(f);
                v = new String(b);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f = null;
        return v;
    }

    public static boolean writeStr(String fileFullPath, String content) {
        boolean s = false;
        File f = new File(fileFullPath);
        try {
            if (f != null && f.exists()) {
                FileUtils.writeByteArrayToFile(f, SimpleUtils.getStr(content, "").getBytes());
                s = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f = null;
        return s;
    }

    public static boolean writeStr2(String fileFullPath, String content) {
        boolean s = false;
        File f = new File(fileFullPath);
        try {
            if (f != null) {
                FileUtils.writeByteArrayToFile(f, SimpleUtils.getStr(content, "").getBytes());
                s = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f = null;
        return s;
    }

    public static List<String> findFileListByCondition(String directory, String[] sub_name, String content) {
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> findList = new ArrayList<String>();
        File dir = new File(directory);
        if (dir != null && dir.isDirectory()) {
            FSUtils.findFileNext(directory, findList);
            String[] f = null;
            f = new String[findList.size()];
            int ix = 0;
            while (ix < findList.size()) {
                f[ix] = (String)findList.get(ix);
                ++ix;
            }
            ix = 0;
            while (f != null && ix < f.length) {
                boolean found_sub = false;
                int jx = 0;
                while (jx < sub_name.length && !found_sub) {
                    if (f[ix].toUpperCase().indexOf(sub_name[jx].toUpperCase()) > -1) {
                        found_sub = true;
                    }
                    ++jx;
                }
                if (found_sub && FSUtils.readStr(f[ix]).indexOf(content) > -1) {
                    list1.add(f[ix]);
                }
                ++ix;
            }
            f = null;
        }
        dir = null;
        findList.clear();
        return list1;
    }

    private static void findFileNext(String f, List<String> findList) {
        System.out.println("find: " + f);
        File file = new File(f);
        if (file != null) {
            if (file.isDirectory()) {
                File[] l = file.listFiles();
                int ix = 0;
                while (l != null && ix < l.length) {
                    FSUtils.findFileNext(l[ix].getPath(), findList);
                    ++ix;
                }
            } else {
                findList.add(f);
            }
        }
        file = null;
    }

    public static String getMimeType(File file) throws Exception {
        String mimeType = "";
        if (file == null || !file.exists() || file.isDirectory()) {
            return mimeType;
        }
        return Files.probeContentType(file.toPath());
    }

    public static String getMimeType(String filename) throws Exception {
        ConfigurableMimeFileTypeMap mfm = new ConfigurableMimeFileTypeMap();
        return mfm.getContentType(filename);
    }

    public static String getMimeType4URL(File file) throws IOException, MalformedURLException, Exception {
        String mimeType = "";
        if (file == null || !file.exists() || file.isDirectory()) {
            return mimeType;
        }
        URL url = new URL(file.getPath());
        URLConnection urlConnection = url.openConnection();
        mimeType = urlConnection.getContentType();
        return mimeType;
    }
}

