/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.util.ManualDataSourceFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class DataUtils {
    public static final String DATA_SOURCE_BEAN_ID = "dataSource";

    public static Connection getConnection(DataSource dataSource) throws CannotGetJdbcConnectionException, Exception {
        if (dataSource == null) {
            return null;
        }
        return DataSourceUtils.getConnection(dataSource);
    }

    public static Connection getConnection() {
        Connection conn = null;
        try {
            DataSource dataSource = (DataSource)AppContext.getBean(DATA_SOURCE_BEAN_ID);
            conn = DataUtils.getConnection(dataSource);
        }
        catch (CannotGetJdbcConnectionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public static void doReleaseConnection(Connection connection) {
        DataSource dataSource = (DataSource)AppContext.getBean(DATA_SOURCE_BEAN_ID);
        try {
            DataSourceUtils.doReleaseConnection(connection, dataSource);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static PlatformTransactionManager getPlatformTransactionManager() {
        return (PlatformTransactionManager)AppContext.getBean("transactionManager");
    }

    public static TransactionTemplate getTransactionTemplate() {
        return (TransactionTemplate)AppContext.getBean("transactionTemplate");
    }

    public static String[] getTables(Connection connection) throws Exception {
        DatabaseMetaData metaData = connection.getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = metaData.getTables(null, null, "%", types);
        ArrayList<String> tables = new ArrayList<String>();
        while (rs.next()) {
            tables.add(rs.getString("TABLE_NAME"));
        }
        String[] names = new String[tables.size()];
        tables.toArray(names);
        return names;
    }

    public static Map<String, Map<String, String>> getTableMetadata(Connection connection, String tableName) throws Exception {
        HashMap<String, Map<String, String>> tableMetadatas = new HashMap<String, Map<String, String>>();
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getColumns(null, null, tableName, null);
        while (resultSet.next()) {
            HashMap<String, String> metaDataMap = new HashMap<String, String>();
            String name = resultSet.getString("COLUMN_NAME");
            String type = resultSet.getString("TYPE_NAME");
            int size = resultSet.getInt("COLUMN_SIZE");
            metaDataMap.put("COLUMN_NAME", name);
            metaDataMap.put("TYPE_NAME", type);
            metaDataMap.put("COLUMN_SIZE", Integer.toString(size));
            tableMetadatas.put(name, metaDataMap);
        }
        return tableMetadatas;
    }

    public static Map<String, ClassMetadata> getClassMetadata(Session session) throws Exception {
        Map<String, ClassMetadata> classMetadataMap = session.getSessionFactory().getAllClassMetadata();
        return classMetadataMap;
    }

    public static NamedParameterJdbcTemplate getManualJdbcTemplate(DataSource dataSource) throws Exception {
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        return jdbcTemplate;
    }

    public static NamedParameterJdbcTemplate getJdbcTemplate() throws Exception {
        return (NamedParameterJdbcTemplate)AppContext.getBean("namedParameterJdbcTemplate");
    }

    public static NamedParameterJdbcTemplate getManualJdbcTemplate(Class<?> dataSourceClass, String url, String user, String password) throws Exception {
        return DataUtils.getManualJdbcTemplate(ManualDataSourceFactory.getDataSource(dataSourceClass, url, user, password));
    }

    public List<String> getEntityNameList(Session session) throws Exception {
        Map<String, ClassMetadata> classMetadataMap = DataUtils.getClassMetadata(session);
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, ClassMetadata> entry : classMetadataMap.entrySet()) {
            names.add(entry.getValue().getEntityName());
        }
        return names;
    }

    public ClassMetadata getClassMetadataByEntityName(Session session, String name) throws Exception {
        return session.getSessionFactory().getClassMetadata(name);
    }
}

