/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.sys;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.util.EncryptorUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class UserCurrentCookie {
    public static boolean foundCurrent(HttpServletRequest request) {
        boolean f = false;
        try {
            Cookie[] cookies = request.getCookies();
            int i = 0;
            while (!f && cookies != null && i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals("GREENSTEPSYSTEMCURRENTID")) {
                    f = true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return f;
    }

    public static void setCurrentId(HttpServletResponse response, String currentId, String sessionId, String account, String language) {
        try {
            String value = String.valueOf(currentId) + ";" + sessionId + ";" + account + ";" + language;
            String encValue = EncryptorUtils.encrypt(Constants.getEncryptorKey1(), Constants.getEncryptorKey2(), value);
            encValue = SimpleUtils.toHex(encValue);
            Cookie cookie = new Cookie("GREENSTEPSYSTEMCURRENTID", encValue);
            cookie.setPath("/");
            cookie.setValue(encValue);
            cookie.setMaxAge(86400);
            cookie.setHttpOnly(false);
            response.addCookie(cookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getCurrentData(HttpServletRequest request) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            Cookie[] cookies = request.getCookies();
            int i = 0;
            while (cookies != null && dataMap.size() == 0 && i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals("GREENSTEPSYSTEMCURRENTID")) {
                    if (StringUtils.isBlank(cookie.getValue())) {
                        return dataMap;
                    }
                    String decVal = SimpleUtils.deHex(cookie.getValue());
                    decVal = EncryptorUtils.decrypt(Constants.getEncryptorKey1(), Constants.getEncryptorKey2(), decVal);
                    String[] tmp = decVal.split(";");
                    if (tmp != null && tmp.length == 4) {
                        dataMap.put("currentId", tmp[0]);
                        dataMap.put("sessionId", tmp[1]);
                        dataMap.put("account", tmp[2]);
                        dataMap.put("lang", tmp[3]);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }
}

