/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.sys;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.sys.IUSessLogHelper;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public class USessLogHelperImpl
implements IUSessLogHelper {
    protected Logger log = Logger.getLogger(USessLogHelperImpl.class);
    private JdbcTemplate jdbcTemplate;

    private JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = (JdbcTemplate)AppContext.getBean("jdbcTemplate");
        }
        return this.jdbcTemplate;
    }

    @Override
    public void beginClean() throws Exception {
        this.log.info("delete tb_sys_usess data!... ");
        this.getJdbcTemplate().update("delete from tb_sys_usess");
    }

    @Override
    public void insert(String sessionId, String account) throws Exception {
        this.log.info("insert... :" + sessionId + " account:" + account);
        this.getJdbcTemplate().update("insert into tb_sys_usess(OID, SESSION_ID, ACCOUNT, CURRENT_ID, CUSERID, CDATE ) values (?, ?, ?, ?, ?, ?) ", SimpleUtils.getUUIDStr(), sessionId, account, SimpleUtils.getUUIDStr(), "SYS", new Date());
    }

    @Override
    public long count(String sessionId) throws Exception {
        return this.getJdbcTemplate().queryForObject("select count(*) from tb_sys_usess where SESSION_ID=?", new Object[]{sessionId}, Long.class);
    }

    @Override
    public void delete(String sessionId) throws Exception {
        this.log.info("delete... :" + sessionId);
        this.getJdbcTemplate().update("delete from tb_sys_usess where SESSION_ID=?", sessionId);
    }

    @Override
    public long countByAccount(String account) throws Exception {
        return this.getJdbcTemplate().queryForObject("select count(*) from tb_sys_usess where ACCOUNT=?", new Object[]{account}, Long.class);
    }

    @Override
    public List<String> findSessionIdByAccount(String account) throws Exception {
        return this.getJdbcTemplate().queryForList("select SESSION_ID from tb_sys_usess where ACCOUNT=?", new Object[]{account}, String.class);
    }

    @Override
    public long countByCurrent(String account, String currentId) throws Exception {
        return this.getJdbcTemplate().queryForObject("select count(*) from tb_sys_usess where ACCOUNT=? and CURRENT_ID=?", new Object[]{account, currentId}, Long.class);
    }

    @Override
    public long countByCurrent(String account, String currentId, String sessionId) throws Exception {
        return this.getJdbcTemplate().queryForObject("select count(*) from tb_sys_usess where ACCOUNT=? and CURRENT_ID=? and SESSION_ID=?", new Object[]{account, currentId, sessionId}, Long.class);
    }

    @Override
    public List<String> findCurrenrIdByAccount(String account) throws Exception {
        return this.getJdbcTemplate().queryForList("select CURRENT_ID from tb_sys_usess where ACCOUNT=?", new Object[]{account}, String.class);
    }

    @Override
    public List<String> findCurrenrIdByAccount(String account, String sessionId) throws Exception {
        return this.getJdbcTemplate().queryForList("select CURRENT_ID from tb_sys_usess where ACCOUNT=? and SESSION_ID=?", new Object[]{account, sessionId}, String.class);
    }
}

