/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.model;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PageOf
implements Serializable {
    private static final long serialVersionUID = -3060749245195776228L;
    public static final int[] Rows = new int[]{10, 20, 30, 50, 75, 100};
    private String countSize = "0";
    private String showRow = String.valueOf(Rows[0]);
    private String size = "1";
    private String select = "1";
    private String orderBy = "";
    private String sortType = "";

    public PageOf() {
    }

    public PageOf(String select, String size, String showRow, String countSize) {
        this.select = select;
        this.size = size;
        this.showRow = showRow;
        this.countSize = countSize;
    }

    public String getCountSize() {
        return this.countSize;
    }

    public void setCountSize(String countSize) {
        this.countSize = countSize;
    }

    public String getShowRow() {
        boolean c = false;
        int r = NumberUtils.toInt(this.showRow, 0);
        int i = 0;
        while (!c && i < Rows.length) {
            if (r == Rows[i]) {
                c = true;
            }
            ++i;
        }
        return c ? this.showRow : String.valueOf(Rows[0]);
    }

    public void setShowRow(String showRow) {
        this.showRow = showRow;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSelect() {
        if (NumberUtils.toInt(this.select, 0) < 1 || NumberUtils.toInt(this.select, 0) > 1000000) {
            return "1";
        }
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getOrderBy() {
        if (this.orderBy == null) {
            this.orderBy = "";
        }
        this.orderBy = this.orderBy.replaceAll(" ", "").replaceAll("\r", "").replaceAll("\t", "").replaceAll("\n", "").replaceAll(";", "").replaceAll("\"", "").replaceAll("'", "").replaceAll("-", "");
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getSortType() {
        if (!StringUtils.isBlank(this.sortType)) {
            this.sortType = this.sortType.toUpperCase().trim();
            if (!"ASC".equals(this.sortType) && !"DESC".equals(this.sortType)) {
                this.sortType = "ASC";
            }
        }
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public int getIntegerValue(String str) {
        if (str == null) {
            return 0;
        }
        return NumberUtils.toInt(str);
    }

    public void toCalculateSize() {
        int _size = 1;
        int _showRow = this.getIntegerValue(this.getShowRow());
        int _countSize = this.getIntegerValue(this.getCountSize());
        if (_countSize > 0 && _showRow > 0) {
            _size = _countSize / _showRow;
            if (_countSize % _showRow > 0) {
                ++_size;
            }
        }
        this.setSize(String.valueOf(_size));
        if (NumberUtils.toInt(this.select, 0) > _size) {
            this.select = String.valueOf(_size);
        }
    }

    @Deprecated
    public String getHtmlSelectOptions() {
        StringBuilder out = new StringBuilder();
        String sel = "";
        int ix = 1;
        while (ix <= this.getIntegerValue(this.size)) {
            sel = "";
            if (this.select.equals(String.valueOf(ix))) {
                sel = " SELECTED ";
            }
            out.append("<option value=\"").append(ix).append("\" ").append(sel).append(" >").append(ix).append("</option>");
            ++ix;
        }
        return out.toString();
    }

    @Deprecated
    public String getHtmlRowShowSelectOptions() {
        StringBuilder out = new StringBuilder();
        String sel = "";
        int ix = 0;
        while (Rows != null && ix < Rows.length) {
            sel = "";
            if (this.showRow.equals(String.valueOf(Rows[ix]))) {
                sel = " SELECTED ";
            }
            out.append("<option value=\"").append(Rows[ix]).append("\" ").append(sel).append(" >").append(Rows[ix]).append("</option>");
            ++ix;
        }
        if (out.length() == 0) {
            out.append("<option value=\"10\"").append(" >").append("10").append("</option>");
        }
        return out.toString();
    }

    public Map<String, Object> setQueryOrderSortParameter(Map<String, Object> queryParam) {
        if (queryParam == null) {
            return queryParam;
        }
        if (queryParam.get("orderBy") == null && !StringUtils.isBlank(this.getOrderBy())) {
            queryParam.put("orderBy", this.getOrderBy());
        }
        if (queryParam.get("sortType") == null && !StringUtils.isBlank(this.getSortType())) {
            queryParam.put("sortType", this.getSortType());
        }
        return queryParam;
    }
}

