/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.model;

import com.netsteadfast.greenstep.base.exception.ControllerException;
import com.netsteadfast.greenstep.base.model.IActionFieldsCheckUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CheckFieldHandler
implements Serializable {
    private static final long serialVersionUID = -8080347109488249788L;
    private Map<String, String> actionFields = null;
    private List<String> actionFieldsId = null;
    private Map<String, String> actionFieldsMessage = null;
    private List<String> fieldsNames = new LinkedList<String>();
    private List<String> fieldsMessages = new LinkedList<String>();
    private List<Class<IActionFieldsCheckUtils>> checkUtilsClazzs = new LinkedList<Class<IActionFieldsCheckUtils>>();
    private StringBuilder msg = new StringBuilder();

    public CheckFieldHandler() {
    }

    public CheckFieldHandler(Map<String, String> actionFields, List<String> actionFieldsId, Map<String, String> actionFieldsMessage) {
        this.actionFields = actionFields;
        this.actionFieldsId = actionFieldsId;
        this.actionFieldsMessage = actionFieldsMessage;
    }

    public CheckFieldHandler add(String fieldsName, Class<?> checkUtilsClass, String message) {
        this.fieldsNames.add(fieldsName);
        this.fieldsMessages.add(StringUtils.defaultString(message));
        this.checkUtilsClazzs.add(checkUtilsClass);
        return this;
    }

    public Map<String, String> getActionFields() {
        return this.actionFields;
    }

    public void setActionFields(Map<String, String> actionFields) {
        this.actionFields = actionFields;
    }

    public List<String> getActionFieldsId() {
        return this.actionFieldsId;
    }

    public void setActionFieldsId(List<String> actionFieldsId) {
        this.actionFieldsId = actionFieldsId;
    }

    public Map<String, String> getActionFieldsMessage() {
        return this.actionFieldsMessage;
    }

    public void setActionFieldsMessage(Map<String, String> actionFieldsMessage) {
        this.actionFieldsMessage = actionFieldsMessage;
    }

    public CheckFieldHandler process() {
        if (this.actionFieldsId == null) {
            this.actionFieldsId = new LinkedList<String>();
        }
        if (this.actionFieldsMessage == null) {
            this.actionFieldsMessage = new HashMap<String, String>();
        }
        if (this.fieldsNames == null || this.fieldsMessages == null || this.checkUtilsClazzs == null || this.fieldsNames.size() != this.fieldsMessages.size() || this.fieldsNames.size() != this.checkUtilsClazzs.size()) {
            throw new IllegalArgumentException("check filed args error!");
        }
        int i = 0;
        while (i < this.fieldsNames.size()) {
            String value = this.actionFields.get(this.fieldsNames.get(i));
            try {
                IActionFieldsCheckUtils checkUtils = this.checkUtilsClazzs.get(i).newInstance();
                if (!checkUtils.check(value)) {
                    this.actionFieldsId.add(this.fieldsNames.get(i));
                    this.actionFieldsMessage.put(this.fieldsNames.get(i), this.fieldsMessages.get(i).replaceAll("<BR/>", " "));
                    this.msg.append(this.fieldsMessages.get(i)).append("<BR/>");
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return this;
    }

    public CheckFieldHandler single(String fieldsName, boolean checkResult, String message) {
        if (this.actionFieldsId == null) {
            this.actionFieldsId = new LinkedList<String>();
        }
        if (this.actionFieldsMessage == null) {
            this.actionFieldsMessage = new HashMap<String, String>();
        }
        if (!checkResult) {
            return this;
        }
        String[] name = fieldsName.replaceAll(" ", "").split("[|]");
        int i = 0;
        while (i < name.length) {
            if (!StringUtils.isBlank(name[i])) {
                String idName = name[i].trim();
                this.actionFieldsId.add(idName);
                this.actionFieldsMessage.put(idName, message.replaceAll("<BR/>", " "));
                this.fieldsMessages.add(message);
            }
            ++i;
        }
        this.msg.append(StringUtils.defaultString(message)).append("<BR/>");
        return this;
    }

    public String getMessage() {
        return this.msg.toString();
    }

    public void throwMessage() throws ControllerException {
        if (this.msg == null || this.msg.length() < 1) {
            return;
        }
        throw new ControllerException(this.msg.toString());
    }
}

