/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.filter;

import com.netsteadfast.greenstep.base.model.AccountObj;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.MDC;

public class MDCUserServletFilter
implements Filter {
    private static final String _USERID_KEY_NAME = "userId";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession();
        boolean setUserId = false;
        if (session != null && session.getAttribute("SESSION_GSCORE_ACCOUNT") != null) {
            String accountId = ((AccountObj)session.getAttribute("SESSION_GSCORE_ACCOUNT")).getAccount();
            MDC.put(_USERID_KEY_NAME, accountId);
            setUserId = true;
        }
        if (!setUserId) {
            String url = httpRequest.getRequestURL().toString();
            if (url.indexOf("/services/") > -1) {
                MDC.put(_USERID_KEY_NAME, "CXF-WEBSERVICE");
                setUserId = true;
            }
            if (url.indexOf("/camel/") > -1) {
                MDC.put(_USERID_KEY_NAME, "CAMEL-ESB");
                setUserId = true;
            }
        }
        try {
            try {
                chain.doFilter(request, response);
            }
            catch (IOException | ServletException e) {
                e.printStackTrace();
                if (setUserId) {
                    MDC.remove(_USERID_KEY_NAME);
                }
            }
        }
        finally {
            if (setUserId) {
                MDC.remove(_USERID_KEY_NAME);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

