/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class CharsetFilter
implements Filter {
    private FilterConfig filterConfig;
    private String contentType = "text/html; charset=utf-8";
    private String encoding = "utf-8";

    public void destroy() {
    }

    private void resetCssAndJavascriptContentType(ServletRequest request, ServletResponse response, String requestUrl) {
        if (requestUrl.contains(".css")) {
            response.setContentType("text/css; charset=utf-8");
        }
        if (requestUrl.contains(".js")) {
            response.setContentType("application/javascript; charset=utf-8");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestUrl = httpServletRequest.getRequestURL().toString();
        if (requestUrl.contains(".html") || requestUrl.contains(".htm")) {
            response.setContentType(this.contentType);
            response.setCharacterEncoding(this.encoding);
        }
        this.resetCssAndJavascriptContentType(request, response, requestUrl);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        if (!StringUtils.isBlank(this.filterConfig.getInitParameter("encoding"))) {
            this.encoding = this.filterConfig.getInitParameter("encoding");
        }
        if (!StringUtils.isBlank(this.filterConfig.getInitParameter("contentType"))) {
            this.contentType = this.filterConfig.getInitParameter("contentType");
        }
    }
}

