/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.dao;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.model.BaseEntity;
import com.netsteadfast.greenstep.base.model.BaseEntityUtil;
import com.netsteadfast.greenstep.base.model.CustomeOperational;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.model.dynamichql.DynamicHql;
import com.netsteadfast.greenstep.util.DataUtils;
import com.netsteadfast.greenstep.util.DynamicHqlUtils;
import com.netsteadfast.greenstep.util.GenericsUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public abstract class BaseDAO<T extends Serializable, PK extends Serializable>
implements IBaseDAO<T, PK> {
    protected Logger logger = Logger.getLogger(BaseDAO.class);
    protected SessionFactory sessionFactory;
    protected Transaction hbmTransaction;
    private static String MAPPER_DEFINE_ID_SELECT_BY_PARAMS = ".selectByParams";
    private static String MAPPER_DEFINE_ID_SELECT_BY_VALUE = ".selectByValue";
    private SqlSession sqlSession;
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected Class<T> entityClass = GenericsUtils.getSuperClassGenricType(this.getClass());

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired
    @Required
    @Resource(name="sessionFactory")
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    @Autowired
    @Required
    @Resource(name="sqlSession")
    public void setSqlSession(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Autowired
    @Required
    @Resource(name="jdbcTemplate")
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Autowired
    @Required
    @Resource(name="namedParameterJdbcTemplate")
    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Connection getConnection() throws Exception {
        return DataUtils.getConnection();
    }

    public Session getCurrentSession() throws Exception {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public void updateByNativeSQL(String sql) throws DataAccessException, Exception {
        this.getJdbcTemplate().update(sql);
    }

    @Override
    public void executeByNativeSQL(String sql) throws DataAccessException, Exception {
        this.getJdbcTemplate().execute(sql);
    }

    @Override
    public <T> Object queryByNativeSQL(String sql, T rowMapper, Object ... args) throws DataAccessException, Exception {
        return this.getJdbcTemplate().queryForObject(sql, (RowMapper)rowMapper, args);
    }

    public int queryByNativeSQL(String sql) throws DataAccessException, Exception {
        return this.getJdbcTemplate().queryForObject(sql, Integer.class);
    }

    @Override
    public List queryForListByNativeSQL(String sql) throws DataAccessException, Exception {
        return this.getJdbcTemplate().queryForList(sql);
    }

    @Override
    public List queryForListByNativeSQL(String sql, RowMapper rowMapper) throws DataAccessException, Exception {
        return this.getJdbcTemplate().query(sql, rowMapper);
    }

    @Override
    public List queryForListByNativeSQL(String sql, Object[] args) throws DataAccessException, Exception {
        return this.getJdbcTemplate().queryForList(sql, args);
    }

    @Override
    public List queryForListByNativeSQL(String sql, Object[] args, RowMapper rowMapper) throws DataAccessException, Exception {
        return this.getJdbcTemplate().query(sql, args, rowMapper);
    }

    @Override
    public int count(String hql) throws Exception {
        return DataAccessUtils.intResult(this.getCurrentSession().createQuery(hql).list());
    }

    @Override
    public int count(String hql, Object ... args) throws Exception {
        Query query = this.getCurrentSession().createQuery(hql);
        int position = 0;
        while (args != null && position < args.length) {
            this.setQueryParams(query, Integer.toString(position), args[position]);
            ++position;
        }
        return DataAccessUtils.intResult(query.list());
    }

    @Override
    public List findList(String hql, int offset, int length) throws Exception {
        List list = null;
        Session hbmSession = this.getCurrentSession();
        if (hbmSession == null) {
            return list;
        }
        try {
            Query query = hbmSession.createQuery(hql);
            query.setFirstResult(offset);
            query.setMaxResults(length);
            list = query.list();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public <RO extends QueryResult<List<VO>>, VO extends Serializable> QueryResult<List<VO>> findPageQueryResult(String findHQL, String countHQL, Map<String, Object> params, int offset, int limit) throws Exception {
        QueryResult<List<VO>> result = new QueryResult<List<VO>>();
        List list = null;
        long count = 0L;
        Session hbmSession = this.getCurrentSession();
        try {
            Query query = hbmSession.createQuery(countHQL);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getKey().equals("orderBy") || entry.getKey().equals("sortType")) continue;
                    this.setQueryParams(query, entry.getKey(), entry.getValue());
                }
            }
            count = (Long)query.uniqueResult();
            int newOffset = offset;
            if (count > 0L) {
                if ((long)offset >= count && (newOffset = (int)(count - Long.valueOf(limit))) < 0) {
                    newOffset = 0;
                }
                query = hbmSession.createQuery(findHQL);
                if (params != null) {
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        if (entry.getKey().equals("orderBy") || entry.getKey().equals("sortType")) continue;
                        this.setQueryParams(query, entry.getKey(), entry.getValue());
                    }
                }
                query.setFirstResult(newOffset);
                query.setMaxResults(limit);
                list = query.list();
            }
            result.setRowCount(count);
            result.setOffset(newOffset);
            result.setLimit(limit);
            result.setFindHQL(findHQL);
            result.setCountHQL(countHQL);
            if (list != null && list.size() > 0) {
                result.setValue(list);
            } else {
                result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSystemMessage(new SystemMessage(e.getMessage()));
        }
        return result;
    }

    @Override
    public <RO extends QueryResult<List<VO>>, VO extends Serializable> QueryResult<List<VO>> findPageQueryResultByQueryName(String pageQueryName, Map<String, Object> params, int offset, int limit) throws Exception {
        String selectQueryName = String.valueOf(pageQueryName) + "-select";
        String countQueryName = String.valueOf(pageQueryName) + "-count";
        return this.findPageQueryResult(this.getDynamicHql(selectQueryName, params), this.getDynamicHql(countQueryName, params), params, offset, limit);
    }

    private void setQueryParams(Query query, String position, Object params) {
        if (params instanceof String) {
            query.setString(position, (String)params);
            return;
        }
        if (params instanceof Character) {
            query.setCharacter(position, ((Character)params).charValue());
            return;
        }
        if (params instanceof Double) {
            query.setDouble(position, (double)((Double)params));
            return;
        }
        if (params instanceof Byte) {
            query.setByte(position, (byte)((Byte)params));
            return;
        }
        if (params instanceof Integer) {
            query.setInteger(position, (int)((Integer)params));
            return;
        }
        if (params instanceof Long) {
            query.setLong(position, (long)((Long)params));
            return;
        }
        if (params instanceof Boolean) {
            query.setBoolean(position, (boolean)((Boolean)params));
            return;
        }
        if (params instanceof BigDecimal) {
            query.setBigDecimal(position, (BigDecimal)params);
            return;
        }
        if (params instanceof Date) {
            query.setDate(position, (Date)params);
            return;
        }
        if (params instanceof List) {
            List listParams = (List)params;
            this.setQueryParamsOfList(query, position, listParams);
            return;
        }
    }

    private void setQueryParamsOfList(Query query, String position, List listParams) {
        if (listParams == null || listParams.size() < 1) {
            return;
        }
        if (listParams.get(0) instanceof String) {
            query.setParameterList(position, listParams);
            return;
        }
        if (listParams.get(0) instanceof Character) {
            query.setParameterList(position, listParams);
            return;
        }
        if (listParams.get(0) instanceof BigDecimal) {
            query.setParameterList(position, listParams);
            return;
        }
        if (listParams.get(0) instanceof Integer) {
            query.setParameterList(position, listParams);
            return;
        }
        if (listParams.get(0) instanceof Long) {
            query.setParameterList(position, listParams);
            return;
        }
    }

    @Override
    public T save(T entityObject) throws Exception {
        this.getCurrentSession().save(entityObject);
        return entityObject;
    }

    @Override
    public T persist(T entityObject) throws Exception {
        this.getCurrentSession().persist(entityObject);
        return entityObject;
    }

    @Override
    public T update(T entityObject) throws Exception {
        this.getCurrentSession().update(entityObject);
        return entityObject;
    }

    @Override
    public T merge(T entityObject) throws Exception {
        this.getCurrentSession().merge(entityObject);
        return entityObject;
    }

    @Override
    public T delete(T entityObject) throws Exception {
        this.getCurrentSession().delete(entityObject);
        return entityObject;
    }

    @Override
    public void clear() throws Exception {
        this.getCurrentSession().clear();
    }

    @Override
    public T findByOid(T entityObj) throws Exception {
        return this.findByPK((Serializable)BaseEntityUtil.getPKOneValue((BaseEntity)entityObj));
    }

    @Override
    public int countByOid(T entityObj) throws Exception {
        return this.countByPK((Serializable)BaseEntityUtil.getPKOneValue((BaseEntity)entityObj));
    }

    private Query getQueryByKeyMap(String hqlHeadCmd, Map<String, Object> pkMap) throws Exception {
        StringBuilder hql = new StringBuilder();
        hql.append(hqlHeadCmd).append(" from ").append(this.getPersisentName()).append(" where 1=1 ");
        for (Map.Entry<String, Object> entry : pkMap.entrySet()) {
            hql.append(" and ").append(entry.getKey()).append("=:").append(entry.getKey());
        }
        Query query = this.getCurrentSession().createQuery(hql.toString());
        for (Map.Entry<String, Object> entry : pkMap.entrySet()) {
            this.setQueryParams(query, entry.getKey(), entry.getValue());
        }
        return query;
    }

    @Override
    public boolean deleteByPK(PK pk) throws Exception {
        boolean status = false;
        T entity = this.findByPK(pk);
        this.delete(entity);
        status = true;
        return status;
    }

    @Override
    public boolean deleteByPK(Map<String, Object> pkMap) throws Exception {
        boolean status = false;
        if (pkMap == null || pkMap.size() < 1) {
            return status;
        }
        Query query = this.getQueryByKeyMap("delete", pkMap);
        if (query.executeUpdate() > 0) {
            status = true;
        }
        return status;
    }

    @Override
    public T findByPK(PK pk) throws Exception {
        return (T)((Serializable)this.getCurrentSession().get(this.entityClass, (Serializable)pk));
    }

    @Override
    public T findByPK(Map<String, Object> pkMap) throws Exception {
        if (pkMap == null || pkMap.size() < 1) {
            return null;
        }
        Query query = this.getQueryByKeyMap("", pkMap);
        return (T)((Serializable)query.uniqueResult());
    }

    @Override
    public int countByPK(PK pk) throws Exception {
        return DataAccessUtils.intResult(this.getCurrentSession().createQuery(" select count(*) from " + this.getPersisentName() + " where " + BaseEntityUtil.getPKOneName((BaseEntity)this.entityClass.newInstance()) + "=?0 ").setString("0", (String)pk).list());
    }

    @Override
    public int countByPK(Map<String, Object> pkMap) throws Exception {
        if (pkMap == null || pkMap.size() < 1) {
            return 0;
        }
        Query query = this.getQueryByKeyMap("select count(*)", pkMap);
        return DataAccessUtils.intResult(query.list());
    }

    /*
     * WARNING - void declaration
     */
    private Query getQueryByParams(String type, Map<String, Object> params, Map<String, String> likeParams, Map<String, String> orderByParams, Map<String, CustomeOperational> customOperParams) throws Exception {
        StringBuilder sb = new StringBuilder();
        if ("count".equals(type)) {
            sb.append("select count(*) from ").append(this.getPersisentName()).append(" ");
        } else {
            sb.append("from ").append(this.getPersisentName()).append(" ");
        }
        int field = 0;
        if (params != null && params.size() > 0) {
            sb.append(" where 1=1 ");
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                sb.append(" and ").append(entry.getKey()).append("=?").append(field).append(" ");
                ++field;
            }
        }
        if (customOperParams != null && customOperParams.size() > 0) {
            if (params == null || params.size() < 1) {
                sb.append(" where 1=1 ");
            }
            for (Map.Entry<String, CustomeOperational> entry : customOperParams.entrySet()) {
                sb.append(" and ").append(entry.getValue().getField()).append(entry.getValue().getOp()).append("?").append(field).append(" ");
                ++field;
            }
        }
        if (likeParams != null && likeParams.size() > 0) {
            if (!(params != null && params.size() >= 1 || customOperParams != null && customOperParams.size() >= 1)) {
                sb.append(" where 1=1 ");
            }
            for (Map.Entry<String, String> entry : likeParams.entrySet()) {
                sb.append(" and ").append(entry.getKey()).append(" like ?").append(field).append(" ");
                ++field;
            }
        }
        if (orderByParams != null && orderByParams.size() > 0) {
            sb.append(" order by ");
            boolean bl = false;
            for (Map.Entry<String, Object> entry : orderByParams.entrySet()) {
                void var8_27;
                sb.append(entry.getKey()).append(" ").append((String)entry.getValue()).append(" ");
                if (++var8_27 >= orderByParams.size()) continue;
                sb.append(" , ");
            }
        }
        field = 0;
        Query query = this.getCurrentSession().createQuery(sb.toString());
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                this.setQueryParams(query, String.valueOf(field), entry.getValue());
                ++field;
            }
        }
        if (customOperParams != null && customOperParams.size() > 0) {
            for (Map.Entry<String, Object> entry : customOperParams.entrySet()) {
                this.setQueryParams(query, String.valueOf(field), ((CustomeOperational)entry.getValue()).getValue());
                ++field;
            }
        }
        if (likeParams != null && likeParams.size() > 0) {
            for (Map.Entry<String, Object> entry : likeParams.entrySet()) {
                this.setQueryParams(query, String.valueOf(field), entry.getValue());
                ++field;
            }
        }
        return query;
    }

    @Override
    public long countByParams(Map<String, Object> params, Map<String, String> likeParams) throws Exception {
        return DataAccessUtils.longResult(this.getQueryByParams("count", params, likeParams, null, null).list());
    }

    @Override
    public List<T> findListByParams(Map<String, Object> params, Map<String, String> likeParams, Map<String, String> orderParams) throws Exception {
        return this.getQueryByParams("select", params, likeParams, orderParams, null).list();
    }

    @Override
    public List<T> findListByParams2(Map<String, CustomeOperational> customOperParams) throws Exception {
        return this.getQueryByParams("select", null, null, null, customOperParams).list();
    }

    @Override
    public List<T> findListByParams2(Map<String, Object> params, Map<String, CustomeOperational> customOperParams) throws Exception {
        return this.getQueryByParams("select", params, null, null, customOperParams).list();
    }

    @Override
    public List<T> findListByParams2(Map<String, Object> params, Map<String, String> likeParams, Map<String, CustomeOperational> customOperParams) throws Exception {
        return this.getQueryByParams("select", params, likeParams, null, customOperParams).list();
    }

    @Override
    public List<T> findListByParams2(Map<String, Object> params, Map<String, String> likeParams, Map<String, CustomeOperational> customOperParams, Map<String, String> orderParams) throws Exception {
        return this.getQueryByParams("select", params, likeParams, orderParams, customOperParams).list();
    }

    @Override
    public T findByUK(T entityObject) throws Exception {
        return this.findByEntityUK(BaseEntityUtil.getUKParameter((BaseEntity)entityObject));
    }

    @Override
    public int countByUK(T entityObject) throws Exception {
        return this.countByEntityUK(BaseEntityUtil.getUKParameter((BaseEntity)entityObject));
    }

    @Override
    public T findByEntityUK(Map<String, Object> ukMap) throws Exception {
        if (ukMap == null || ukMap.size() < 1) {
            return null;
        }
        Query query = this.getQueryByKeyMap("", ukMap);
        return (T)((Serializable)query.uniqueResult());
    }

    @Override
    public int countByEntityUK(Map<String, Object> ukMap) throws Exception {
        if (ukMap == null || ukMap.size() < 1) {
            return 0;
        }
        Query query = this.getQueryByKeyMap("select count(*)", ukMap);
        return DataAccessUtils.intResult(query.list());
    }

    @Override
    public T getZeroPO() throws Exception {
        Serializable entity = (Serializable)this.entityClass.newInstance();
        if (entity instanceof BaseEntity) {
            ((BaseEntity)((Object)entity)).setOid(null);
        }
        return (T)entity;
    }

    public String getPersisentName() {
        return this.entityClass.getSimpleName();
    }

    @Override
    public String getIbatisMapperNameSpace() {
        return this.entityClass.getSimpleName();
    }

    @Override
    public List<T> ibatisSelectListByParams(Map<String, Object> params) throws Exception {
        return this.getSqlSession().selectList(String.valueOf(this.getIbatisMapperNameSpace()) + MAPPER_DEFINE_ID_SELECT_BY_PARAMS, params);
    }

    @Override
    public T ibatisSelectOneByValue(T valueObj) throws Exception {
        return (T)((Serializable)this.getSqlSession().selectOne(String.valueOf(this.getIbatisMapperNameSpace()) + MAPPER_DEFINE_ID_SELECT_BY_VALUE, valueObj));
    }

    @Override
    public DynamicHql getDynamicHqlResource(String resource) throws Exception {
        return DynamicHqlUtils.loadResource(resource);
    }

    @Override
    public String getDynamicHql(String queryName, Map<String, Object> paramMap) throws Exception {
        return this.getDynamicHql(String.valueOf(this.getPersisentName()) + "-dynamic-hql.xml", queryName, paramMap);
    }

    @Override
    public String getDynamicHql(String resource, String queryName, Map<String, Object> paramMap) throws Exception {
        return DynamicHqlUtils.process(resource, queryName, paramMap);
    }
}

