/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.model.SqlGenerateUtil;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class SysMessageUtil {
    private static JdbcTemplate jdbcTemplate;
    private static Map<String, String> sysMsgMap;

    static {
        sysMsgMap = new HashMap<String, String>();
        SysMessageUtil.init();
    }

    private static void init() {
        if (jdbcTemplate != null) {
            return;
        }
        try {
            jdbcTemplate = (JdbcTemplate)AppContext.getBean("jdbcTemplate");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String get(String code) {
        if (code == null || "".equals(code)) {
            return "";
        }
        if (sysMsgMap.get(code) != null) {
            return sysMsgMap.get(code);
        }
        SysMessageUtil.init();
        if (jdbcTemplate == null) {
            return "";
        }
        String message = null;
        TbSysCode sysCode = new TbSysCode();
        sysCode.setCode(code);
        Map<String, Object> queryMap = SysMessageUtil.getQuery(sysCode);
        if (queryMap == null) {
            return "";
        }
        try {
            message = jdbcTemplate.queryForObject((String)queryMap.get("sql"), (Object[])queryMap.get("params"), String.class);
            if (message != null) {
                sysMsgMap.put(code, message);
            }
        }
        catch (EmptyResultDataAccessException eda) {
            System.out.println(eda.getMessage().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message == null ? code : message;
    }

    private static Map<String, Object> getQuery(TbSysCode tbSysCode) {
        if (tbSysCode == null) {
            return null;
        }
        try {
            return SqlGenerateUtil.getFindByUK(tbSysCode, "NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

