/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.proxy;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.TestCase;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCookieManager;

public class XmlaCookieManagerTest
extends TestCase {
    private static final String receivedCookieKey = "Set-Cookie";
    public static final String sentCookieKey = "Cookie";
    public static final String cookieValue = "MyTestCookie=271B79EBCBAAA37C5C51B1979441E5AC";

    public void testCookieManager() throws Exception {
        UrlConnectionStub conn = new UrlConnectionStub(new URL("http://example.com"));
        XmlaOlap4jCookieManager manager = new XmlaOlap4jCookieManager();
        conn.connect();
        manager.storeCookies((URLConnection)conn);
        conn = new UrlConnectionStub(new URL("http://example.com"));
        manager.setCookies((URLConnection)conn);
        XmlaCookieManagerTest.assertEquals((String)sentCookieKey, (String)conn.getInternalCookieKey());
        XmlaCookieManagerTest.assertEquals((String)cookieValue, (String)conn.getInternalCookieValue());
    }

    private static class UrlConnectionStub
    extends HttpURLConnection {
        private String internalCookieKey = null;
        private String internalCookieValue = null;

        protected UrlConnectionStub(URL u) {
            super(u);
        }

        public void disconnect() {
        }

        public boolean usingProxy() {
            return false;
        }

        public void connect() throws IOException {
            this.connected = true;
        }

        public String getHeaderFieldKey(int n) {
            if (n == 1) {
                return XmlaCookieManagerTest.receivedCookieKey;
            }
            return null;
        }

        public String getHeaderField(int n) {
            if (n == 1) {
                return XmlaCookieManagerTest.cookieValue;
            }
            return null;
        }

        public void setRequestProperty(String key, String value) {
            this.internalCookieKey = key;
            this.internalCookieValue = value;
        }

        public String getInternalCookieKey() {
            return this.internalCookieKey;
        }

        public String getInternalCookieValue() {
            return this.internalCookieValue;
        }
    }
}

