/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.proxy;

import java.util.HashMap;
import junit.framework.TestCase;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jHttpProxy;

public class XmlaCachedProxyTest
extends TestCase {
    final XmlaOlap4jDriver dummyDriver = new XmlaOlap4jDriver(){};

    public void testCacheConfig() throws Exception {
        XmlaOlap4jHttpProxy proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
        HashMap<String, String> driverParameters = new HashMap<String, String>();
        HashMap<String, String> cacheProperties = new HashMap<String, String>();
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheConfig");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "LFU");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "30");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "50");
        proxy.setCache(driverParameters, cacheProperties);
    }

    public void testCacheModeError() throws Exception {
        XmlaOlap4jHttpProxy proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
        HashMap<String, String> driverParameters = new HashMap<String, String>();
        HashMap<String, String> cacheProperties = new HashMap<String, String>();
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheModeError");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "ERRONOUS VALUE MWAHAHAHAHA");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "30");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "50");
        try {
            proxy.setCache(driverParameters, cacheProperties);
        }
        catch (OlapException e) {
            return;
        }
        XmlaCachedProxyTest.fail((String)"The cache mode is not validated properly");
    }

    public void testCacheTimeoutError() throws Exception {
        XmlaOlap4jHttpProxy proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
        HashMap<String, String> driverParameters = new HashMap<String, String>();
        HashMap<String, String> cacheProperties = new HashMap<String, String>();
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheTimeoutError");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "LFU");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "EEE");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "50");
        try {
            proxy.setCache(driverParameters, cacheProperties);
        }
        catch (OlapException t) {
            try {
                cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "-30");
                proxy.setCache(driverParameters, cacheProperties);
            }
            catch (OlapException t2) {
                return;
            }
        }
        XmlaCachedProxyTest.fail((String)"The cache timeout is not validated properly");
    }

    public void testCacheSizeError() throws Exception {
        XmlaOlap4jHttpProxy proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
        HashMap<String, String> driverParameters = new HashMap<String, String>();
        HashMap<String, String> cacheProperties = new HashMap<String, String>();
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheSizeError");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "LFU");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "600");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "EEE");
        try {
            proxy.setCache(driverParameters, cacheProperties);
        }
        catch (OlapException t) {
            try {
                cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "-30");
                proxy.setCache(driverParameters, cacheProperties);
            }
            catch (OlapException t2) {
                return;
            }
        }
        XmlaCachedProxyTest.fail((String)"The cache size is not validated properly");
    }

    public void testCacheNameError() throws Exception {
        XmlaOlap4jHttpProxy proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
        HashMap<String, String> driverParameters = new HashMap<String, String>();
        HashMap<String, String> cacheProperties = new HashMap<String, String>();
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "Class which doesn't exist");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheNameError");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "LFU");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "600");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "50");
        try {
            proxy.setCache(driverParameters, cacheProperties);
        }
        catch (OlapException e) {
            return;
        }
        XmlaCachedProxyTest.fail((String)"The cache class name is not validated properly");
    }

    public void testCacheSharing() throws Exception {
        XmlaOlap4jHttpProxy proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
        HashMap<String, String> driverParameters = new HashMap<String, String>();
        HashMap<String, String> cacheProperties = new HashMap<String, String>();
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheSharing");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "LFU");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "600");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "50");
        try {
            proxy.setCache(driverParameters, cacheProperties);
        }
        catch (Throwable e) {
            XmlaCachedProxyTest.fail((String)"The cache class name is not validated properly");
        }
        driverParameters.put(XmlaOlap4jDriver.Property.SERVER.name(), "http://example2.com");
        driverParameters.put(XmlaOlap4jDriver.Property.CATALOG.name(), "CatalogName2");
        driverParameters.put(XmlaOlap4jDriver.Property.CACHE.name(), "org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.NAME.name(), "testCacheSharing");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.MODE.name(), "Erronous value which won't trigger an exception since a shared cache should be used.");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.TIMEOUT.name(), "Erronous value which won't trigger an exception since a shared cache should be used.");
        cacheProperties.put(XmlaOlap4jNamedMemoryCache.Property.SIZE.name(), "Erronous value which won't trigger an exception since a shared cache should be used.");
        try {
            proxy = new XmlaOlap4jHttpProxy(this.dummyDriver);
            proxy.setCache(driverParameters, cacheProperties);
        }
        catch (Throwable e) {
            XmlaCachedProxyTest.fail((String)"The cache is not properly shared since an error should not have been thrown.");
        }
    }
}

