/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.XmlaTester;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.XmlaOlap4jServerInfos;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxyException;
import org.olap4j.test.TestContext;

public class XmlaConnectionTest
extends TestCase {
    private TestContext testContext = TestContext.instance();
    private TestContext.Tester tester = this.testContext.getTester();
    public static final String DRIVER_CLASS_NAME = "org.olap4j.driver.xmla.XmlaOlap4jDriver";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.testContext = null;
        this.tester = null;
        super.tearDown();
    }

    public void testNoNonTrivalCallsOnConnect() throws Exception {
        String cookie = XmlaOlap4jDriver.nextCookie();
        try {
            XmlaOlap4jDriver.PROXY_MAP.put(cookie, new XmlaOlap4jProxyMock());
            try {
                Class.forName(DRIVER_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("oops", e);
            }
            Properties info = new Properties();
            info.setProperty(XmlaOlap4jDriver.Property.CATALOG.name(), "FoodMart");
            DriverManager.getConnection("jdbc:xmla:Server=http://foo;Catalog=FoodMart;TestProxyCookie=" + cookie, info);
        }
        catch (Throwable t) {
            t.printStackTrace();
            XmlaConnectionTest.fail((String)"Non-Trival Call executed during construction of XmlaOlap4j Connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDbSchemaSchemata() throws Exception {
        if (!this.testContext.getTester().getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA)) {
            return;
        }
        String oldValue = XmlaTester.getProxyClassName();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Proxy
        extends DoubleSubmissionTestProxy {
            boolean schemata;
            boolean cubes;

            public Proxy(Map<String, String> catalogNameUrls, String urlString) {
                super(catalogNameUrls, urlString);
                this.schemata = false;
                this.cubes = false;
            }

            @Override
            public byte[] get(XmlaOlap4jServerInfos serverInfos, String request) throws XmlaOlap4jProxyException {
                if (request.contains("DBSCHEMA_SCHEMATA")) {
                    if (this.schemata || this.cubes) {
                        Assert.fail();
                    }
                    this.schemata = true;
                } else if (request.contains("MDSCHEMA_CUBES") && (!this.schemata || this.cubes)) {
                    Assert.fail();
                }
                return super.get(serverInfos, request);
            }
        }
        XmlaTester.setProxyClassName(Proxy.class.getName());
        DoubleSubmissionTestProxy.setProxyClassName(oldValue);
        try {
            Connection connection = this.tester.createConnection();
            OlapConnection oConn = this.tester.getWrapper().unwrap(connection, OlapConnection.class);
            oConn.getOlapSchema().getCubes().size();
        }
        finally {
            XmlaTester.setProxyClassName(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoDoubleQuerySubmission() throws Exception {
        if (!this.testContext.getTester().getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) && !this.testContext.getTester().getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        String oldValue = XmlaTester.getProxyClassName();
        XmlaTester.setProxyClassName(DoubleSubmissionTestProxy.class.getName());
        DoubleSubmissionTestProxy.setProxyClassName(oldValue);
        try {
            Connection connection = this.tester.createConnection();
            Statement statement = connection.createStatement();
            OlapStatement olapStatement = this.tester.getWrapper().unwrap(statement, OlapStatement.class);
            CellSet cellSet = olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]");
            XmlaConnectionTest.assertNotNull((Object)cellSet);
            cellSet = olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q3]");
        }
        finally {
            XmlaTester.setProxyClassName(oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertyList() throws Exception {
        if (!this.testContext.getTester().getFlavor().equals((Object)TestContext.Tester.Flavor.XMLA) && !this.testContext.getTester().getFlavor().equals((Object)TestContext.Tester.Flavor.REMOTE_XMLA)) {
            return;
        }
        switch (this.testContext.getTester().getWrapper()) {
            case DBCP: {
                return;
            }
        }
        String oldValue = XmlaTester.getProxyClassName();
        try {
            XmlaTester.setProxyClassName(PropertyListTestProxy.class.getName());
            OlapConnection connection = this.tester.getWrapper().unwrap(this.tester.createConnection(), OlapConnection.class);
            OlapStatement olapStatement = connection.createStatement();
            olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]");
            XmlaConnectionTest.assertEquals((int)0, (int)PropertyListTestProxy.count);
            connection.close();
            connection = this.tester.getWrapper().unwrap(this.tester.createConnectionWithUserPassword(), OlapConnection.class);
            olapStatement = connection.createStatement();
            olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]");
            XmlaConnectionTest.assertEquals((int)0, (int)PropertyListTestProxy.count);
            connection.close();
            Properties props = new Properties();
            props.put("FOOBAR", "Bacon");
            connection = this.tester.getWrapper().unwrap(((XmlaTester)this.tester).createConnectionWithUserPassword(props), OlapConnection.class);
            olapStatement = connection.createStatement();
            try {
                olapStatement.executeOlapQuery("SELECT\n {[Measures].[Unit Sales],\n    [Measures].[Store Sales]} ON COLUMNS\n, Crossjoin({[Gender].[M]}, [Product].Children) ON ROWS\nFROM [Sales]\nWHERE [Time].[1997].[Q2]");
            }
            catch (Throwable e) {
                XmlaConnectionTest.assertTrue((boolean)e.getCause().getMessage().contains("FOOBAR"));
            }
            connection.close();
        }
        finally {
            XmlaTester.setProxyClassName(oldValue);
        }
    }

    private static class Encoder {
        private Encoder() {
        }

        private static String convertToHex(byte[] data) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < data.length; ++i) {
                int halfbyte = data[i] >>> 4 & 0xF;
                int two_halfs = 0;
                do {
                    if (0 <= halfbyte && halfbyte <= 9) {
                        buf.append((char)(48 + halfbyte));
                    } else {
                        buf.append((char)(97 + (halfbyte - 10)));
                    }
                    halfbyte = data[i] & 0xF;
                } while (two_halfs++ < 1);
            }
            return buf.toString();
        }
    }

    public static class PropertyListTestProxy
    extends DelegatingTestProxy {
        private static final String[] lookup = new String[]{"<PASSWORD>"};
        private static int count = 0;

        public PropertyListTestProxy(XmlaOlap4jProxy proxy) {
            super(proxy);
        }

        public byte[] get(XmlaOlap4jServerInfos serverInfos, String request) throws XmlaOlap4jProxyException {
            for (String token : lookup) {
                if (!request.contains(token)) continue;
                ++count;
            }
            return super.get(serverInfos, request);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleSubmissionTestProxy
    extends DelegatingTestProxy {
        final Map<String, String> requests = new HashMap<String, String>();
        private static String PROXY_CLASS_NAME;

        public DoubleSubmissionTestProxy(Map<String, String> catalogNameUrls, String urlString) {
            super(DoubleSubmissionTestProxy.createProxy(catalogNameUrls, urlString));
        }

        public static void setProxyClassName(String clazz) {
            PROXY_CLASS_NAME = clazz;
        }

        public static String getProxyClassName() {
            return PROXY_CLASS_NAME;
        }

        static XmlaOlap4jProxy createProxy(Map<String, String> catalogNameUrls, String urlString) {
            try {
                Class<?> clazz = Class.forName(DoubleSubmissionTestProxy.getProxyClassName());
                Constructor<?> constructor = clazz.getConstructor(Map.class, String.class);
                return (XmlaOlap4jProxy)constructor.newInstance(catalogNameUrls, urlString);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] get(XmlaOlap4jServerInfos serverInfos, String request) throws XmlaOlap4jProxyException {
            this.checkup(request);
            return super.get(serverInfos, request);
        }

        private void checkup(String request) {
            String hash = Encoder.convertToHex(request.getBytes());
            if (request.indexOf("<RequestType>MDSCHEMA_CUBES</RequestType>") == -1 && this.requests.containsKey(hash)) {
                throw new RuntimeException("DOUBLE-REQUEST");
            }
            this.requests.put(hash, request);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DelegatingTestProxy
    implements XmlaOlap4jProxy {
        protected final XmlaOlap4jProxy proxy;

        public DelegatingTestProxy(XmlaOlap4jProxy proxy) {
            this.proxy = proxy;
        }

        public byte[] get(XmlaOlap4jServerInfos serverInfos, String request) throws XmlaOlap4jProxyException {
            return this.proxy.get(serverInfos, request);
        }

        public Future<byte[]> submit(XmlaOlap4jServerInfos serverInfos, String request) {
            return this.proxy.submit(serverInfos, request);
        }

        public String getEncodingCharsetName() {
            return this.proxy.getEncodingCharsetName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XmlaOlap4jProxyMock
    implements XmlaOlap4jProxy {
        XmlaOlap4jProxyMock() {
        }

        public byte[] get(XmlaOlap4jServerInfos serverInfos, String request) {
            throw new RuntimeException("Non-Trivial Call!");
        }

        public String getEncodingCharsetName() {
            return "UTF-8";
        }

        public Future<byte[]> submit(XmlaOlap4jServerInfos serverInfos, String request) {
            throw new RuntimeException("Non-Trivial Call!");
        }
    }
}

