/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.math.BigDecimal;
import java.sql.Connection;
import junit.framework.TestCase;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.mdx.SelectNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Schema;
import org.olap4j.query.LimitFunction;
import org.olap4j.query.Query;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.olap4j.query.SortOrder;
import org.olap4j.test.TestContext;

public class OlapTest
extends TestCase {
    private TestContext testContext = TestContext.instance();
    private TestContext.Tester tester = this.testContext.getTester();
    private Connection connection;

    protected void tearDown() throws Exception {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
        this.testContext = null;
        this.tester = null;
    }

    public Cube getFoodmartCube(String cubeName) throws Exception {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Catalog catalog = (Catalog)olapConnection.getOlapCatalogs().get("FoodMart");
        NamedList schemas = catalog.getSchemas();
        if (schemas.size() == 0) {
            return null;
        }
        Schema schema = (Schema)schemas.get(0);
        NamedList cubes = schema.getCubes();
        if (cubes.size() == 0) {
            return null;
        }
        return (Cube)cubes.get(cubeName);
    }

    public void testModel() throws Exception {
        this.connection = this.tester.createConnection();
        OlapConnection olapConnection = this.tester.getWrapper().unwrap(this.connection, OlapConnection.class);
        Catalog catalog = (Catalog)olapConnection.getOlapCatalogs().get("FoodMart");
        NamedList schemas = catalog.getSchemas();
        if (schemas.size() == 0) {
            return;
        }
        Schema schema = (Schema)schemas.get(0);
        NamedList cubes = schema.getCubes();
        if (cubes.size() == 0) {
            return;
        }
        Cube cube = (Cube)cubes.get("Sales");
        Query query = new Query("my query", cube);
        QueryDimension productQuery = query.getDimension("Product");
        QueryDimension storeQuery = query.getDimension("Store");
        QueryDimension timeQuery = query.getDimension("Time");
        Member productMember = cube.lookupMember(TestContext.nameList("Product", "Drink"));
        storeQuery.include(Selection.Operator.CHILDREN, TestContext.nameList("Store", "USA"));
        productQuery.clearInclusions();
        productQuery.include(Selection.Operator.CHILDREN, productMember);
        productQuery.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Food"));
        timeQuery.include(Selection.Operator.CHILDREN, TestContext.nameList("Time", "1997"));
        query.getAxis((Axis)Axis.COLUMNS).addDimension(productQuery);
        assert (productQuery.getAxis() == query.getAxis((Axis)Axis.COLUMNS));
        query.getAxis((Axis)Axis.ROWS).addDimension(storeQuery);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeQuery);
        try {
            query.getAxis((Axis)Axis.ROWS).addDimension(storeQuery);
            OlapTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            OlapTest.assertTrue((boolean)e.getMessage().contains("dimension already on this axis"));
        }
        query.validate();
        query.execute();
        query.swapAxes();
        query.validate();
        query.execute();
    }

    public void testSelectionModes() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{[Product].[Product].[Drink].Children} ON ROWS\nFROM [Sales]", mdxString);
        productDimension.clearInclusions();
        productDimension.include(Selection.Operator.ANCESTORS, TestContext.nameList("Product", "Drink"));
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{Ascendants([Product].[Product].[Drink])} ON ROWS\nFROM [Sales]", mdxString);
        productDimension.clearInclusions();
        productDimension.include(Selection.Operator.DESCENDANTS, TestContext.nameList("Product", "Drink"));
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{Descendants([Product].[Product].[Drink])} ON ROWS\nFROM [Sales]", mdxString);
        productDimension.clearInclusions();
        productDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Product", "Drink"));
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{{[Product].[Product].[Drink], [Product].[Product].[Drink].Children}} ON ROWS\nFROM [Sales]", mdxString);
        productDimension.clearInclusions();
        productDimension.include(Selection.Operator.SIBLINGS, TestContext.nameList("Product", "Drink"));
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{[Product].[Product].[Drink].Siblings} ON ROWS\nFROM [Sales]", mdxString);
        NamedList productLevels = productDimension.getDimension().getDefaultHierarchy().getLevels();
        Level productDepartments = (Level)productLevels.get("Product Department");
        productDimension.include(productDepartments);
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{[Product].[Product].[Drink].Siblings, [Product].[Product].[Product Department].Members} ON ROWS\nFROM [Sales]", mdxString);
    }

    public void testMultipleDimensionSelections() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Store", "USA"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Time", "1997"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(storeDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nCrossJoin([Product].[Product].[Drink].Children, CrossJoin({[Store].[Store].[USA], [Store].[Store].[USA].Children}, [Time].[Time].[1997].Children)) ON ROWS\nFROM [Sales]", mdxString);
    }

    public void testSwapAxes() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{[Product].[Product].[Drink].Children} ON ROWS\nFROM [Sales]", mdxString);
        query.swapAxes();
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)measuresDimension.getAxis().getLocation());
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Product].[Product].[Drink].Children} ON COLUMNS,\n{[Measures].[Store Sales]} ON ROWS\nFROM [Sales]", mdxString);
        query.swapAxes();
    }

    public void testSortDimension() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.getAxis((Axis)Axis.FILTER).addDimension(timeDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{{[Product].[Product].[Drink], [Product].[Product].[Drink].Children}} ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", mdxString);
        query.getDimension("Product").sort(SortOrder.DESC);
        SelectNode sortedMdx = query.getSelect();
        String sortedMdxString = sortedMdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{Order({{[Product].[Product].[Drink], [Product].[Product].[Drink].Children}}, [Product].CurrentMember.Name, DESC)} ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", sortedMdxString);
        CellSet results = query.execute();
        String s = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[Product].[Drink]}\n{[Product].[Product].[Drink].[Dairy]}\n{[Product].[Product].[Drink].[Beverages]}\n{[Product].[Product].[Drink].[Alcoholic Beverages]}\nRow #0: 4,409.58\nRow #1: 629.69\nRow #2: 2,477.02\nRow #3: 1,302.87\n", s);
    }

    public void testSortMultipleDimension() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)timeDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nCrossJoin({[Time].[Time].[1997].[Q3].[7]}, [Product].[Product].[Drink].Children) ON ROWS\nFROM [Sales]", mdxString);
        query.getDimension("Product").sort(SortOrder.DESC);
        SelectNode sortedMdx = query.getSelect();
        String sortedMdxString = sortedMdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nCrossJoin({[Time].[Time].[1997].[Q3].[7]}, Order({[Product].[Product].[Drink].Children}, [Product].CurrentMember.Name, DESC)) ON ROWS\nFROM [Sales]", sortedMdxString);
        CellSet results = query.execute();
        String s = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Drink].[Dairy]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Drink].[Beverages]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Drink].[Alcoholic Beverages]}\nRow #0: 629.69\nRow #1: 2,477.02\nRow #2: 1,302.87\n", s);
        query.getAxis((Axis)Axis.ROWS).setNonEmpty(true);
        productDimension.clearInclusions();
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Food"));
        SelectNode sortedMdxNonEmpty = query.getSelect();
        String sortedMdxNonEmptyString = sortedMdxNonEmpty.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nNON EMPTY CrossJoin({[Time].[Time].[1997].[Q3].[7]}, Order({[Product].[Product].[Food].Children}, [Product].CurrentMember.Name, DESC)) ON ROWS\nFROM [Sales]", sortedMdxNonEmptyString);
        CellSet results2 = query.execute();
        String s2 = TestContext.toString(results2);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Starchy Foods]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Snacks]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Snack Foods]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Seafood]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Produce]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Meat]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Frozen Foods]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Eggs]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Deli]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Dairy]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Canned Products]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Canned Foods]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Breakfast Foods]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Baking Goods]}\n{[Time].[Time].[1997].[Q3].[7], [Product].[Product].[Food].[Baked Goods]}\nRow #0: 1,059.06\nRow #1: 1,248.92\nRow #2: 6,342.01\nRow #3: 383.20\nRow #4: 7,084.85\nRow #5: 304.61\nRow #6: 5,027.30\nRow #7: 930.70\nRow #8: 2,222.69\nRow #9: 2,896.81\nRow #10: 250.84\nRow #11: 3,301.38\nRow #12: 551.95\nRow #13: 3,232.70\nRow #14: 1,487.74\n", s2);
    }

    public void testSelectionContext() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Product", "All Products"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Time", "Year", "1997"));
        Selection selection = timeDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Time", "Year", "1997"));
        selection.addContext(productDimension.createSelection(TestContext.nameList("Product", "All Products", "Drink")));
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Store", "All Stores"));
        Selection children = storeDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Store", "All Stores"));
        children.addContext(productDimension.createSelection(TestContext.nameList("Product", "All Products", "Drink")));
        children.addContext(timeDimension.createSelection(TestContext.nameList("Time", "1997", "Q3")));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(storeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nHierarchize(Union(CrossJoin({[Product].[Product].[All Products], [Product].[Product].[All Products].Children}, CrossJoin({[Time].[Time].[1997]}, {[Store].[Store].[All Stores]})), Union(CrossJoin({[Product].[Product].[Drink]}, CrossJoin({[Time].[Time].[1997].[Q3]}, [Store].[Store].[All Stores].Children)), CrossJoin({[Product].[Product].[Drink]}, CrossJoin([Time].[Time].[1997].Children, {[Store].[Store].[All Stores]}))))) ON ROWS\nFROM [Sales]", mdxString);
        query.getAxis((Axis)Axis.ROWS).sort(SortOrder.ASC, TestContext.nameList("Measures", "Store Sales"));
        SelectNode sortedMdx = query.getSelect();
        String sortedMdxString = sortedMdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nOrder(Hierarchize(Union(CrossJoin({[Product].[Product].[All Products], [Product].[Product].[All Products].Children}, CrossJoin({[Time].[Time].[1997]}, {[Store].[Store].[All Stores]})), Union(CrossJoin({[Product].[Product].[Drink]}, CrossJoin({[Time].[Time].[1997].[Q3]}, [Store].[Store].[All Stores].Children)), CrossJoin({[Product].[Product].[Drink]}, CrossJoin([Time].[Time].[1997].Children, {[Store].[Store].[All Stores]}))))), [Measures].[Store Sales], ASC) ON ROWS\nFROM [Sales]", sortedMdxString);
        CellSet results = query.execute();
        String s = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[Product].[All Products], [Time].[Time].[1997], [Store].[Store].[All Stores]}\n{[Product].[Product].[Drink], [Time].[Time].[1997], [Store].[Store].[All Stores]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q1], [Store].[Store].[All Stores]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q2], [Store].[Store].[All Stores]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q3], [Store].[Store].[All Stores]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q3], [Store].[Store].[Canada]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q3], [Store].[Store].[Mexico]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q3], [Store].[Store].[USA]}\n{[Product].[Product].[Drink], [Time].[Time].[1997].[Q4], [Store].[Store].[All Stores]}\n{[Product].[Product].[Non-Consumable], [Time].[Time].[1997], [Store].[Store].[All Stores]}\n{[Product].[Product].[Food], [Time].[Time].[1997], [Store].[Store].[All Stores]}\nRow #0: 565,238.13\nRow #1: 48,836.21\nRow #2: 11,585.80\nRow #3: 11,914.58\nRow #4: 11,994.00\nRow #5: \nRow #6: \nRow #7: 11,994.00\nRow #8: 13,341.83\nRow #9: 107,366.33\nRow #10: 409,035.59\n", s);
    }

    public void testComplexSelectionContext() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "All Products"));
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "All Products"));
        QueryDimension timeDimension = query.getDimension("Time");
        Selection selection = timeDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Time", "Year", "1997"));
        selection.addContext(productDimension.createSelection(TestContext.nameList("Product", "All Products")));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)timeDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
    }

    public void testSortAxis() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.getAxis((Axis)Axis.FILTER).addDimension(timeDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{{[Product].[Product].[Drink], [Product].[Product].[Drink].Children}} ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", mdxString);
        query.getAxis((Axis)Axis.ROWS).sort(SortOrder.BASC, TestContext.nameList("Measures", "Store Sales"));
        SelectNode sortedMdx = query.getSelect();
        String sortedMdxString = sortedMdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nOrder({{[Product].[Product].[Drink], [Product].[Product].[Drink].Children}}, [Measures].[Store Sales], BASC) ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", sortedMdxString);
        CellSet results = query.execute();
        String s = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[Product].[Drink].[Dairy]}\n{[Product].[Product].[Drink].[Alcoholic Beverages]}\n{[Product].[Product].[Drink].[Beverages]}\n{[Product].[Product].[Drink]}\nRow #0: 629.69\nRow #1: 1,302.87\nRow #2: 2,477.02\nRow #3: 4,409.58\n", s);
    }

    public void testDimensionsOrder() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Store", "USA"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Time", "1997"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(storeDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nCrossJoin([Product].[Product].[Drink].Children, CrossJoin({[Store].[Store].[USA], [Store].[Store].[USA].Children}, [Time].[Time].[1997].Children)) ON ROWS\nFROM [Sales]", mdxString);
        query.getAxis((Axis)Axis.ROWS).pushDown(0);
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nCrossJoin({[Store].[Store].[USA], [Store].[Store].[USA].Children}, CrossJoin([Product].[Product].[Drink].Children, [Time].[Time].[1997].Children)) ON ROWS\nFROM [Sales]", mdxString);
        query.getAxis((Axis)Axis.ROWS).pullUp(2);
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\nCrossJoin({[Store].[Store].[USA], [Store].[Store].[USA].Children}, CrossJoin([Time].[Time].[1997].Children, [Product].[Product].[Drink].Children)) ON ROWS\nFROM [Sales]", mdxString);
    }

    public void testDimensionsHierarchize() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Store", "USA"));
        storeDimension.setHierarchizeMode(QueryDimension.HierarchizeMode.POST);
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(storeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{Hierarchize({{[Store].[Store].[USA], [Store].[Store].[USA].Children}}, POST)} ON ROWS\nFROM [Sales]", mdxString);
        storeDimension.setHierarchizeMode(QueryDimension.HierarchizeMode.PRE);
        query.validate();
        mdx = query.getSelect();
        mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{Hierarchize({{[Store].[Store].[USA], [Store].[Store].[USA].Children}})} ON ROWS\nFROM [Sales]", mdxString);
    }

    public void testQueryVersusParseTreeIndependence() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        OlapTest.assertEquals((Object)Axis.ROWS, (Object)productDimension.getAxis().getLocation());
        OlapTest.assertEquals((Object)Axis.COLUMNS, (Object)measuresDimension.getAxis().getLocation());
        SelectNode originalMdx = query.getSelect();
        String originalMdxString = originalMdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS,\n{{[Product].[Product].[Drink], [Product].[Product].[Drink].Children}} ON ROWS\nFROM [Sales]", originalMdxString);
        measuresDimension.include(Selection.Operator.SIBLINGS, TestContext.nameList("Measures", "Customer Count"));
        productDimension.include(Selection.Operator.SIBLINGS, TestContext.nameList("Product", "All Products", "Drink", "Alcoholic Beverages"));
        query.getAxis((Axis)Axis.ROWS).addDimension(query.getDimension("Gender"));
        query.getDimension("Gender").include(Selection.Operator.CHILDREN, TestContext.nameList("Gender", "All Gender"));
        query.getAxis(null).addDimension(query.getDimension("Product"));
        query.validate();
        OlapTest.assertEquals((String)originalMdxString, (String)originalMdx.toString());
    }

    public void testExclusionModes() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink", "Beverages"));
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Food", "Frozen Foods"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.getAxis((Axis)Axis.FILTER).addDimension(timeDimension);
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\n{[Product].[Product].[Drink].[Beverages].Children, [Product].[Product].[Food].[Frozen Foods].Children} ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Drinks]}\n{[Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Pure Juice Beverages]}\n{[Product].[Product].[Food].[Frozen Foods].[Breakfast Foods]}\n{[Product].[Product].[Food].[Frozen Foods].[Frozen Desserts]}\n{[Product].[Product].[Food].[Frozen Foods].[Frozen Entrees]}\n{[Product].[Product].[Food].[Frozen Foods].[Meat]}\n{[Product].[Product].[Food].[Frozen Foods].[Pizza]}\n{[Product].[Product].[Food].[Frozen Foods].[Vegetables]}\nRow #0: 103\nRow #1: 65\nRow #2: 125\nRow #3: 100\nRow #4: 143\nRow #5: 185\nRow #6: 68\nRow #7: 81\nRow #8: 105\nRow #9: 212\n", resultsString);
        query.getDimension("Product").exclude(TestContext.nameList("Product", "Drink", "Beverages", "Carbonated Beverages"));
        query.validate();
        mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\n{Except({[Product].[Product].[Drink].[Beverages].Children, [Product].[Product].[Food].[Frozen Foods].Children}, {[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]})} ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", mdxString);
        results = query.execute();
        resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Product].[Product].[Drink].[Beverages].[Drinks]}\n{[Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Pure Juice Beverages]}\n{[Product].[Product].[Food].[Frozen Foods].[Breakfast Foods]}\n{[Product].[Product].[Food].[Frozen Foods].[Frozen Desserts]}\n{[Product].[Product].[Food].[Frozen Foods].[Frozen Entrees]}\n{[Product].[Product].[Food].[Frozen Foods].[Meat]}\n{[Product].[Product].[Food].[Frozen Foods].[Pizza]}\n{[Product].[Product].[Food].[Frozen Foods].[Vegetables]}\nRow #0: 65\nRow #1: 125\nRow #2: 100\nRow #3: 143\nRow #4: 185\nRow #5: 68\nRow #6: 81\nRow #7: 105\nRow #8: 212\n", resultsString);
    }

    public void testExclusionMultipleDimensionModes() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink", "Beverages"));
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Food", "Frozen Foods"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Store", "USA"));
        query.getAxis((Axis)Axis.ROWS).addDimension(storeDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.FILTER).addDimension(timeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nHierarchize(Union(CrossJoin({[Store].[Store].[USA]}, [Product].[Product].[Drink].[Beverages].Children), CrossJoin({[Store].[Store].[USA]}, [Product].[Product].[Food].[Frozen Foods].Children))) ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Carbonated Beverages]}\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Drinks]}\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Pure Juice Beverages]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Breakfast Foods]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Frozen Desserts]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Frozen Entrees]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Meat]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Pizza]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Vegetables]}\nRow #0: 103\nRow #1: 65\nRow #2: 125\nRow #3: 100\nRow #4: 143\nRow #5: 185\nRow #6: 68\nRow #7: 81\nRow #8: 105\nRow #9: 212\n", resultsString);
        query.getDimension("Product").exclude(TestContext.nameList("Product", "Drink", "Beverages", "Carbonated Beverages"));
        query.validate();
        mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nHierarchize(Union(CrossJoin({[Store].[Store].[USA]}, Except({[Product].[Product].[Drink].[Beverages].Children}, {[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]})), CrossJoin({[Store].[Store].[USA]}, Except({[Product].[Product].[Food].[Frozen Foods].Children}, {[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]})))) ON ROWS\nFROM [Sales]\nWHERE {[Time].[Time].[1997].[Q3].[7]}", mdxString);
        results = query.execute();
        resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Drinks]}\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Store].[Store].[USA], [Product].[Product].[Drink].[Beverages].[Pure Juice Beverages]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Breakfast Foods]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Frozen Desserts]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Frozen Entrees]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Meat]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Pizza]}\n{[Store].[Store].[USA], [Product].[Product].[Food].[Frozen Foods].[Vegetables]}\nRow #0: 65\nRow #1: 125\nRow #2: 100\nRow #3: 143\nRow #4: 185\nRow #5: 68\nRow #6: 81\nRow #7: 105\nRow #8: 212\n", resultsString);
    }

    public void testCompoundFilter() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "Drink", "Beverages"));
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "Food", "Frozen Foods"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Store", "USA"));
        query.getAxis((Axis)Axis.ROWS).addDimension(storeDimension);
        query.getAxis((Axis)Axis.FILTER).addDimension(productDimension);
        query.getAxis((Axis)Axis.FILTER).addDimension(timeDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\n{[Store].[Store].[USA]} ON ROWS\nFROM [Sales]\nWHERE Hierarchize(Union(CrossJoin({[Product].[Product].[Drink].[Beverages]}, {[Time].[Time].[1997].[Q3].[7]}), CrossJoin({[Product].[Product].[Food].[Frozen Foods]}, {[Time].[Time].[1997].[Q3].[7]})))", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{[Product].[Product].[Drink].[Beverages], [Time].[Time].[1997].[Q3].[7]}\n{[Product].[Product].[Food].[Frozen Foods], [Time].[Time].[1997].[Q3].[7]}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Store].[Store].[USA]}\nRow #0: 1,187\n", resultsString);
    }

    public void testMultipleHierarchyConsistency() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.setHierarchyConsistent(true);
        timeDimension.include(TestContext.nameList("Time.Weekly", "1997", "10", "23"));
        timeDimension.include(TestContext.nameList("Time.Weekly", "1997", "10", "28"));
        timeDimension.include(TestContext.nameList("Time.Weekly", "Year", "1997"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\n{{[Time].[Weekly].[1997]}, Filter({{[Time].[Weekly].[1997].[10].[23], [Time].[Weekly].[1997].[10].[28]}}, (Exists(Ancestor([Time].[Weekly].CurrentMember, [Time].[Weekly].[Year]), {[Time].[Weekly].[1997]}).Count  > 0))} ON ROWS\nFROM [Sales]", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Time].[Weekly].[1997]}\n{[Time].[Weekly].[1997].[10].[23]}\n{[Time].[Weekly].[1997].[10].[28]}\nRow #0: 86,837\nRow #1: 123\nRow #2: \n", resultsString);
        query.validate();
    }

    public void testLimitFunction() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        NamedList productLevels = productDimension.getDimension().getDefaultHierarchy().getLevels();
        Level productLevel = (Level)productLevels.get("Product Category");
        productDimension.include(productLevel);
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.getAxis((Axis)Axis.ROWS).topCount(new BigDecimal(6));
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nTopCount({[Product].[Product].[Product Category].Members}, 6) ON ROWS\nFROM [Sales]", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Product].[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]}\n{[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Drinks]}\n{[Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Pure Juice Beverages]}\n{[Product].[Product].[Drink].[Dairy].[Dairy]}\nRow #0: 2,219\nRow #1: 1,107\nRow #2: 798\nRow #3: 1,391\nRow #4: 1,096\nRow #5: 1,367\n", resultsString);
        query.getAxis((Axis)Axis.ROWS).limit(LimitFunction.TopCount, new BigDecimal(6), "[Measures].[Sales Count]");
        query.validate();
        mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nTopCount({[Product].[Product].[Product Category].Members}, 6, [Measures].[Sales Count]) ON ROWS\nFROM [Sales]", mdxString);
        results = query.execute();
        resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Product].[Product].[Food].[Snack Foods].[Snack Foods]}\n{[Product].[Product].[Food].[Produce].[Vegetables]}\n{[Product].[Product].[Food].[Dairy].[Dairy]}\n{[Product].[Product].[Food].[Baking Goods].[Jams and Jellies]}\n{[Product].[Product].[Food].[Produce].[Fruit]}\n{[Product].[Product].[Food].[Deli].[Meat]}\nRow #0: 9,957\nRow #1: 6,751\nRow #2: 4,189\nRow #3: 3,868\nRow #4: 3,836\nRow #5: 3,064\n", resultsString);
    }

    public void testFilter() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        NamedList productLevels = productDimension.getDimension().getDefaultHierarchy().getLevels();
        Level productLevel = (Level)productLevels.get("Product Category");
        productDimension.include(productLevel);
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        query.getAxis((Axis)Axis.ROWS).addDimension(productDimension);
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        query.getAxis((Axis)Axis.ROWS).filter("InStr(Product.CurrentMember.Name, 'Beverages') > 0");
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nFilter({[Product].[Product].[Product Category].Members}, InStr(Product.CurrentMember.Name, 'Beverages') > 0) ON ROWS\nFROM [Sales]", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Pure Juice Beverages]}\nRow #0: 1,107\nRow #1: 1,391\nRow #2: 1,096\n", resultsString);
        query.getAxis((Axis)Axis.ROWS).limit(LimitFunction.TopCount, new BigDecimal(2), "[Measures].[Sales Count]");
        query.validate();
        mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nTopCount(Filter({[Product].[Product].[Product Category].Members}, InStr(Product.CurrentMember.Name, 'Beverages') > 0), 2, [Measures].[Sales Count]) ON ROWS\nFROM [Sales]", mdxString);
        results = query.execute();
        resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n{[Product].[Product].[Drink].[Beverages].[Hot Beverages]}\n{[Product].[Product].[Drink].[Beverages].[Carbonated Beverages]}\nRow #0: 1,391\nRow #1: 1,107\n", resultsString);
        query.getAxis((Axis)Axis.ROWS).filter("InStr(Product.CurrentMember.Name, 'NoMatchingString') > 0");
        query.validate();
        mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Sales Count]} ON COLUMNS,\nTopCount(Filter({[Product].[Product].[Product Category].Members}, InStr(Product.CurrentMember.Name, 'NoMatchingString') > 0), 2, [Measures].[Sales Count]) ON ROWS\nFROM [Sales]", mdxString);
        results = query.execute();
        resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Measures].[Sales Count]}\nAxis #2:\n", resultsString);
    }

    public void testHierarchyConsistency() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.setHierarchyConsistent(true);
        NamedList productLevels = productDimension.getDimension().getDefaultHierarchy().getLevels();
        Level productLevel = (Level)productLevels.get("Product Category");
        productDimension.include(productLevel);
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "Food", "Deli"));
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "Food", "Dairy"));
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "Product Family", "Food"));
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "All Products"));
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.setHierarchyConsistent(true);
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q3", "7"));
        timeDimension.include(TestContext.nameList("Time", "Year", "1997", "Q4", "11"));
        timeDimension.include(TestContext.nameList("Time", "Year", "1997"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Sales Count"));
        query.getAxis((Axis)Axis.COLUMNS).addDimension(productDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(timeDimension);
        query.validate();
        String mdxString = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{{[Product].[Product].[All Products]}, {[Product].[Product].[Food]}, Filter({{[Product].[Product].[Food].[Deli], [Product].[Product].[Food].[Dairy]}}, (Exists(Ancestor([Product].[Product].CurrentMember, [Product].[Product].[Product Family]), {[Product].[Product].[Food]}).Count  > 0)), Filter({{[Product].[Product].[Product Category].Members}}, ((Exists(Ancestor([Product].[Product].CurrentMember, [Product].[Product].[Product Family]), {[Product].[Product].[Food]}).Count  > 0) AND (Exists(Ancestor([Product].[Product].CurrentMember, [Product].[Product].[Product Department]), {[Product].[Product].[Food].[Deli], [Product].[Product].[Food].[Dairy]}).Count  > 0)))} ON COLUMNS,\n{{[Time].[Time].[1997]}, Filter({{[Time].[Time].[1997].[Q3].[7], [Time].[Time].[1997].[Q4].[11]}}, (Exists(Ancestor([Time].[Time].CurrentMember, [Time].[Time].[Year]), {[Time].[Time].[1997]}).Count  > 0))} ON ROWS\nFROM [Sales]", mdxString);
        CellSet results = query.execute();
        String resultsString = TestContext.toString(results);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Product].[Product].[All Products]}\n{[Product].[Product].[Food]}\n{[Product].[Product].[Food].[Deli]}\n{[Product].[Product].[Food].[Dairy]}\n{[Product].[Product].[Food].[Dairy].[Dairy]}\n{[Product].[Product].[Food].[Deli].[Meat]}\n{[Product].[Product].[Food].[Deli].[Side Dishes]}\nAxis #2:\n{[Time].[Time].[1997]}\n{[Time].[Time].[1997].[Q3].[7]}\n{[Time].[Time].[1997].[Q4].[11]}\nRow #0: 266,773\nRow #0: 191,940\nRow #0: 12,037\nRow #0: 12,885\nRow #0: 12,885\nRow #0: 9,433\nRow #0: 2,604\nRow #1: 23,763\nRow #1: 17,036\nRow #1: 1,050\nRow #1: 1,229\nRow #1: 1,229\nRow #1: 847\nRow #1: 203\nRow #2: 25,270\nRow #2: 18,278\nRow #2: 1,312\nRow #2: 1,232\nRow #2: 1,232\nRow #2: 1,033\nRow #2: 279\n", resultsString);
        query.validate();
        query.getAxis((Axis)Axis.ROWS).addDimension(measuresDimension);
        productDimension.clearInclusions();
        productDimension.include(Selection.Operator.MEMBER, TestContext.nameList("Product", "Product Family", "Food"));
        String mdxString2 = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Product].[Product].[Food]} ON COLUMNS,\nHierarchize(Union(CrossJoin(Filter({[Time].[Time].[1997].[Q3].[7]}, (Exists(Ancestor([Time].[Time].CurrentMember, [Time].[Time].[Year]), {[Time].[Time].[1997]}).Count  > 0)), {[Measures].[Sales Count]}), Union(CrossJoin(Filter({[Time].[Time].[1997].[Q4].[11]}, (Exists(Ancestor([Time].[Time].CurrentMember, [Time].[Time].[Year]), {[Time].[Time].[1997]}).Count  > 0)), {[Measures].[Sales Count]}), CrossJoin({[Time].[Time].[1997]}, {[Measures].[Sales Count]})))) ON ROWS\nFROM [Sales]", mdxString2);
        CellSet results2 = query.execute();
        String resultsString2 = TestContext.toString(results2);
        TestContext.assertEqualsVerbose("Axis #0:\n{}\nAxis #1:\n{[Product].[Product].[Food]}\nAxis #2:\n{[Time].[Time].[1997], [Measures].[Sales Count]}\n{[Time].[Time].[1997].[Q3].[7], [Measures].[Sales Count]}\n{[Time].[Time].[1997].[Q4].[11], [Measures].[Sales Count]}\nRow #0: 62,445\nRow #1: 5,552\nRow #2: 5,944\n", resultsString2);
        QueryDimension customerDimension = query.getDimension("Customers");
        customerDimension.setHierarchyConsistent(true);
        NamedList customerLevels = customerDimension.getDimension().getDefaultHierarchy().getLevels();
        Level country = (Level)customerLevels.get("Country");
        Level state = (Level)customerLevels.get("State Province");
        customerDimension.include(country);
        customerDimension.include(state);
        query.getAxis((Axis)Axis.ROWS).removeDimension(timeDimension);
        query.getAxis((Axis)Axis.ROWS).addDimension(customerDimension);
        String mdxString3 = query.getSelect().toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Product].[Product].[Food]} ON COLUMNS,\nHierarchize(Union(CrossJoin({[Measures].[Sales Count]}, [Customers].[Customers].[Country].Members), CrossJoin({[Measures].[Sales Count]}, [Customers].[Customers].[State Province].Members))) ON ROWS\nFROM [Sales]", mdxString3);
    }

    public void testNonMandatoryQueryAxis() throws Exception {
        Cube cube = this.getFoodmartCube("Sales");
        if (cube == null) {
            OlapTest.fail((String)"Could not find Sales cube");
        }
        Query query = new Query("my query", cube);
        QueryDimension productDimension = query.getDimension("Product");
        productDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Product", "Drink"));
        QueryDimension storeDimension = query.getDimension("Store");
        storeDimension.include(Selection.Operator.INCLUDE_CHILDREN, TestContext.nameList("Store", "USA"));
        storeDimension.setHierarchizeMode(QueryDimension.HierarchizeMode.POST);
        QueryDimension timeDimension = query.getDimension("Time");
        timeDimension.include(Selection.Operator.CHILDREN, TestContext.nameList("Time", "1997"));
        QueryDimension measuresDimension = query.getDimension("Measures");
        measuresDimension.include(TestContext.nameList("Measures", "Store Sales"));
        query.getAxis((Axis)Axis.COLUMNS).addDimension(measuresDimension);
        SelectNode mdx = query.getSelect();
        String mdxString = mdx.toString();
        TestContext.assertEqualsVerbose("SELECT\n{[Measures].[Store Sales]} ON COLUMNS\nFROM [Sales]", mdxString);
        try {
            query.validate();
            OlapTest.fail();
        }
        catch (OlapException e) {
            OlapTest.assertEquals((int)0, (int)e.getCause().getMessage().indexOf("A valid Query requires at least one dimension on the rows axis."));
        }
    }

    public static void main(String[] args) throws Exception {
        OlapTest olapTest = new OlapTest();
        olapTest.testModel();
    }
}

