/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import org.espy.arima.ArimaFitterStrategy;
import org.espy.arima.ArimaProcess;
import org.espy.arima.DefaultArimaProcess;
import org.espy.arima.DoubleUtils;
import org.espy.arima.StationarityTest;

class MethodOfMomentsArimaFitterStrategy
implements ArimaFitterStrategy {
    private static final int MAX_INTEGRATION_ORDER = 10;
    private static final double MA_EPSILON = 0.001;
    private static final double MA_ITERATION_LIMIT = 100.0;
    private final int arOrder;
    private final int maOrder;
    private final boolean estimateIntegrationOrder;
    private double tau0;
    private double[] observations;
    private double[] acvf;
    private int integrationOrder;
    private double constant;
    private double variation;
    private double[] arCoefficients = DoubleUtils.EMPTY_DOUBLE_ARRAY;
    private double[] maCoefficients = DoubleUtils.EMPTY_DOUBLE_ARRAY;
    private Phase[] phases = new Phase[]{new IntegrationOrderPhase(), new AcvfPhase(), new ArPhase(), new MaPhase()};

    public MethodOfMomentsArimaFitterStrategy(double[] observations, int arOrder, int maOrder) {
        this.observations = observations;
        this.arOrder = arOrder;
        this.maOrder = maOrder;
        this.estimateIntegrationOrder = true;
    }

    public MethodOfMomentsArimaFitterStrategy(double[] observations, int arOrder, int maOrder, int integrationOrder) {
        this.observations = observations;
        this.arOrder = arOrder;
        this.maOrder = maOrder;
        this.integrationOrder = integrationOrder;
        this.estimateIntegrationOrder = false;
    }

    @Override
    public ArimaProcess fit() {
        Phase[] phaseArray = this.phases;
        int n = this.phases.length;
        int n2 = 0;
        while (n2 < n) {
            Phase phase = phaseArray[n2];
            phase.perform();
            ++n2;
        }
        return this.createArimaProcess();
    }

    private ArimaProcess createArimaProcess() {
        DefaultArimaProcess arimaProcess = new DefaultArimaProcess();
        arimaProcess.setIntegrationOrder(this.integrationOrder);
        arimaProcess.setConstant(this.constant);
        arimaProcess.setVariation(this.variation);
        arimaProcess.setArCoefficients(this.arCoefficients);
        arimaProcess.setMaCoefficients(this.maCoefficients);
        return arimaProcess;
    }

    private final class AcvfPhase
    implements Phase {
        private AcvfPhase() {
        }

        @Override
        public void perform() {
            int acvfValueLimit = MethodOfMomentsArimaFitterStrategy.this.observations.length;
            int acvfSize = MethodOfMomentsArimaFitterStrategy.this.arOrder + MethodOfMomentsArimaFitterStrategy.this.maOrder + 1;
            MethodOfMomentsArimaFitterStrategy.this.acvf = new double[acvfSize];
            int i = 0;
            while (i < acvfSize) {
                double acvfValue = 0.0;
                int j = 0;
                while (j < acvfValueLimit) {
                    acvfValue += (MethodOfMomentsArimaFitterStrategy.this.observations[j] - MethodOfMomentsArimaFitterStrategy.this.constant) * (MethodOfMomentsArimaFitterStrategy.this.observations[j + i] - MethodOfMomentsArimaFitterStrategy.this.constant);
                    ++j;
                }
                ((MethodOfMomentsArimaFitterStrategy)MethodOfMomentsArimaFitterStrategy.this).acvf[i] = acvfValue / (double)MethodOfMomentsArimaFitterStrategy.this.observations.length;
                --acvfValueLimit;
                ++i;
            }
        }
    }

    private final class ArPhase
    implements Phase {
        private ArPhase() {
        }

        @Override
        public void perform() {
            if (MethodOfMomentsArimaFitterStrategy.this.arOrder > 0) {
                this.fetchArCoefficients();
                this.fetchConstant();
            }
        }

        private void fetchArCoefficients() {
            double[][] arMatrix = this.getArMatrix();
            double[] arVector = this.getMaVector();
            MethodOfMomentsArimaFitterStrategy.this.arCoefficients = DoubleUtils.solveSLE(arMatrix, arVector);
        }

        private double[][] getArMatrix() {
            double[][] result = new double[MethodOfMomentsArimaFitterStrategy.this.arOrder][MethodOfMomentsArimaFitterStrategy.this.arOrder];
            int i = 1;
            while (i <= MethodOfMomentsArimaFitterStrategy.this.arOrder) {
                int j = 1;
                while (j <= MethodOfMomentsArimaFitterStrategy.this.arOrder) {
                    result[i - 1][j - 1] = MethodOfMomentsArimaFitterStrategy.this.acvf[Math.abs(MethodOfMomentsArimaFitterStrategy.this.maOrder + i - j)];
                    ++j;
                }
                ++i;
            }
            return result;
        }

        private double[] getMaVector() {
            double[] result = new double[MethodOfMomentsArimaFitterStrategy.this.arOrder];
            System.arraycopy(MethodOfMomentsArimaFitterStrategy.this.acvf, MethodOfMomentsArimaFitterStrategy.this.maOrder + 1, result, 0, MethodOfMomentsArimaFitterStrategy.this.arOrder);
            return result;
        }

        private void fetchConstant() {
            double factor = 1.0;
            double[] dArray = MethodOfMomentsArimaFitterStrategy.this.arCoefficients;
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double arCoefficient = dArray[n2];
                factor -= arCoefficient;
                ++n2;
            }
            MethodOfMomentsArimaFitterStrategy methodOfMomentsArimaFitterStrategy = MethodOfMomentsArimaFitterStrategy.this;
            methodOfMomentsArimaFitterStrategy.constant = methodOfMomentsArimaFitterStrategy.constant * factor;
        }
    }

    private final class IntegrationOrderPhase
    implements Phase {
        private IntegrationOrderPhase() {
        }

        @Override
        public void perform() {
            if (MethodOfMomentsArimaFitterStrategy.this.estimateIntegrationOrder) {
                this.fetchIntegrationOrderAndConstant();
            } else {
                this.fetchConstant();
            }
        }

        private void fetchIntegrationOrderAndConstant() {
            StationarityTest.Result result = StationarityTest.test(MethodOfMomentsArimaFitterStrategy.this.observations, null);
            while (!result.stationary && MethodOfMomentsArimaFitterStrategy.this.integrationOrder < 10) {
                MethodOfMomentsArimaFitterStrategy methodOfMomentsArimaFitterStrategy = MethodOfMomentsArimaFitterStrategy.this;
                methodOfMomentsArimaFitterStrategy.integrationOrder = methodOfMomentsArimaFitterStrategy.integrationOrder + 1;
                MethodOfMomentsArimaFitterStrategy.this.observations = DoubleUtils.differentiate(MethodOfMomentsArimaFitterStrategy.this.observations);
                result = StationarityTest.test(MethodOfMomentsArimaFitterStrategy.this.observations, result);
            }
            MethodOfMomentsArimaFitterStrategy.this.constant = result.mean;
        }

        private void fetchConstant() {
            MethodOfMomentsArimaFitterStrategy.this.constant = 0.0;
            double[] dArray = MethodOfMomentsArimaFitterStrategy.this.observations;
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double observation = dArray[n2];
                MethodOfMomentsArimaFitterStrategy methodOfMomentsArimaFitterStrategy = MethodOfMomentsArimaFitterStrategy.this;
                methodOfMomentsArimaFitterStrategy.constant = methodOfMomentsArimaFitterStrategy.constant + observation;
                ++n2;
            }
            MethodOfMomentsArimaFitterStrategy methodOfMomentsArimaFitterStrategy = MethodOfMomentsArimaFitterStrategy.this;
            methodOfMomentsArimaFitterStrategy.constant = methodOfMomentsArimaFitterStrategy.constant / (double)MethodOfMomentsArimaFitterStrategy.this.observations.length;
        }
    }

    private final class MaPhase
    implements Phase {
        private MaPhase() {
        }

        @Override
        public void perform() {
            if (MethodOfMomentsArimaFitterStrategy.this.maOrder > 0) {
                this.fetchMaCoefficients();
                this.fetchMaVariation();
            } else {
                this.fetchArVariation();
            }
        }

        private void fetchMaCoefficients() {
            double[] modifiedAcvf = this.getModifiedAcvf();
            double[] tau = this.getInitialTau(modifiedAcvf[0]);
            double[] f = this.getF(tau, modifiedAcvf);
            int iterationCount = 0;
            do {
                double[][] T = this.getT(tau);
                double[] h = this.getH(T, f);
                tau = this.getTau(tau, h);
                f = this.getF(tau, modifiedAcvf);
            } while (!((double)(++iterationCount) >= 100.0) && this.checkF(f));
            MethodOfMomentsArimaFitterStrategy.this.tau0 = tau[0];
            MethodOfMomentsArimaFitterStrategy.this.maCoefficients = this.getMaCoefficientEstimation(tau);
        }

        private double[] getModifiedAcvf() {
            if (MethodOfMomentsArimaFitterStrategy.this.arOrder == 0) {
                return MethodOfMomentsArimaFitterStrategy.this.acvf;
            }
            double[] modifiedAcvf = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder + 1];
            int i = 0;
            while (i <= MethodOfMomentsArimaFitterStrategy.this.maOrder) {
                modifiedAcvf[i] = this.getModifiedAcvf(i);
                ++i;
            }
            return modifiedAcvf;
        }

        private double getModifiedAcvf(int i) {
            double result = 0.0;
            int j = 0;
            while (j <= MethodOfMomentsArimaFitterStrategy.this.arOrder) {
                int k = 0;
                while (k <= MethodOfMomentsArimaFitterStrategy.this.arOrder) {
                    double ar1 = j == 0 ? -1.0 : MethodOfMomentsArimaFitterStrategy.this.arCoefficients[j - 1];
                    double ar2 = k == 0 ? -1.0 : MethodOfMomentsArimaFitterStrategy.this.arCoefficients[k - 1];
                    result += ar1 * ar2 * MethodOfMomentsArimaFitterStrategy.this.acvf[Math.abs(i + j - k)];
                    ++k;
                }
                ++j;
            }
            return result;
        }

        public double[] getInitialTau(double modifiedAcvf0) {
            double[] result = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder + 1];
            result[0] = Math.sqrt(modifiedAcvf0);
            return result;
        }

        private double[] getF(double[] tau, double[] modifiedAcvf) {
            double[] result = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder + 1];
            int i = 0;
            while (i <= MethodOfMomentsArimaFitterStrategy.this.maOrder) {
                result[i] = this.getF(tau, modifiedAcvf[i], i);
                ++i;
            }
            return result;
        }

        private double getF(double[] tau, double modifiedAcvfValue, int i) {
            double result = 0.0;
            int j = 0;
            while (j <= MethodOfMomentsArimaFitterStrategy.this.maOrder - i) {
                result += tau[j] * tau[i + j];
                ++j;
            }
            return result - modifiedAcvfValue;
        }

        private double[][] getT(double[] tau) {
            double[][] result = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder + 1][];
            int i = 0;
            while (i <= MethodOfMomentsArimaFitterStrategy.this.maOrder) {
                result[i] = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder + 1];
                int j = 0;
                while (j <= MethodOfMomentsArimaFitterStrategy.this.maOrder) {
                    double tau1 = j + i > MethodOfMomentsArimaFitterStrategy.this.maOrder ? 0.0 : tau[j + i];
                    double tau2 = j - i < 0 ? 0.0 : tau[j - i];
                    result[i][j] = tau1 + tau2;
                    ++j;
                }
                ++i;
            }
            return result;
        }

        private double[] getH(double[][] T, double[] f) {
            return DoubleUtils.solveSLE(T, f);
        }

        private double[] getTau(double[] tau, double[] h) {
            double[] result = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder + 1];
            int i = 0;
            while (i <= MethodOfMomentsArimaFitterStrategy.this.maOrder) {
                result[i] = tau[i] - h[i];
                ++i;
            }
            return result;
        }

        private boolean checkF(double[] f) {
            double[] dArray = f;
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                double fValue = dArray[n2];
                if (Math.abs(fValue) > 0.001) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private double[] getMaCoefficientEstimation(double[] tau) {
            double[] result = new double[MethodOfMomentsArimaFitterStrategy.this.maOrder];
            int i = 0;
            while (i < MethodOfMomentsArimaFitterStrategy.this.maOrder) {
                result[i] = -tau[i + 1] / tau[0];
                ++i;
            }
            return result;
        }

        private void fetchMaVariation() {
            MethodOfMomentsArimaFitterStrategy.this.variation = MethodOfMomentsArimaFitterStrategy.this.tau0 * MethodOfMomentsArimaFitterStrategy.this.tau0;
        }

        private void fetchArVariation() {
            MethodOfMomentsArimaFitterStrategy.this.variation = MethodOfMomentsArimaFitterStrategy.this.acvf[0];
            int i = 0;
            while (i < MethodOfMomentsArimaFitterStrategy.this.arCoefficients.length) {
                MethodOfMomentsArimaFitterStrategy methodOfMomentsArimaFitterStrategy = MethodOfMomentsArimaFitterStrategy.this;
                methodOfMomentsArimaFitterStrategy.variation = methodOfMomentsArimaFitterStrategy.variation - MethodOfMomentsArimaFitterStrategy.this.arCoefficients[i] * MethodOfMomentsArimaFitterStrategy.this.acvf[i + 1];
                ++i;
            }
        }
    }

    private static interface Phase {
        public void perform();
    }
}

