/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.espy.arima.ArimaFitter;
import org.espy.arima.ArimaFitterStrategy;
import org.espy.arima.ArimaProcess;
import org.espy.arima.DefaultArimaForecaster;
import org.espy.arima.DefaultArimaProcess;
import org.espy.arima.DoubleUtils;
import org.espy.arima.ForecastAccuracyRelativeMetric;

public class GeneticAlgorithmArimaFitterStrategy
implements ArimaFitterStrategy {
    private static final int CONTROL_OBSERVATION_COUNT = 5;
    private static final int MIN_LEARNING_OBSERVATION_COUNT = 5;
    private static final int MAX_INTEGRATION_ORDER = 2;
    private static final int MAX_AR_ORDER = 2;
    private static final int MAX_MA_ORDER = 2;
    private static final int ITERATION_LIMIT = 100;
    private static final int NON_SIGNIFICANT_IMPROVEMENT_LIMIT = 3;
    private static final double SIGNIFICANT_IMPROVEMENT_THRESHOLD = 0.001;
    private final double[] learningObservations;
    private final double[] controlObservations;
    private Population population;
    private Individual bestIndividual;
    private int nonSignificantImprovementCount;
    private int iterationCount;

    public GeneticAlgorithmArimaFitterStrategy(double[] observations) {
        int minObservationCount = 10;
        if (observations.length < minObservationCount) {
            throw new IllegalArgumentException("Observations count is too small (at least need " + minObservationCount + " observations)");
        }
        this.learningObservations = DoubleUtils.copyBegin(observations, observations.length - 5);
        this.controlObservations = DoubleUtils.copyEnd(observations, 5);
    }

    @Override
    public ArimaProcess fit() {
        this.fetchInitialPopulation();
        this.estimatePopulation();
        while (this.isNotFinishPopulation()) {
            this.fetchNextGeneration();
            this.estimatePopulation();
        }
        return this.getBestArimaProcess();
    }

    private void fetchInitialPopulation() {
        this.population = new Population();
        int d = 0;
        while (d <= 2) {
            int p = 0;
            while (p <= 2) {
                int q = 0;
                while (q <= 2) {
                    if (p != 0 || q != 0) {
                        ArimaProcess arimaProcess = ArimaFitter.fit(this.learningObservations, p, d, q);
                        Individual individual = new Individual(arimaProcess);
                        PopulationClass populationClass = new PopulationClass(individual);
                        this.population.addPopulationClass(populationClass);
                    }
                    ++q;
                }
                ++p;
            }
            ++d;
        }
        this.bestIndividual = this.population.getBestIndividual();
    }

    private void estimatePopulation() {
        this.population.estimate(this.learningObservations, this.controlObservations);
    }

    private boolean isNotFinishPopulation() {
        Individual individual = this.population.getBestIndividual();
        double difference = this.bestIndividual.getDifference(individual);
        this.bestIndividual = Individual.getBestIndividual(this.bestIndividual, individual);
        if (difference < 0.001) {
            ++this.nonSignificantImprovementCount;
        }
        if (this.nonSignificantImprovementCount >= 3) {
            return false;
        }
        return ++this.iterationCount < 100;
    }

    private void fetchNextGeneration() {
        this.population.produceNextGeneration();
    }

    private ArimaProcess getBestArimaProcess() {
        return this.bestIndividual.getArimaProcess();
    }

    private static final class Individual
    implements Comparable<Individual> {
        private final ArimaProcess arimaProcess;
        private double estimation;

        public Individual(ArimaProcess arimaProcess) {
            this.arimaProcess = arimaProcess;
        }

        public static Individual getBestIndividual(Individual individual1, Individual individual2) {
            double difference = individual1.getDifference(individual2);
            if (difference > 0.0 || difference == 0.0 && individual2.hasLessOrder(individual1)) {
                return individual2;
            }
            return individual1;
        }

        public double getDifference(Individual individual) {
            return this.estimation - individual.estimation;
        }

        public boolean hasLessOrder(Individual individual) {
            int difference = this.arimaProcess.getArOrder() - individual.arimaProcess.getArOrder();
            if (difference < 0) {
                return true;
            }
            if (difference > 0) {
                return false;
            }
            difference = this.arimaProcess.getMaOrder() - individual.arimaProcess.getMaOrder();
            if (difference < 0) {
                return true;
            }
            if (difference > 0) {
                return false;
            }
            difference = this.arimaProcess.getIntegrationOrder() - individual.arimaProcess.getIntegrationOrder();
            if (difference < 0) {
                return true;
            }
            if (difference > 0) {
                return false;
            }
            return false;
        }

        public ArimaProcess getArimaProcess() {
            return this.arimaProcess;
        }

        public void estimate(double[] learningObservations, double[] controlObservations) {
            DefaultArimaForecaster forecaster = new DefaultArimaForecaster(this.arimaProcess, learningObservations);
            double[] forecast = forecaster.next(5);
            this.estimation = ForecastAccuracyRelativeMetric.getValue(controlObservations, forecast);
        }

        public double getEstimation() {
            return this.estimation;
        }

        @Override
        public int compareTo(Individual individual) {
            return Double.compare(this.estimation, individual.estimation);
        }
    }

    private static final class Mutations {
        private static final Random RANDOM = new Random();
        private static final double[] DELTAS = new double[]{0.0, 0.01, 0.05, 0.1};
        private static final double[] FACTORS = new double[]{0.25, 0.5, 1.0, 2.0, 4.0};

        private Mutations() {
        }

        public static Individual mutateWeakly(Individual individual) {
            ArimaProcess oldArimaProcess = individual.getArimaProcess();
            DefaultArimaProcess newArimaProcess = new DefaultArimaProcess();
            newArimaProcess.setIntegrationOrder(oldArimaProcess.getIntegrationOrder());
            newArimaProcess.setArCoefficients(Mutations.mutateWeakly(oldArimaProcess.getArCoefficients()));
            newArimaProcess.setMaCoefficients(Mutations.mutateWeakly(oldArimaProcess.getMaCoefficients()));
            newArimaProcess.setVariation(oldArimaProcess.getVariation());
            newArimaProcess.setConstant(Mutations.mutateWeakly(oldArimaProcess.getConstant()));
            return new Individual(newArimaProcess);
        }

        private static double[] mutateWeakly(double[] array) {
            double[] result = new double[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = Mutations.mutateWeakly(array[i]);
                ++i;
            }
            return result;
        }

        private static double mutateWeakly(double value) {
            return value + Mutations.getRandomDelta();
        }

        private static double getRandomDelta() {
            return DELTAS[RANDOM.nextInt(DELTAS.length)];
        }

        public static Individual mutateStrongly(Individual individual) {
            ArimaProcess oldArimaProcess = individual.getArimaProcess();
            DefaultArimaProcess newArimaProcess = new DefaultArimaProcess();
            newArimaProcess.setIntegrationOrder(oldArimaProcess.getIntegrationOrder());
            newArimaProcess.setArCoefficients(Mutations.mutateStrongly(oldArimaProcess.getArCoefficients()));
            newArimaProcess.setMaCoefficients(Mutations.mutateStrongly(oldArimaProcess.getMaCoefficients()));
            newArimaProcess.setVariation(oldArimaProcess.getVariation());
            newArimaProcess.setConstant(Mutations.mutateStrongly(oldArimaProcess.getConstant()));
            return new Individual(newArimaProcess);
        }

        private static double[] mutateStrongly(double[] array) {
            double[] result = new double[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = Mutations.mutateStrongly(array[i]);
                ++i;
            }
            return result;
        }

        private static double mutateStrongly(double value) {
            double newValue = value * Mutations.getRandomFactor();
            return RANDOM.nextBoolean() ? newValue : -newValue;
        }

        private static double getRandomFactor() {
            return FACTORS[RANDOM.nextInt(FACTORS.length)];
        }
    }

    private static final class Population {
        private final List<PopulationClass> populationClasses = new ArrayList<PopulationClass>();

        private Population() {
        }

        public void addPopulationClass(PopulationClass populationClass) {
            this.populationClasses.add(populationClass);
        }

        public Individual getBestIndividual() {
            Individual result = this.populationClasses.get(0).getBestIndividual();
            int i = 1;
            while (i < this.populationClasses.size()) {
                result = Individual.getBestIndividual(result, this.populationClasses.get(i).getBestIndividual());
                ++i;
            }
            return result;
        }

        public void estimate(double[] learningObservations, double[] controlObservations) {
            for (PopulationClass populationClass : this.populationClasses) {
                populationClass.estimate(learningObservations, controlObservations);
            }
            Collections.sort(this.populationClasses);
        }

        public void produceNextGeneration() {
            int groupSize = this.populationClasses.size() / 3;
            int i = 0;
            while (i < groupSize) {
                this.populationClasses.get(i).produceBigGeneration();
                ++i;
            }
            i = groupSize;
            int limit = 2 * groupSize;
            while (i < limit) {
                this.populationClasses.get(i).produceMediumGeneration();
                ++i;
            }
            i = 2 * groupSize;
            while (i < this.populationClasses.size()) {
                this.populationClasses.get(i).produceSmallGeneration();
                ++i;
            }
        }
    }

    private static final class PopulationClass
    implements Comparable<PopulationClass> {
        private static final int BIG_GENERATION_SIZE = 20;
        private static final int MEDIUM_GENERATION_SIZE = 10;
        private static final int SMALL_GENERATION_SIZE = 5;
        private final Random random = new Random();
        private final List<Individual> individuals = new ArrayList<Individual>();
        private double estimate;

        public PopulationClass(Individual individual) {
            this.addIndividual(individual);
            int i = 1;
            while (i < 10) {
                this.addIndividual(Mutations.mutateWeakly(individual));
                ++i;
            }
            i = 10;
            while (i < 20) {
                this.addIndividual(Mutations.mutateStrongly(individual));
                ++i;
            }
        }

        public void addIndividual(Individual individual) {
            this.individuals.add(individual);
        }

        public Individual getBestIndividual() {
            return this.individuals.get(0);
        }

        public void estimate(double[] learningObservations, double[] controlObservations) {
            for (Individual individual : this.individuals) {
                individual.estimate(learningObservations, controlObservations);
            }
            Collections.sort(this.individuals);
            double[] estimations = new double[this.individuals.size()];
            int i = 0;
            while (i < this.individuals.size()) {
                estimations[i] = this.individuals.get(i).getEstimation();
                ++i;
            }
            this.estimate = ForecastAccuracyRelativeMetric.combineSorted(estimations);
        }

        @Override
        public int compareTo(PopulationClass populationClass) {
            return Double.compare(this.estimate, populationClass.estimate);
        }

        public void produceBigGeneration() {
            this.produceGeneration(20, 10, 5);
        }

        public void produceGeneration(int generationSize, int selectionLimit, int weakMutationLimit) {
            ArrayList<Individual> nextGeneration = new ArrayList<Individual>(generationSize);
            this.performSelection(nextGeneration, selectionLimit);
            this.performWeakMutation(nextGeneration, weakMutationLimit);
            this.performStrongMutation(nextGeneration, generationSize);
            this.individuals.clear();
            this.individuals.addAll(nextGeneration);
        }

        private void performSelection(List<Individual> nextGeneration, int limit) {
            int newLimit;
            int level = 0;
            int oldLimit = limit;
            do {
                int size;
                if ((size = oldLimit - (newLimit = oldLimit / 2)) >= this.individuals.size()) {
                    size = this.individuals.size() - 1;
                }
                int i = 0;
                while (i < size) {
                    nextGeneration.add(Selectors.performSelection(this.individuals.get(level), this.individuals.get(level + i + 1)));
                    ++i;
                }
                ++level;
                oldLimit = newLimit;
            } while (newLimit > 0);
        }

        private void performWeakMutation(List<Individual> nextGeneration, int limit) {
            int size = limit > this.individuals.size() ? this.individuals.size() : limit;
            int i = 0;
            while (i < size) {
                nextGeneration.add(Mutations.mutateWeakly(this.individuals.get(i)));
                ++i;
            }
        }

        private void performStrongMutation(List<Individual> nextGeneration, int limit) {
            int i = nextGeneration.size();
            while (i < limit) {
                nextGeneration.add(Mutations.mutateStrongly(this.getRandomIndividual()));
                ++i;
            }
        }

        private Individual getRandomIndividual() {
            return this.individuals.get(this.random.nextInt(this.individuals.size()));
        }

        public void produceMediumGeneration() {
            this.produceGeneration(10, 4, 4);
        }

        public void produceSmallGeneration() {
            this.produceGeneration(5, 1, 2);
        }
    }

    private static final class Selectors {
        private Selectors() {
        }

        public static Individual performSelection(Individual individual1, Individual individual2) {
            ArimaProcess arimaProcess1 = individual1.getArimaProcess();
            ArimaProcess arimaProcess2 = individual2.getArimaProcess();
            DefaultArimaProcess arimaProcess = new DefaultArimaProcess();
            arimaProcess.setIntegrationOrder(arimaProcess1.getIntegrationOrder());
            arimaProcess.setArCoefficients(DoubleUtils.getMean(arimaProcess1.getArCoefficients(), arimaProcess2.getArCoefficients()));
            arimaProcess.setMaCoefficients(DoubleUtils.getMean(arimaProcess1.getMaCoefficients(), arimaProcess2.getMaCoefficients()));
            arimaProcess.setVariation(DoubleUtils.getMean(arimaProcess1.getVariation(), arimaProcess2.getVariation()));
            arimaProcess.setConstant(DoubleUtils.getMean(arimaProcess1.getConstant(), arimaProcess2.getConstant()));
            return new Individual(arimaProcess);
        }
    }
}

