/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import java.util.Arrays;
import org.espy.arima.DoubleUtils;

public class ForecastAccuracyRelativeMetric {
    private ForecastAccuracyRelativeMetric() {
    }

    public static double getValue(double[] observations, double[] forecast) {
        int observationLength = observations.length;
        int forecastLength = forecast.length;
        double[] deltas = new double[forecastLength];
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = 0;
        int j = observationLength - forecastLength;
        while (i < forecastLength) {
            double observation = observations[j];
            if (min > observation) {
                min = observation;
            }
            if (max < observation) {
                max = observation;
            }
            double forecastValue = forecast[i];
            deltas[i] = Math.abs(observation - forecastValue);
            ++i;
            ++j;
        }
        i = observationLength - forecastLength - 1;
        while (i >= 0) {
            double observation = observations[i];
            if (min > observation) {
                min = observation;
            }
            if (max < observation) {
                max = observation;
            }
            --i;
        }
        Arrays.sort(deltas);
        double denominator = max - min + deltas[forecastLength - 1];
        if (denominator == 0.0) {
            return 0.0;
        }
        int i2 = 0;
        while (i2 < forecastLength) {
            int n = i2++;
            deltas[n] = deltas[n] / denominator;
        }
        double meanDelta = DoubleUtils.getMean(deltas);
        double medianDelta = deltas[forecastLength / 2];
        double maxDelta = deltas[forecastLength - 1];
        return (4.0 * meanDelta + 5.0 * medianDelta + 3.0 * maxDelta) / 12.0;
    }

    public static double combine(double[] metrics) {
        Arrays.sort(metrics);
        return ForecastAccuracyRelativeMetric.combineSorted(metrics);
    }

    public static double combineSorted(double[] metrics) {
        double mean = DoubleUtils.getMean(metrics);
        double median = metrics[metrics.length / 2];
        double max = metrics[metrics.length - 1];
        return (4.0 * mean + 5.0 * median + 3.0 * max) / 12.0;
    }
}

