/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.espy.arima.ArimaProcess;
import org.espy.arima.ArimaProcessRealization;
import org.espy.arima.ArmaFormula;
import org.espy.arima.DifferentiatedObservationWindow;
import org.espy.arima.ObservationErrorWindow;

public class DefaultArimaProcessRealization
implements ArimaProcessRealization {
    private ArimaProcess arimaProcess;
    private DifferentiatedObservationWindow differentiatedObservationWindow;
    private ObservationErrorWindow observationErrorWindow;
    private ArmaFormula armaFormula;

    public DefaultArimaProcessRealization(ArimaProcess arimaProcess) {
        this(arimaProcess, ThreadLocalRandom.current());
    }

    public DefaultArimaProcessRealization(ArimaProcess arimaProcess, Random random) {
        this.arimaProcess = arimaProcess;
        this.differentiatedObservationWindow = new DifferentiatedObservationWindow(arimaProcess.getIntegrationOrder(), arimaProcess.getArOrder());
        this.observationErrorWindow = new ObservationErrorWindow(arimaProcess.getMaOrder());
        this.armaFormula = new ArmaFormula(random);
        this.armaFormula.setArCoefficients(arimaProcess.getArCoefficients());
        this.armaFormula.setMaCoefficients(arimaProcess.getMaCoefficients());
        this.armaFormula.setExpectation(arimaProcess.getExpectation());
        this.armaFormula.setStandardDeviation(Math.sqrt(arimaProcess.getVariation()));
        this.armaFormula.setConstant(arimaProcess.getConstant());
    }

    @Override
    public double[] getArCoefficients() {
        return this.arimaProcess.getArCoefficients();
    }

    @Override
    public double[] getMaCoefficients() {
        return this.arimaProcess.getMaCoefficients();
    }

    @Override
    public double getExpectation() {
        return this.arimaProcess.getExpectation();
    }

    @Override
    public double getVariation() {
        return this.arimaProcess.getVariation();
    }

    @Override
    public double getConstant() {
        return this.arimaProcess.getConstant();
    }

    @Override
    public int getArOrder() {
        return this.arimaProcess.getArOrder();
    }

    @Override
    public int getIntegrationOrder() {
        return this.arimaProcess.getIntegrationOrder();
    }

    @Override
    public int getMaOrder() {
        return this.arimaProcess.getMaOrder();
    }

    @Override
    public double[] next(int size) {
        double[] result = new double[size];
        int i = 0;
        while (i < size) {
            result[i] = this.next();
            ++i;
        }
        return result;
    }

    @Override
    public double next() {
        double[] arArguments = this.differentiatedObservationWindow.getDifferentiatedObservations();
        double[] maArguments = this.observationErrorWindow.getObservationErrors();
        ArmaFormula.Result result = this.armaFormula.evaluate(arArguments, maArguments);
        this.observationErrorWindow.pushObservationError(result.observationError);
        return this.differentiatedObservationWindow.pushDifferentiatedObservation(result.observation);
    }

    public String toString() {
        return "ArimaProcessRealization{arimaProcess=" + this.arimaProcess + '}';
    }
}

