/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.url.UrlFileProvider;
import org.renjin.eval.vfs.FastJarFileProvider;
import org.renjin.util.ClasspathFileProvider;

public class FileSystemUtils {
    public static String homeDirectoryInCoreJar(FileSystemManager fileSystemManager) {
        try {
            String resourceName = "res:org/renjin/sexp/SEXP.class";
            FileObject fileObject = fileSystemManager.resolveFile(resourceName);
            if (!fileObject.exists()) {
                throw new IllegalStateException("Cannot locate resource '" + resourceName + "' in provided virtual file system, make sure that you are including a ResourceFileProvider with scheme res:");
            }
            return fileObject.getParent().getParent().getURL().toString();
        }
        catch (FileSystemException e) {
            throw new IllegalStateException("Failed to locate R.home: ", e);
        }
    }

    public static FileObject workingDirectory(FileSystemManager fileSystemManager) {
        try {
            return fileSystemManager.resolveFile(new File("").getAbsolutePath());
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not resolve current working directory", e);
        }
    }

    public static FileSystemManager getMinimalFileSystemManager(ClassLoader classLoader) throws FileSystemException {
        DefaultFileSystemManager fsm = new DefaultFileSystemManager();
        fsm.setReplicator((FileReplicator)new DefaultFileReplicator());
        fsm.setDefaultProvider((FileProvider)new UrlFileProvider());
        fsm.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        fsm.addProvider("jar", (FileProvider)new FastJarFileProvider());
        fsm.addProvider("res", (FileProvider)new ClasspathFileProvider(classLoader));
        fsm.init();
        return fsm;
    }
}

