/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.optimize;

import org.renjin.stats.internals.optimize.Blas_f77;
import org.renjin.stats.internals.optimize.UncminFunction;

class Uncmin {
    Uncmin() {
    }

    public static void optif9_f77(int n, double[] x, UncminFunction minclass, double[] typsiz, double fscale, Method method, boolean iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag) {
        if (fscale == 0.0) {
            fscale = 1.0;
        }
        if (fscale < 0.0) {
            fscale = -fscale;
        }
        double[] g = new double[n + 1];
        double[] p = new double[n + 1];
        double[] sx = new double[n + 1];
        double[] wrk0 = new double[n + 1];
        double[] wrk1 = new double[n + 1];
        double[] wrk2 = new double[n + 1];
        double[] wrk3 = new double[n + 1];
        Uncmin.optdrv_f77(n, x, minclass, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, xpls, fpls, gpls, itrmcd, a, udiag, g, p, sx, wrk0, wrk1, wrk2, wrk3);
        if (itrmcd[1] == 1 || itrmcd[1] == 2 || itrmcd[1] == 3 || itrmcd[1] == 4 || itrmcd[1] == 5) {
            // empty if block
        }
    }

    public static void bakslv_f77(int n, double[][] a, double[] x, double[] b) {
        int i = n;
        x[i] = b[i] / a[i][i];
        while (i > 1) {
            int ip1 = i--;
            double sum2 = 0.0;
            for (int j = ip1; j <= n; ++j) {
                sum2 += a[j][i] * x[j];
            }
            x[i] = (b[i] - sum2) / a[i][i];
        }
    }

    public static void chlhsn_f77(int n, double[][] a, double epsm, double[] sx, double[] udiag) {
        int im1;
        double amu;
        int i;
        int j;
        double[] addmax = new double[2];
        for (j = 1; j <= n; ++j) {
            for (i = j; i <= n; ++i) {
                double[] dArray = a[i];
                int n2 = j;
                dArray[n2] = dArray[n2] / (sx[i] * sx[j]);
            }
        }
        double tol = Math.sqrt(epsm);
        double diagmx = a[1][1];
        double diagmn = a[1][1];
        for (i = 2; i <= n; ++i) {
            if (a[i][i] < diagmn) {
                diagmn = a[i][i];
            }
            if (!(a[i][i] > diagmx)) continue;
            diagmx = a[i][i];
        }
        double posmax = Math.max(diagmx, 0.0);
        if (diagmn <= posmax * tol) {
            amu = tol * (posmax - diagmn) - diagmn;
            if (amu == 0.0) {
                double offmax = 0.0;
                for (i = 2; i <= n; ++i) {
                    im1 = i - 1;
                    for (j = 1; j <= im1; ++j) {
                        if (!(Math.abs(a[i][j]) > offmax)) continue;
                        offmax = Math.abs(a[i][j]);
                    }
                }
                amu = offmax;
                amu = amu == 0.0 ? 1.0 : (amu *= 1.0 + tol);
            }
            i = 1;
            while (i <= n) {
                double[] dArray = a[i];
                int n3 = i++;
                dArray[n3] = dArray[n3] + amu;
            }
            diagmx += amu;
        }
        for (j = 1; j <= n; ++j) {
            udiag[j] = a[j][j];
            for (i = j + 1; i <= n; ++i) {
                a[j][i] = a[i][j];
            }
        }
        Uncmin.choldc_f77(n, a, diagmx, tol, addmax);
        if (addmax[1] > 0.0) {
            for (j = 1; j <= n; ++j) {
                a[j][j] = udiag[j];
                for (i = j + 1; i <= n; ++i) {
                    a[i][j] = a[j][i];
                }
            }
            double evmin = 0.0;
            double evmax = a[1][1];
            for (i = 1; i <= n; ++i) {
                double offrow = 0.0;
                im1 = i - 1;
                for (j = 1; j <= im1; ++j) {
                    offrow += Math.abs(a[i][j]);
                }
                for (j = i + 1; j <= n; ++j) {
                    offrow += Math.abs(a[j][i]);
                }
                evmin = Math.min(evmin, a[i][i] - offrow);
                evmax = Math.max(evmax, a[i][i] + offrow);
            }
            double sdd = tol * (evmax - evmin) - evmin;
            amu = Math.min(sdd, addmax[1]);
            for (i = 1; i <= n; ++i) {
                double[] dArray = a[i];
                int n4 = i;
                dArray[n4] = dArray[n4] + amu;
                udiag[i] = a[i][i];
            }
            Uncmin.choldc_f77(n, a, 0.0, tol, addmax);
        }
        for (j = 1; j <= n; ++j) {
            for (i = j; i <= n; ++i) {
                double[] dArray = a[i];
                int n5 = j;
                dArray[n5] = dArray[n5] * sx[i];
            }
            int jm1 = j - 1;
            for (i = 1; i <= jm1; ++i) {
                double[] dArray = a[i];
                int n6 = j;
                dArray[n6] = dArray[n6] * (sx[i] * sx[j]);
            }
            int n7 = j;
            udiag[n7] = udiag[n7] * (sx[j] * sx[j]);
        }
    }

    public static void choldc_f77(int n, double[][] a, double diagmx, double tol, double[] addmax) {
        addmax[1] = 0.0;
        double aminl = Math.sqrt(diagmx * tol);
        double amnlsq = aminl * aminl;
        for (int j = 1; j <= n; ++j) {
            int i;
            int k;
            double sum2 = 0.0;
            int jm1 = j - 1;
            int jp1 = j + 1;
            for (k = 1; k <= jm1; ++k) {
                sum2 += a[j][k] * a[j][k];
            }
            double temp = a[j][j] - sum2;
            if (temp >= amnlsq) {
                a[j][j] = Math.sqrt(temp);
            } else {
                double offmax = 0.0;
                for (i = jp1; i <= n; ++i) {
                    if (!(Math.abs(a[i][j]) > offmax)) continue;
                    offmax = Math.abs(a[i][j]);
                }
                if (offmax <= amnlsq) {
                    offmax = amnlsq;
                }
                a[j][j] = Math.sqrt(offmax);
                addmax[1] = Math.max(addmax[1], offmax - temp);
            }
            for (i = jp1; i <= n; ++i) {
                sum2 = 0.0;
                for (k = 1; k <= jm1; ++k) {
                    sum2 += a[i][k] * a[j][k];
                }
                a[i][j] = (a[i][j] - sum2) / a[j][j];
            }
        }
    }

    public static void dogdrv_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] p, double[] xpls, double[] fpls, UncminFunction minclass, double[] sx, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, boolean[] mxtake, double[] sc, double[] wrk1, double[] wrk2, double[] wrk3) {
        double[] fplsp = new double[2];
        double[] cln = new double[2];
        double[] eta = new double[2];
        boolean[] fstdog = new boolean[2];
        boolean[] nwtake = new boolean[2];
        iretcd[1] = 4;
        fstdog[1] = true;
        double tmp = 0.0;
        for (int i = 1; i <= n; ++i) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
        }
        double rnwtln = Math.sqrt(tmp);
        while (iretcd[1] > 1) {
            Uncmin.dogstp_f77(n, g, a, p, sx, rnwtln, dlt, nwtake, fstdog, wrk1, wrk2, cln, eta, sc, stepmx);
            Uncmin.tregup_f77(n, x, f, g, a, minclass, sc, sx, nwtake, stepmx, steptl, dlt, iretcd, wrk3, fplsp, xpls, fpls, mxtake, 2, wrk1);
        }
    }

    public static void dogstp_f77(int n, double[] g, double[][] a, double[] p, double[] sx, double rnwtln, double[] dlt, boolean[] nwtake, boolean[] fstdog, double[] ssd, double[] v, double[] cln, double[] eta, double[] sc, double[] stepmx) {
        if (rnwtln <= dlt[1]) {
            nwtake[1] = true;
            for (int i = 1; i <= n; ++i) {
                sc[i] = p[i];
            }
            dlt[1] = rnwtln;
        } else {
            int i;
            nwtake[1] = false;
            if (fstdog[1]) {
                fstdog[1] = false;
                double alpha = 0.0;
                for (i = 1; i <= n; ++i) {
                    alpha += g[i] * g[i] / (sx[i] * sx[i]);
                }
                double beta2 = 0.0;
                for (i = 1; i <= n; ++i) {
                    double tmp = 0.0;
                    for (int j = i; j <= n; ++j) {
                        tmp += a[j][i] * g[j] / (sx[j] * sx[j]);
                    }
                    beta2 += tmp * tmp;
                }
                for (i = 1; i <= n; ++i) {
                    ssd[i] = -(alpha / beta2) * g[i] / sx[i];
                }
                cln[1] = alpha * Math.sqrt(alpha) / beta2;
                eta[1] = 0.2 + 0.8 * alpha * alpha / (-beta2 * Blas_f77.ddot_f77(n, g, 1, p, 1));
                for (i = 1; i <= n; ++i) {
                    v[i] = eta[1] * sx[i] * p[i] - ssd[i];
                }
                if (dlt[1] == -1.0) {
                    dlt[1] = Math.min(cln[1], stepmx[1]);
                }
            }
            if (eta[1] * rnwtln <= dlt[1]) {
                for (i = 1; i <= n; ++i) {
                    sc[i] = dlt[1] / rnwtln * p[i];
                }
            } else if (cln[1] >= dlt[1]) {
                for (i = 1; i <= n; ++i) {
                    sc[i] = dlt[1] / cln[1] * ssd[i] / sx[i];
                }
            } else {
                double dot1 = Blas_f77.ddot_f77(n, v, 1, ssd, 1);
                double dot2 = Blas_f77.ddot_f77(n, v, 1, v, 1);
                double alam = (-dot1 + Math.sqrt(dot1 * dot1 - dot2 * (cln[1] * cln[1] - dlt[1] * dlt[1]))) / dot2;
                for (i = 1; i <= n; ++i) {
                    sc[i] = (ssd[i] + alam * v[i]) / sx[i];
                }
            }
        }
    }

    public static void forslv_f77(int n, double[][] a, double[] x, double[] b) {
        x[1] = b[1] / a[1][1];
        for (int i = 2; i <= n; ++i) {
            double sum2 = 0.0;
            int im1 = i - 1;
            for (int j = 1; j <= im1; ++j) {
                sum2 += a[i][j] * x[j];
            }
            x[i] = (b[i] - sum2) / a[i][i];
        }
    }

    public static void fstocd_f77(int n, double[] x, UncminFunction minclass, double[] sx, double rnoise, double[] g) {
        double xmult = Math.pow(rnoise, 0.3333333333333333);
        for (int i = 1; i <= n; ++i) {
            double stepi = xmult * Math.max(Math.abs(x[i]), 1.0 / sx[i]);
            double xtempi = x[i];
            x[i] = xtempi + stepi;
            double fplus = minclass.apply(x);
            x[i] = xtempi - stepi;
            double fminus = minclass.apply(x);
            x[i] = xtempi;
            g[i] = (fplus - fminus) / (2.0 * stepi);
        }
    }

    public static void fstofd_f77(int n, double[] xpls, UncminFunction minclass, double[] fpls, double[][] a, double[] sx, double rnoise, double[] fhat) {
        int i;
        int j;
        double xmult = Math.sqrt(rnoise);
        for (j = 1; j <= n; ++j) {
            double stepsz = xmult * Math.max(Math.abs(xpls[j]), 1.0 / sx[j]);
            double xtmpj = xpls[j];
            xpls[j] = xtmpj + stepsz;
            minclass.applyGradient(xpls, fhat);
            xpls[j] = xtmpj;
            for (i = 1; i <= n; ++i) {
                a[i][j] = (fhat[i] - fpls[i]) / stepsz;
            }
        }
        int nm1 = n - 1;
        for (j = 1; j <= nm1; ++j) {
            for (i = j + 1; i <= n; ++i) {
                a[i][j] = (a[i][j] + a[j][i]) / 2.0;
            }
        }
    }

    public static void fstofd_f77(int n, double[] xpls, UncminFunction minclass, double[] fpls, double[] g, double[] sx, double rnoise) {
        double xmult = Math.sqrt(rnoise);
        for (int j = 1; j <= n; ++j) {
            double stepsz = xmult * Math.max(Math.abs(xpls[j]), 1.0 / sx[j]);
            double xtmpj = xpls[j];
            xpls[j] = xtmpj + stepsz;
            double fhat = minclass.apply(xpls);
            xpls[j] = xtmpj;
            g[j] = (fhat - fpls[1]) / stepsz;
        }
    }

    public static void grdchk_f77(int n, double[] x, UncminFunction minclass, double[] f, double[] g, double[] typsiz, double[] sx, double fscale, double rnf, double analtl, double[] gest) {
        int i;
        Uncmin.fstofd_f77(n, x, minclass, f, gest, sx, rnf);
        boolean ker = false;
        for (i = 1; i <= n; ++i) {
            double gs = Math.max(Math.abs(f[1]), fscale) / Math.max(Math.abs(x[i]), typsiz[i]);
            if (!(Math.abs(g[i] - gest[i]) > Math.max(Math.abs(g[i]), gs) * analtl)) continue;
            ker = true;
        }
        if (!ker) {
            return;
        }
        StringBuilder errmsg = new StringBuilder();
        errmsg.append("\nThere appears to be an error in the coding");
        errmsg.append(" of the gradient method.\n\n\n");
        errmsg.append("Component   Analytic   Finite Difference\n\n");
        for (i = 1; i <= n; ++i) {
            errmsg.append(i + "  " + g[i] + "  " + gest[i]);
        }
        throw new IllegalArgumentException(errmsg.toString());
    }

    public static void heschk_f77(int n, double[] x, UncminFunction minclass, double[] f, double[] g, double[][] a, double[] typsiz, double[] sx, double rnf, double analtl, int[] iagflg, double[] udiag, double[] wrk1, double[] wrk2) {
        int i;
        int j;
        if (iagflg[1] == 1) {
            Uncmin.fstofd_f77(n, x, minclass, g, a, sx, rnf, wrk1);
        }
        if (iagflg[1] != 1) {
            Uncmin.sndofd_f77(n, x, minclass, f, a, sx, rnf, wrk1, wrk2);
        }
        boolean ker = false;
        for (j = 1; j <= n; ++j) {
            udiag[j] = a[j][j];
            for (i = j + 1; i <= n; ++i) {
                a[j][i] = a[i][j];
            }
        }
        minclass.applyHessian(x, a);
        for (j = 1; j <= n; ++j) {
            double hs = Math.max(Math.abs(g[j]), 1.0) / Math.max(Math.abs(x[j]), typsiz[j]);
            if (Math.abs(a[j][j] - udiag[j]) > Math.max(Math.abs(udiag[j]), hs) * analtl) {
                ker = true;
            }
            for (i = j + 1; i <= n; ++i) {
                if (!(Math.abs(a[i][j] - a[j][i]) > Math.max(Math.abs(a[i][j]), hs) * analtl)) continue;
                ker = true;
            }
        }
        if (!ker) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\nThere appears to be an error in the coding");
        sb.append(" of the Hessian method.\n\n\n");
        sb.append("Row   Column   Analytic   Finite Difference\n\n");
        for (i = 1; i <= n; ++i) {
            for (j = 1; j < i; ++j) {
                sb.append(i + "  " + j + "  " + a[i][j] + "  " + a[j][i] + "\n");
            }
            sb.append(i + "  " + i + "  " + a[i][i] + "  " + udiag[i] + "\n");
        }
        throw new IllegalArgumentException(sb.toString());
    }

    public static void hookdr_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] udiag, double[] p, double[] xpls, double[] fpls, UncminFunction minclass, double[] sx, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, boolean[] mxtake, double[] amu, double[] dltp, double[] phi, double[] phip0, double[] sc, double[] xplsp, double[] wrk0, double epsm, int[] itncnt) {
        int i;
        boolean[] fstime = new boolean[2];
        boolean[] nwtake = new boolean[2];
        double[] fplsp = new double[2];
        iretcd[1] = 4;
        fstime[1] = true;
        double tmp = 0.0;
        for (i = 1; i <= n; ++i) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
        }
        double rnwtln = Math.sqrt(tmp);
        if (itncnt[1] == 1) {
            amu[1] = 0.0;
            if (dlt[1] == -1.0) {
                double alpha = 0.0;
                for (i = 1; i <= n; ++i) {
                    alpha += g[i] * g[i] / (sx[i] * sx[i]);
                }
                double beta2 = 0.0;
                for (i = 1; i <= n; ++i) {
                    tmp = 0.0;
                    for (int j = i; j <= n; ++j) {
                        tmp += a[j][i] * g[j] / (sx[j] * sx[j]);
                    }
                    beta2 += tmp * tmp;
                }
                dlt[1] = alpha * Math.sqrt(alpha) / beta2;
                dlt[1] = Math.min(dlt[1], stepmx[1]);
            }
        }
        while (iretcd[1] > 1) {
            Uncmin.hookst_f77(n, g, a, udiag, p, sx, rnwtln, dlt, amu, dltp, phi, phip0, fstime, sc, nwtake, wrk0, epsm);
            dltp[1] = dlt[1];
            Uncmin.tregup_f77(n, x, f, g, a, minclass, sc, sx, nwtake, stepmx, steptl, dlt, iretcd, xplsp, fplsp, xpls, fpls, mxtake, 3, udiag);
        }
    }

    public static void hookst_f77(int n, double[] g, double[][] a, double[] udiag, double[] p, double[] sx, double rnwtln, double[] dlt, double[] amu, double[] dltp, double[] phi, double[] phip0, boolean[] fstime, double[] sc, boolean[] nwtake, double[] wrk0, double epsm) {
        int i;
        double[] addmax = new double[2];
        double phip = 0.0;
        double hi = 1.5;
        double alo = 0.75;
        if (rnwtln <= hi * dlt[1]) {
            nwtake[1] = true;
            for (int i2 = 1; i2 <= n; ++i2) {
                sc[i2] = p[i2];
            }
            dlt[1] = Math.min(dlt[1], rnwtln);
            amu[1] = 0.0;
            return;
        }
        nwtake[1] = false;
        if (amu[1] > 0.0) {
            amu[1] = amu[1] - (phi[1] + dltp[1]) * (dltp[1] - dlt[1] + phi[1]) / (dlt[1] * phip);
        }
        phi[1] = rnwtln - dlt[1];
        if (fstime[1]) {
            for (i = 1; i <= n; ++i) {
                wrk0[i] = sx[i] * sx[i] * p[i];
            }
            Uncmin.forslv_f77(n, a, wrk0, wrk0);
            phip0[1] = -Math.pow(Blas_f77.dnrm2_f77(n, wrk0, 1), 2.0) / rnwtln;
            fstime[1] = false;
        }
        phip = phip0[1];
        double amulo = -phi[1] / phip;
        double amuup = 0.0;
        for (i = 1; i <= n; ++i) {
            amuup += g[i] * g[i] / (sx[i] * sx[i]);
        }
        amuup = Math.sqrt(amuup) / dlt[1];
        boolean done = false;
        while (!done) {
            if (amu[1] < amulo || amu[1] > amuup) {
                amu[1] = Math.max(Math.sqrt(amulo * amuup), amuup * 0.001);
            }
            for (int j = 1; j <= n; ++j) {
                a[j][j] = udiag[j] + amu[1] * sx[j] * sx[j];
                for (i = j + 1; i <= n; ++i) {
                    a[i][j] = a[j][i];
                }
            }
            Uncmin.choldc_f77(n, a, 0.0, Math.sqrt(epsm), addmax);
            for (i = 1; i <= n; ++i) {
                wrk0[i] = -g[i];
            }
            Uncmin.lltslv_f77(n, a, sc, wrk0);
            double stepln = 0.0;
            for (i = 1; i <= n; ++i) {
                stepln += sx[i] * sx[i] * sc[i] * sc[i];
            }
            stepln = Math.sqrt(stepln);
            phi[1] = stepln - dlt[1];
            for (i = 1; i <= n; ++i) {
                wrk0[i] = sx[i] * sx[i] * sc[i];
            }
            Uncmin.forslv_f77(n, a, wrk0, wrk0);
            phip = -Math.pow(Blas_f77.dnrm2_f77(n, wrk0, 1), 2.0) / stepln;
            if (alo * dlt[1] <= stepln && stepln <= hi * dlt[1] || amuup - amulo <= 0.0) {
                done = true;
                continue;
            }
            amulo = Math.max(amulo, amu[1] - phi[1] / phip);
            if (phi[1] < 0.0) {
                amuup = Math.min(amuup, amu[1]);
            }
            amu[1] = amu[1] - stepln * phi[1] / (dlt[1] * phip);
        }
    }

    public static void hsnint_f77(int n, double[][] a, double[] sx, Method method) {
        for (int j = 1; j <= n; ++j) {
            a[j][j] = method == Method.MORE_HEBDON ? sx[j] * sx[j] : sx[j];
            for (int i = j + 1; i <= n; ++i) {
                a[i][j] = 0.0;
            }
        }
    }

    public static void lltslv_f77(int n, double[][] a, double[] x, double[] b) {
        Uncmin.forslv_f77(n, a, x, b);
        Uncmin.bakslv_f77(n, a, x, x);
    }

    public static void lnsrch_f77(int n, double[] x, double[] f, double[] g, double[] p, double[] xpls, double[] fpls, UncminFunction minclass, boolean[] mxtake, int[] iretcd, double[] stepmx, double[] steptl, double[] sx) {
        int i;
        double pfpls = 0.0;
        double plmbda = 0.0;
        mxtake[1] = false;
        iretcd[1] = 2;
        double tmp = 0.0;
        for (i = 1; i <= n; ++i) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
        }
        double sln = Math.sqrt(tmp);
        if (sln > stepmx[1]) {
            double scl = stepmx[1] / sln;
            Uncmin.sclmul_f77(n, scl, p, p);
            sln = stepmx[1];
        }
        double slp = Blas_f77.ddot_f77(n, g, 1, p, 1);
        double rln = 0.0;
        for (i = 1; i <= n; ++i) {
            rln = Math.max(rln, Math.abs(p[i]) / Math.max(Math.abs(x[i]), 1.0 / sx[i]));
        }
        double rmnlmb = steptl[1] / rln;
        double almbda = 1.0;
        while (iretcd[1] >= 2) {
            double tlmbda;
            for (i = 1; i <= n; ++i) {
                xpls[i] = x[i] + almbda * p[i];
            }
            fpls[1] = minclass.apply(xpls);
            if (fpls[1] <= f[1] + slp * 1.0E-4 * almbda) {
                iretcd[1] = 0;
                if (almbda != 1.0 || !(sln > 0.99 * stepmx[1])) continue;
                mxtake[1] = true;
                continue;
            }
            if (almbda < rmnlmb) {
                iretcd[1] = 1;
                continue;
            }
            if (almbda == 1.0) {
                tlmbda = -slp / (2.0 * (fpls[1] - f[1] - slp));
            } else {
                double t3 = 1.0 / (almbda - plmbda);
                double t2 = pfpls - f[1] - plmbda * slp;
                double t1 = fpls[1] - f[1] - almbda * slp;
                double b = t3 * (t2 * almbda / (plmbda * plmbda) - t1 * plmbda / (almbda * almbda));
                double a = t3 * (t1 / (almbda * almbda) - t2 / (plmbda * plmbda));
                double disc = b * b - 3.0 * a * slp;
                tlmbda = disc > b * b ? (-b + Blas_f77.sign_f77(1.0, a) * Math.sqrt(disc)) / (3.0 * a) : (-b - Blas_f77.sign_f77(1.0, a) * Math.sqrt(disc)) / (3.0 * a);
                if (tlmbda > 0.5 * almbda) {
                    tlmbda = 0.5 * almbda;
                }
            }
            plmbda = almbda;
            pfpls = fpls[1];
            if (tlmbda < almbda / 10.0) {
                almbda *= 0.1;
                continue;
            }
            almbda = tlmbda;
        }
    }

    public static void mvmltl_f77(int n, double[][] a, double[] x, double[] y) {
        for (int i = 1; i <= n; ++i) {
            double sum2 = 0.0;
            for (int j = 1; j <= i; ++j) {
                sum2 += a[i][j] * x[j];
            }
            y[i] = sum2;
        }
    }

    public static void mvmlts_f77(int n, double[][] a, double[] x, double[] y) {
        for (int i = 1; i <= n; ++i) {
            int j;
            double sum2 = 0.0;
            for (j = 1; j <= i; ++j) {
                sum2 += a[i][j] * x[j];
            }
            for (j = i + 1; j <= n; ++j) {
                sum2 += a[j][i] * x[j];
            }
            y[i] = sum2;
        }
    }

    public static void mvmltu_f77(int n, double[][] a, double[] x, double[] y) {
        for (int i = 1; i <= n; ++i) {
            double sum2 = 0.0;
            for (int j = i; j <= n; ++j) {
                sum2 += a[j][i] * x[j];
            }
            y[i] = sum2;
        }
    }

    public static void optchk_f77(int n, double[] x, double[] typsiz, double[] sx, double fscale, double[] gradtl, int[] itnlim, int[] ndigit, double epsm, double[] dlt, int[] iagflg, int[] iahflg, double[] stepmx, int[] msg) {
        int i;
        if (iagflg[1] != 1) {
            iagflg[1] = 0;
        }
        if (iahflg[1] != 1) {
            iahflg[1] = 0;
        }
        if (msg[1] / 2 % 2 == 1 && iagflg[1] == 0) {
            throw new IllegalArgumentException("User requests that analytic gradient be accepted as properly coded, msg = " + msg + ", but an analytic gradient is not supplied, iagflag = " + iagflg[1]);
        }
        if (msg[1] / 4 % 2 == 1 && iahflg[1] == 0) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal dimension, n = " + n);
        }
        if (n == 1 && msg[1] % 2 == 0) {
            System.out.print("\n\nOPTCHK   !!!WARNING!!!  This class is ");
            System.out.print("inefficient for problems of size 1.\n");
            System.out.print("OPTCHK   You might want to try Fmin instead.\n\n");
            msg[1] = -2;
        }
        for (i = 1; i <= n; ++i) {
            if (typsiz[i] == 0.0) {
                typsiz[i] = 1.0;
            }
            if (typsiz[i] < 0.0) {
                typsiz[i] = -typsiz[i];
            }
            sx[i] = 1.0 / typsiz[i];
        }
        if (stepmx[1] <= 0.0) {
            double stpsiz = 0.0;
            for (i = 1; i <= n; ++i) {
                stpsiz += x[i] * x[i] * sx[i] * sx[i];
            }
            stpsiz = Math.sqrt(stpsiz);
            stepmx[1] = Math.max(1000.0 * stpsiz, 1000.0);
        }
        if (gradtl[1] < 0.0) {
            throw new IllegalArgumentException("Illegal tolerance, gradtl = " + gradtl[1]);
        }
        if (itnlim[1] < 0) {
            throw new IllegalArgumentException("Illegal iteration limit, itnlim = " + itnlim[1]);
        }
        if (ndigit[1] == 0) {
            throw new IllegalArgumentException("Minimization function has no good digits, ndigit = " + ndigit);
        }
        if (ndigit[1] < 0) {
            ndigit[1] = (int)(-Math.log(epsm) / Math.log(10.0));
        }
        if (dlt[1] <= 0.0) {
            dlt[1] = -1.0;
        }
        if (dlt[1] > stepmx[1]) {
            dlt[1] = stepmx[1];
        }
    }

    public static void optdrv_f77(int n, double[] x, UncminFunction minclass, double[] typsiz, double fscale, Method method, boolean iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag, double[] g, double[] p, double[] sx, double[] wrk0, double[] wrk1, double[] wrk2, double[] wrk3) {
        int i;
        boolean[] noupdt = new boolean[2];
        boolean[] mxtake = new boolean[2];
        int[] icscmx = new int[2];
        int[] iretcd = new int[2];
        int[] itncnt = new int[2];
        double[] f = new double[2];
        double[] amu = new double[2];
        double[] dltp = new double[2];
        double[] phi = new double[2];
        double[] phip0 = new double[2];
        double phpsav = 0.0;
        double phisav = 0.0;
        double dlpsav = 0.0;
        double amusav = 0.0;
        double dltsav = 0.0;
        for (i = 1; i <= n; ++i) {
            p[i] = 0.0;
        }
        itncnt[1] = 0;
        iretcd[1] = -1;
        double epsm = 1.12E-16;
        Uncmin.optchk_f77(n, x, typsiz, sx, fscale, gradtl, itnlim, ndigit, epsm, dlt, iagflg, iahflg, stepmx, msg);
        double rnf = Math.max(Math.pow(10.0, -ndigit[1]), epsm);
        double analtl = Math.max(0.01, Math.sqrt(rnf));
        if (msg[1] / 8 % 2 != 1) {
            int j;
            int num5 = n / 5;
            int remain = n % 5;
            int ilow = -4;
            int ihigh = 0;
            for (i = 1; i <= num5; ++i) {
                ilow += 5;
                ihigh += 5;
                for (j = 1; j <= 5; ++j) {
                    System.out.print(typsiz[ilow + j - 1] + "  ");
                }
            }
            ihigh = (ilow += 5) + remain - 1;
            System.out.print(ilow + "--" + ihigh + "     ");
            for (j = 1; j <= remain; ++j) {
                System.out.print(typsiz[ilow + j - 1] + "  ");
            }
            System.out.print("\n");
            System.out.print("\n\nOPTDRV      Scaling vector for x\n\n");
            ilow = -4;
            ihigh = 0;
            for (i = 1; i <= num5; ++i) {
                System.out.print((ilow += 5) + "--" + (ihigh += 5) + "     ");
                for (j = 1; j <= 5; ++j) {
                    System.out.print(sx[ilow + j - 1] + "  ");
                }
                System.out.print("\n");
            }
            ihigh = (ilow += 5) + remain - 1;
            System.out.print(ilow + "--" + ihigh + "     ");
            for (j = 1; j <= remain; ++j) {
                System.out.print(sx[ilow + j - 1] + "  ");
            }
            System.out.print("\n");
            System.out.println("\n\nOPTDRV      Typical f = " + fscale);
            System.out.print("OPTDRV      Number of good digits in");
            System.out.println(" f_to_minimize = " + ndigit[1]);
            System.out.print("OPTDRV      Gradient flag");
            System.out.println(" = " + iagflg[1]);
            System.out.print("OPTDRV      Hessian flag");
            System.out.println(" = " + iahflg[1]);
            System.out.print("OPTDRV      Expensive function calculation flag");
            System.out.println(" = " + iexp);
            System.out.print("OPTDRV      Method to use");
            System.out.println(" = " + (Object)((Object)method));
            System.out.print("OPTDRV      Iteration limit");
            System.out.println(" = " + itnlim[1]);
            System.out.print("OPTDRV      Machine epsilon");
            System.out.println(" = " + epsm);
            System.out.print("OPTDRV      Maximum step size");
            System.out.println(" = " + stepmx[1]);
            System.out.print("OPTDRV      Step tolerance");
            System.out.println(" = " + steptl[1]);
            System.out.print("OPTDRV      Gradient tolerance");
            System.out.println(" = " + gradtl[1]);
            System.out.print("OPTDRV      Trust region radius");
            System.out.println(" = " + dlt[1]);
            System.out.print("OPTDRV      Relative noise in");
            System.out.println(" f_to_minimize = " + rnf);
            System.out.print("OPTDRV      Analytical fd tolerance");
            System.out.println(" = " + analtl);
        }
        f[1] = minclass.apply(x);
        if (iagflg[1] == 0) {
            Uncmin.fstofd_f77(n, x, minclass, f, g, sx, rnf);
        } else {
            minclass.applyGradient(x, g);
            if (msg[1] / 2 % 2 == 0) {
                Uncmin.grdchk_f77(n, x, minclass, f, g, typsiz, sx, fscale, rnf, analtl, wrk1);
            }
        }
        Uncmin.optstp_f77(n, x, f, g, wrk1, itncnt, icscmx, itrmcd, gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, msg);
        if (itrmcd[1] != 0) {
            fpls[1] = f[1];
            for (i = 1; i <= n; ++i) {
                xpls[i] = x[i];
                gpls[i] = g[i];
            }
        } else {
            if (iexp) {
                Uncmin.hsnint_f77(n, a, sx, method);
            } else if (iahflg[1] == 0) {
                if (iagflg[1] == 1) {
                    Uncmin.fstofd_f77(n, x, minclass, g, a, sx, rnf, wrk1);
                } else {
                    Uncmin.sndofd_f77(n, x, minclass, f, a, sx, rnf, wrk1, wrk2);
                }
            } else if (msg[1] / 4 % 2 == 1) {
                minclass.applyHessian(x, a);
            } else {
                Uncmin.heschk_f77(n, x, minclass, f, g, a, typsiz, sx, rnf, analtl, iagflg, udiag, wrk1, wrk2);
            }
            if (msg[1] / 8 % 2 == 0) {
                Uncmin.result_f77(n, x, f, g, a, p, itncnt, 1);
            }
            while (itrmcd[1] == 0) {
                itncnt[1] = itncnt[1] + 1;
                if (!iexp || method == Method.MORE_HEBDON) {
                    Uncmin.chlhsn_f77(n, a, epsm, sx, udiag);
                }
                for (i = 1; i <= n; ++i) {
                    wrk1[i] = -g[i];
                }
                Uncmin.lltslv_f77(n, a, p, wrk1);
                if (iagflg[1] == 0 && method != Method.LINE_SEARCH) {
                    dltsav = dlt[1];
                    if (method != Method.DOUBLE_DOGLEG) {
                        amusav = amu[1];
                        dlpsav = dltp[1];
                        phisav = phi[1];
                        phpsav = phip0[1];
                    }
                }
                if (method == Method.LINE_SEARCH) {
                    Uncmin.lnsrch_f77(n, x, f, g, p, xpls, fpls, minclass, mxtake, iretcd, stepmx, steptl, sx);
                } else if (method == Method.DOUBLE_DOGLEG) {
                    Uncmin.dogdrv_f77(n, x, f, g, a, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, wrk0, wrk1, wrk2, wrk3);
                } else {
                    Uncmin.hookdr_f77(n, x, f, g, a, udiag, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, amu, dltp, phi, phip0, wrk0, wrk1, wrk2, epsm, itncnt);
                }
                if (iretcd[1] == 1 && iagflg[1] == 0) {
                    iagflg[1] = -1;
                    System.out.print("\nOPTDRV      Shift from forward to central");
                    System.out.print(" differences");
                    System.out.print("\nOPTDRV      in iteration " + itncnt[1]);
                    System.out.print("\n");
                    Uncmin.fstocd_f77(n, x, minclass, sx, rnf, g);
                    if (method == Method.LINE_SEARCH) {
                        for (i = 1; i <= n; ++i) {
                            wrk1[i] = -g[i];
                        }
                        Uncmin.lltslv_f77(n, a, p, wrk1);
                        Uncmin.lnsrch_f77(n, x, f, g, p, xpls, fpls, minclass, mxtake, iretcd, stepmx, steptl, sx);
                    } else {
                        dlt[1] = dltsav;
                        if (method == Method.DOUBLE_DOGLEG) {
                            for (i = 1; i <= n; ++i) {
                                wrk1[i] = -g[i];
                            }
                            Uncmin.lltslv_f77(n, a, p, wrk1);
                            Uncmin.dogdrv_f77(n, x, f, g, a, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, wrk0, wrk1, wrk2, wrk3);
                        } else {
                            amu[1] = amusav;
                            dltp[1] = dlpsav;
                            phi[1] = phisav;
                            phip0[1] = phpsav;
                            Uncmin.chlhsn_f77(n, a, epsm, sx, udiag);
                            for (i = 1; i <= n; ++i) {
                                wrk1[i] = -g[i];
                            }
                            Uncmin.lltslv_f77(n, a, p, wrk1);
                            Uncmin.hookdr_f77(n, x, f, g, a, udiag, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, amu, dltp, phi, phip0, wrk0, wrk1, wrk2, epsm, itncnt);
                        }
                    }
                }
                for (i = 1; i <= n; ++i) {
                    p[i] = xpls[i] - x[i];
                }
                if (iagflg[1] == -1) {
                    Uncmin.fstocd_f77(n, xpls, minclass, sx, rnf, gpls);
                } else if (iagflg[1] == 0) {
                    Uncmin.fstofd_f77(n, xpls, minclass, fpls, gpls, sx, rnf);
                } else {
                    minclass.applyGradient(xpls, gpls);
                }
                Uncmin.optstp_f77(n, xpls, fpls, gpls, x, itncnt, icscmx, itrmcd, gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, msg);
                if (itrmcd[1] != 0) continue;
                if (iexp) {
                    if (method == Method.MORE_HEBDON) {
                        Uncmin.secunf_f77(n, x, g, a, udiag, xpls, gpls, epsm, itncnt, rnf, iagflg, noupdt, wrk1, wrk2, wrk3);
                    } else {
                        Uncmin.secfac_f77(n, x, g, a, xpls, gpls, epsm, itncnt, rnf, iagflg, noupdt, wrk0, wrk1, wrk2, wrk3);
                    }
                } else if (iahflg[1] == 1) {
                    minclass.applyHessian(xpls, a);
                } else if (iagflg[1] == 1) {
                    Uncmin.fstofd_f77(n, xpls, minclass, gpls, a, sx, rnf, wrk1);
                } else {
                    Uncmin.sndofd_f77(n, xpls, minclass, fpls, a, sx, rnf, wrk1, wrk2);
                }
                if (msg[1] / 16 % 2 == 1) {
                    Uncmin.result_f77(n, xpls, fpls, gpls, a, p, itncnt, 1);
                }
                f[1] = fpls[1];
                for (i = 1; i <= n; ++i) {
                    x[i] = xpls[i];
                    g[i] = gpls[i];
                }
            }
            if (itrmcd[1] == 3) {
                fpls[1] = f[1];
                for (i = 1; i <= n; ++i) {
                    xpls[i] = x[i];
                    gpls[i] = g[i];
                }
            }
        }
        if (msg[1] / 8 % 2 == 0) {
            Uncmin.result_f77(n, xpls, fpls, gpls, a, p, itncnt, 0);
        }
        msg[1] = 0;
    }

    public static void optstp_f77(int n, double[] xpls, double[] fpls, double[] gpls, double[] x, int[] itncnt, int[] icscmx, int[] itrmcd, double[] gradtl, double[] steptl, double[] sx, double fscale, int[] itnlim, int[] iretcd, boolean[] mxtake, int[] msg) {
        int i;
        itrmcd[1] = 0;
        if (iretcd[1] == 1) {
            itrmcd[1] = 3;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    The last global step failed");
                System.out.print(" to locate a point lower than x.\n");
                System.out.print("OPTSTP    Either x is an approximate local");
                System.out.print(" minimum of the function,\n");
                System.out.print("OPTSTP    the function is too nonlinear for");
                System.out.print(" this algorithm, or\n");
                System.out.print("OPTSTP    steptl is too large.\n");
            }
            return;
        }
        double d = Math.max(Math.abs(fpls[1]), fscale);
        double rgx = 0.0;
        for (i = 1; i <= n; ++i) {
            double relgrd = Math.abs(gpls[i]) * Math.max(Math.abs(xpls[i]), 1.0 / sx[i]) / d;
            rgx = Math.max(rgx, relgrd);
        }
        if (rgx <= gradtl[1]) {
            itrmcd[1] = 1;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    The relative gradient is close");
                System.out.print(" to zero.\n");
                System.out.print("OPTSTP    The current iterate is probably");
                System.out.print(" a solution.\n");
            }
            return;
        }
        if (itncnt[1] == 0) {
            return;
        }
        double rsx = 0.0;
        for (i = 1; i <= n; ++i) {
            double relstp = Math.abs(xpls[i] - x[i]) / Math.max(Math.abs(xpls[i]), 1.0 / sx[i]);
            rsx = Math.max(rsx, relstp);
        }
        if (rsx <= steptl[1]) {
            itrmcd[1] = 2;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    Successive iterates are within");
                System.out.print(" steptl.\n");
                System.out.print("OPTSTP    The current iterate is probably");
                System.out.print(" a solution.\n");
            }
            return;
        }
        if (itncnt[1] >= itnlim[1]) {
            itrmcd[1] = 4;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    The iteration limit was reached.\n");
                System.out.print("OPTSTP    The algorithm failed.\n");
            }
            return;
        }
        if (!mxtake[1]) {
            icscmx[1] = 0;
            return;
        }
        if (msg[1] / 8 % 2 == 0) {
            System.out.print("\n\nOPTSTP    Step of maximum length (stepmx)");
            System.out.print(" taken.\n");
        }
        icscmx[1] = icscmx[1] + 1;
        if (icscmx[1] < 5) {
            return;
        }
        itrmcd[1] = 5;
        if (msg[1] / 8 % 2 == 0) {
            System.out.print("\n\nOPTSTP    Maximum step size exceeded");
            System.out.print(" five consecutive times.\n");
            System.out.print("OPTSTP    Either the function is unbounded");
            System.out.print(" below,\n");
            System.out.print("OPTSTP    becomes asymptotic to a finite value");
            System.out.print(" from above in some direction, or\n");
            System.out.print("OPTSTP    stepmx is too small.\n");
        }
    }

    public static void qraux1_f77(int n, double[][] r, int i) {
        int ip1 = i + 1;
        for (int j = i; j <= n; ++j) {
            double tmp = r[i][j];
            r[i][j] = r[ip1][j];
            r[ip1][j] = tmp;
        }
    }

    public static void qraux2_f77(int n, double[][] r, int i, double a, double b) {
        int ip1 = i + 1;
        double den = Math.sqrt(a * a + b * b);
        double c2 = a / den;
        double s = b / den;
        for (int j = i; j <= n; ++j) {
            double y = r[i][j];
            double z = r[ip1][j];
            r[i][j] = c2 * y - s * z;
            r[ip1][j] = s * y + c2 * z;
        }
    }

    public static void qrupdt_f77(int n, double[][] a, double[] u, double[] v) {
        int i;
        int k;
        for (k = n; u[k] == 0.0 && k > 1; --k) {
        }
        int km1 = k - 1;
        for (int ii = 1; ii <= km1; ++ii) {
            i = km1 - ii + 1;
            if (u[i] == 0.0) {
                Uncmin.qraux1_f77(n, a, i);
                u[i] = u[i + 1];
                continue;
            }
            Uncmin.qraux2_f77(n, a, i, u[i], -u[i + 1]);
            u[i] = Math.sqrt(u[i] * u[i] + u[i + 1] * u[i + 1]);
        }
        for (int j = 1; j <= n; ++j) {
            double[] dArray = a[1];
            int n2 = j;
            dArray[n2] = dArray[n2] + u[1] * v[j];
        }
        km1 = k - 1;
        for (i = 1; i <= km1; ++i) {
            if (a[i][i] == 0.0) {
                Uncmin.qraux1_f77(n, a, i);
                continue;
            }
            double t1 = a[i][i];
            double t2 = -a[i + 1][i];
            Uncmin.qraux2_f77(n, a, i, t1, t2);
        }
    }

    public static void result_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] p, int[] itncnt, int iflg) {
        int j;
        int i;
        int ihigh;
        int ilow;
        int num5 = n / 5;
        int remain = n % 5;
        System.out.print("\n\nRESULT      Iterate k = " + itncnt[1] + "\n");
        if (iflg != 0) {
            System.out.print("\n\nRESULT      Step\n\n");
            ilow = -4;
            ihigh = 0;
            for (i = 1; i <= num5; ++i) {
                System.out.print((ilow += 5) + "--" + (ihigh += 5) + "     ");
                for (j = 1; j <= 5; ++j) {
                    System.out.print(p[ilow + j - 1] + "  ");
                }
                System.out.print("\n");
            }
            ihigh = (ilow += 5) + remain - 1;
            System.out.print(ilow + "--" + ihigh + "     ");
            for (j = 1; j <= remain; ++j) {
                System.out.print(p[ilow + j - 1] + "  ");
            }
            System.out.print("\n");
        }
        System.out.print("\n\nRESULT      Current x\n\n");
        ilow = -4;
        ihigh = 0;
        for (i = 1; i <= num5; ++i) {
            System.out.print((ilow += 5) + "--" + (ihigh += 5) + "     ");
            for (j = 1; j <= 5; ++j) {
                System.out.print(x[ilow + j - 1] + "  ");
            }
            System.out.print("\n");
        }
        ihigh = (ilow += 5) + remain - 1;
        System.out.print(ilow + "--" + ihigh + "     ");
        for (j = 1; j <= remain; ++j) {
            System.out.print(x[ilow + j - 1] + "  ");
        }
        System.out.print("\n");
        System.out.print("\n\nRESULT      f_to_minimize at x = " + f[1] + "\n");
        System.out.print("\n\nRESULT      Gradient at x\n\n");
        ilow = -4;
        ihigh = 0;
        for (i = 1; i <= num5; ++i) {
            System.out.print((ilow += 5) + "--" + (ihigh += 5) + "     ");
            for (j = 1; j <= 5; ++j) {
                System.out.print(g[ilow + j - 1] + "  ");
            }
            System.out.print("\n");
        }
        ihigh = (ilow += 5) + remain - 1;
        System.out.print(ilow + "--" + ihigh + "     ");
        for (j = 1; j <= remain; ++j) {
            System.out.print(g[ilow + j - 1] + "  ");
        }
        System.out.print("\n");
        if (iflg != 0) {
            System.out.print("\n\nRESULT      Hessian at x\n\n");
            for (int iii = 1; iii <= n; ++iii) {
                int iii5 = iii / 5;
                int iiir = iii % 5;
                ilow = -4;
                ihigh = 0;
                for (i = 1; i <= iii5; ++i) {
                    System.out.print("i = " + iii + ", j = ");
                    System.out.print((ilow += 5) + "--" + (ihigh += 5) + "     ");
                    for (j = 1; j <= 5; ++j) {
                        System.out.print(a[iii][ilow + j - 1] + "  ");
                    }
                    System.out.print("\n");
                }
                ihigh = (ilow += 5) + iiir - 1;
                System.out.print("i = " + iii + ", j = ");
                System.out.print(ilow + "--" + ihigh + "     ");
                for (j = 1; j <= iiir; ++j) {
                    System.out.print(a[iii][ilow + j - 1] + "  ");
                }
                System.out.print("\n");
            }
        }
    }

    public static void sclmul_f77(int n, double s, double[] v, double[] z) {
        for (int i = 1; i <= n; ++i) {
            z[i] = s * v[i];
        }
    }

    public static void secfac_f77(int n, double[] x, double[] g, double[][] a, double[] xpls, double[] gpls, double epsm, int[] itncnt, double rnf, int[] iagflg, boolean[] noupdt, double[] s, double[] y, double[] u, double[] w) {
        int i;
        if (itncnt[1] == 1) {
            noupdt[1] = true;
        }
        for (i = 1; i <= n; ++i) {
            s[i] = xpls[i] - x[i];
            y[i] = gpls[i] - g[i];
        }
        double den1 = Blas_f77.ddot_f77(n, s, 1, y, 1);
        double snorm2 = Blas_f77.dnrm2_f77(n, s, 1);
        double ynrm2 = Blas_f77.dnrm2_f77(n, y, 1);
        if (den1 >= Math.sqrt(epsm) * snorm2 * ynrm2) {
            int j;
            Uncmin.mvmltu_f77(n, a, s, u);
            double den2 = Blas_f77.ddot_f77(n, u, 1, u, 1);
            double alp = Math.sqrt(den1 / den2);
            if (noupdt[1]) {
                for (j = 1; j <= n; ++j) {
                    int n2 = j;
                    u[n2] = u[n2] * alp;
                    for (i = j; i <= n; ++i) {
                        double[] dArray = a[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] * alp;
                    }
                }
                noupdt[1] = false;
                den2 = den1;
                alp = 1.0;
            }
            boolean skpupd = true;
            Uncmin.mvmltl_f77(n, a, u, w);
            i = 1;
            double reltol = iagflg[1] == 0 ? Math.sqrt(rnf) : rnf;
            while (i <= n && skpupd) {
                if (Math.abs(y[i] - w[i]) >= reltol * Math.max(Math.abs(g[i]), Math.abs(gpls[i]))) {
                    skpupd = false;
                    continue;
                }
                ++i;
            }
            if (!skpupd) {
                int im1;
                for (i = 1; i <= n; ++i) {
                    w[i] = y[i] - alp * w[i];
                }
                alp /= den1;
                i = 1;
                while (i <= n) {
                    int n4 = i++;
                    u[n4] = u[n4] * alp;
                }
                for (i = 2; i <= n; ++i) {
                    im1 = i - 1;
                    for (j = 1; j <= im1; ++j) {
                        a[j][i] = a[i][j];
                        a[i][j] = 0.0;
                    }
                }
                Uncmin.qrupdt_f77(n, a, u, w);
                for (i = 2; i <= n; ++i) {
                    im1 = i - 1;
                    for (j = 1; j <= im1; ++j) {
                        a[i][j] = a[j][i];
                    }
                }
            }
        }
    }

    public static void secunf_f77(int n, double[] x, double[] g, double[][] a, double[] udiag, double[] xpls, double[] gpls, double epsm, int[] itncnt, double rnf, int[] iagflg, boolean[] noupdt, double[] s, double[] y, double[] t2) {
        int i;
        int j;
        for (j = 1; j <= n; ++j) {
            a[j][j] = udiag[j];
            for (i = j + 1; i <= n; ++i) {
                a[i][j] = a[j][i];
            }
        }
        if (itncnt[1] == 1) {
            noupdt[1] = true;
        }
        for (i = 1; i <= n; ++i) {
            s[i] = xpls[i] - x[i];
            y[i] = gpls[i] - g[i];
        }
        double den1 = Blas_f77.ddot_f77(n, s, 1, y, 1);
        double snorm2 = Blas_f77.dnrm2_f77(n, s, 1);
        double ynrm2 = Blas_f77.dnrm2_f77(n, y, 1);
        if (den1 >= Math.sqrt(epsm) * snorm2 * ynrm2) {
            Uncmin.mvmlts_f77(n, a, s, t2);
            double den2 = Blas_f77.ddot_f77(n, s, 1, t2, 1);
            if (noupdt[1]) {
                double gam = den1 / den2;
                den2 = gam * den2;
                for (j = 1; j <= n; ++j) {
                    int n2 = j;
                    t2[n2] = t2[n2] * gam;
                    for (i = j; i <= n; ++i) {
                        double[] dArray = a[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] * gam;
                    }
                }
                noupdt[1] = false;
            }
            boolean skpupd = true;
            for (i = 1; i <= n; ++i) {
                double tol = rnf * Math.max(Math.abs(g[i]), Math.abs(gpls[i]));
                if (iagflg[1] == 0) {
                    tol /= Math.sqrt(rnf);
                }
                if (!(Math.abs(y[i] - t2[i]) >= tol)) continue;
                skpupd = false;
                break;
            }
            if (!skpupd) {
                for (j = 1; j <= n; ++j) {
                    for (i = j; i <= n; ++i) {
                        double[] dArray = a[i];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + (y[i] * y[j] / den1 - t2[i] * t2[j] / den2);
                    }
                }
            }
        }
    }

    public static void sndofd_f77(int n, double[] xpls, UncminFunction minclass, double[] fpls, double[][] a, double[] sx, double rnoise, double[] stepsz, double[] anbr) {
        double xtmpi;
        int i;
        double xmult = Math.pow(rnoise, 0.3333333333333333);
        for (i = 1; i <= n; ++i) {
            stepsz[i] = xmult * Math.max(Math.abs(xpls[i]), 1.0 / sx[i]);
            xtmpi = xpls[i];
            xpls[i] = xtmpi + stepsz[i];
            anbr[i] = minclass.apply(xpls);
            xpls[i] = xtmpi;
        }
        for (i = 1; i <= n; ++i) {
            xtmpi = xpls[i];
            xpls[i] = xtmpi + 2.0 * stepsz[i];
            double fhat = minclass.apply(xpls);
            a[i][i] = (fpls[1] - anbr[i] + (fhat - anbr[i])) / (stepsz[i] * stepsz[i]);
            if (i != n) {
                xpls[i] = xtmpi + stepsz[i];
                for (int j = i + 1; j <= n; ++j) {
                    double xtmpj = xpls[j];
                    xpls[j] = xtmpj + stepsz[j];
                    fhat = minclass.apply(xpls);
                    a[j][i] = (fpls[1] - anbr[i] + (fhat - anbr[j])) / (stepsz[i] * stepsz[j]);
                    xpls[j] = xtmpj;
                }
            }
            xpls[i] = xtmpi;
        }
    }

    public static void tregup_f77(int n, double[] x, double[] f, double[] g, double[][] a, UncminFunction minclass, double[] sc, double[] sx, boolean[] nwtake, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, double[] xplsp, double[] fplsp, double[] xpls, double[] fpls, boolean[] mxtake, int method, double[] udiag) {
        int i;
        mxtake[1] = false;
        for (i = 1; i <= n; ++i) {
            xpls[i] = x[i] + sc[i];
        }
        fpls[1] = minclass.apply(xpls);
        double dltf = fpls[1] - f[1];
        double slp = Blas_f77.ddot_f77(n, g, 1, sc, 1);
        if (iretcd[1] == 4) {
            fplsp[1] = 0.0;
        }
        if (iretcd[1] == 3 && (fpls[1] >= fplsp[1] || dltf > 1.0E-4 * slp)) {
            iretcd[1] = 0;
            for (i = 1; i <= n; ++i) {
                xpls[i] = xplsp[i];
            }
            fpls[1] = fplsp[1];
            dlt[1] = dlt[1] * 0.5;
        } else if (dltf > 1.0E-4 * slp) {
            double rln = 0.0;
            for (i = 1; i <= n; ++i) {
                rln = Math.max(rln, Math.abs(sc[i]) / Math.max(Math.abs(xpls[i]), 1.0 / sx[i]));
            }
            if (rln < steptl[1]) {
                iretcd[1] = 1;
            } else {
                iretcd[1] = 2;
                double dltmp = -slp * dlt[1] / (2.0 * (dltf - slp));
                dlt[1] = dltmp < 0.1 * dlt[1] ? dlt[1] * 0.1 : dltmp;
            }
        } else {
            int j;
            double temp;
            double dltfp = 0.0;
            if (method == 2) {
                for (i = 1; i <= n; ++i) {
                    temp = 0.0;
                    for (j = i; j <= n; ++j) {
                        temp += a[j][i] * sc[j];
                    }
                    dltfp += temp * temp;
                }
            } else {
                for (i = 1; i <= n; ++i) {
                    dltfp += udiag[i] * sc[i] * sc[i];
                    temp = 0.0;
                    for (j = i + 1; j <= n; ++j) {
                        temp += a[i][j] * sc[i] * sc[j];
                    }
                    dltfp += 2.0 * temp;
                }
            }
            dltfp = slp + dltfp / 2.0;
            if (iretcd[1] != 2 && Math.abs(dltfp - dltf) <= 0.1 * Math.abs(dltf) && !nwtake[1] && dlt[1] <= 0.99 * stepmx[1]) {
                iretcd[1] = 3;
                for (i = 1; i <= n; ++i) {
                    xplsp[i] = xpls[i];
                }
                fplsp[1] = fpls[1];
                dlt[1] = Math.min(2.0 * dlt[1], stepmx[1]);
            } else {
                iretcd[1] = 0;
                if (dlt[1] > 0.99 * stepmx[1]) {
                    mxtake[1] = true;
                }
                if (dltf >= 0.1 * dltfp) {
                    dlt[1] = dlt[1] * 0.5;
                } else if (dltf <= 0.75 * dltfp) {
                    dlt[1] = Math.min(2.0 * dlt[1], stepmx[1]);
                }
            }
        }
    }

    static double[][] f77_array(int size_1, int size_2) {
        return new double[size_1 + 1][size_1 + 1];
    }

    static double[] f77_array(int size) {
        return new double[size + 1];
    }

    static double[] from_f77(double[] src) {
        double[] dst = new double[src.length - 1];
        System.arraycopy(src, 1, dst, 0, src.length - 1);
        return dst;
    }

    static double[] to_f77(double[] src) {
        double[] copy2 = new double[src.length + 1];
        System.arraycopy(src, 0, copy2, 1, src.length);
        return copy2;
    }

    public static enum Method {
        LINE_SEARCH,
        DOUBLE_DOGLEG,
        MORE_HEBDON;

    }
}

